/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.color;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.color.AbstractColorDrawable;
import cgdp.recog.color.BlankColorDrawable;
import cgdp.recog.color.ColorDrawable;
import cgdp.recog.color.DefaultColorDrawable;
import cgdp.recog.color.GeneCountColorDrawable;
import cgdp.recog.color.GeneInfoColorDrawable;
import cgdp.recog.color.NeighboringClusterColorDrawable;
import cgdp.recog.color.SearchColorDrawable;
import cgdp.recog.color.SetColorDrawable;
import cgdp.recog.controltree.ControlTitleType;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionValues;
import cgdp.recog.organism.Organism;
import cgdp.recog.project.Project;
import cgdp.recog.set.SetCondition;
import cgdp.recog.set.SetType;
import cgdp.recog.system.property.ApplicationProperty;
import cgdp.recog.system.property.ApplicationPropertyAccessable;
import cgdp.recog.system.property.ApplicationPropertyFacade;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.ColorUtil;
import cgdp.recog.util.StringTool;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class ColorDrawableManager
implements ApplicationPropertyAccessable {
    private static final ApplicationLogger logger = new ApplicationLogger(ColorDrawableManager.class);
    private static final String DELIMITER = ":";
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;
    private List colorOrderList = new ArrayList();
    private Map colorDrawableMap = new HashMap();
    private BlankColorDrawable blankColorDrawable;

    public ColorDrawableManager(MediatorImpl mediatorImpl) {
        this.mediator = mediatorImpl;
        this.init();
    }

    private void init() {
        this.clearCondition();
        this.blankColorDrawable = new BlankColorDrawable(this.mediator);
        DefaultColorDrawable defaultColorDrawable = new DefaultColorDrawable(this.mediator);
        GeneCountColorDrawable geneCountColorDrawable = new GeneCountColorDrawable(this.mediator);
        this.addColorDrawable(defaultColorDrawable);
        this.addColorDrawable(geneCountColorDrawable);
    }

    void clearCondition() {
        this.colorDrawableMap.clear();
        this.colorOrderList.clear();
    }

    private void addColorDrawable(ColorDrawable colorDrawable) {
        colorDrawable.setClusterTbl(this.clusterTbl);
        Integer n = new Integer(colorDrawable.getType());
        ArrayList<ColorDrawable> arrayList = (ArrayList<ColorDrawable>)this.colorDrawableMap.get(n);
        if (CollectionUtil.isNull(arrayList)) {
            arrayList = new ArrayList<ColorDrawable>();
            this.colorDrawableMap.put(n, arrayList);
        }
        arrayList.add(colorDrawable);
        this.colorOrderList.remove(n);
        this.colorOrderList.add(0, n);
    }

    private void removeColorDrawable(int n) {
        Integer n2 = new Integer(n);
        this.colorDrawableMap.remove(n2);
        this.colorOrderList.remove(n2);
    }

    public void addNeighboringColorDrawable() {
        NeighboringClusterColorDrawable neighboringClusterColorDrawable = new NeighboringClusterColorDrawable(this.mediator);
        this.removeColorDrawable(neighboringClusterColorDrawable.getType());
        neighboringClusterColorDrawable.setClusterTbl(this.clusterTbl);
        this.addColorDrawable(neighboringClusterColorDrawable);
    }

    public void addSearchColorDrawable() {
        SearchColorDrawable searchColorDrawable = new SearchColorDrawable(this.mediator);
        this.removeColorDrawable(searchColorDrawable.getType());
        searchColorDrawable.setClusterTbl(this.clusterTbl);
        this.addColorDrawable(searchColorDrawable);
    }

    public void removeSearchColorDrawable() {
        this.removeColorDrawable(34);
    }

    public void addGeneInfoColorDrawable() {
        GeneInfoColorDrawable geneInfoColorDrawable = new GeneInfoColorDrawable(this.mediator);
        this.removeColorDrawable(geneInfoColorDrawable.getType());
        geneInfoColorDrawable.setClusterTbl(this.clusterTbl);
        this.addColorDrawable(geneInfoColorDrawable);
    }

    public void removeGeneInfoColorDrawable() {
        this.removeColorDrawable(32);
    }

    public void addSetColorDrawable(Collection collection) {
        for (SetCondition setCondition : collection) {
            this.addSetColorDrawable(setCondition);
        }
    }

    public void addSetColorDrawable(SetCondition setCondition) {
        if (setCondition == null) {
            return;
        }
        if (this.containsSetCondition(setCondition)) {
            return;
        }
        int n = this.getSetControlTitleType(setCondition);
        SetColorDrawable setColorDrawable = new SetColorDrawable(this.mediator, n, setCondition);
        setColorDrawable.setClusterTbl(this.clusterTbl);
        setColorDrawable.setColorActive(true);
        this.addColorDrawable(setColorDrawable);
    }

    public void removeSetColorDrawable(Collection collection) {
        for (SetCondition setCondition : collection) {
            this.removeSetColorDrawable(setCondition);
        }
    }

    public void removeSetColorDrawable(SetCondition setCondition) {
        int n = this.getSetControlTitleType(setCondition);
        List list = this.getColorDrawableList(n);
        if (CollectionUtil.isNull(list)) {
            return;
        }
        SetColorDrawable setColorDrawable = null;
        for (SetColorDrawable setColorDrawable2 : list) {
            SetCondition setCondition2 = setColorDrawable2.getSetCondition();
            if (!setCondition2.equalsSetCondition(setCondition)) continue;
            setColorDrawable = setColorDrawable2;
            break;
        }
        list.remove(setColorDrawable);
        if (CollectionUtil.isNull(list)) {
            Integer n2 = new Integer(n);
            this.colorDrawableMap.remove(n2);
            this.colorOrderList.remove(n2);
        }
    }

    private int getSetControlTitleType(SetCondition setCondition) {
        int n = 37;
        if (setCondition.isGeneSet()) {
            n = 36;
        }
        return n;
    }

    public ColorDrawable getPrimaryColorDrawable(Cluster cluster, Organism organism) {
        ColorDrawable colorDrawable = null;
        for (Integer n : this.getColorOrderList()) {
            List list = (List)this.colorDrawableMap.get(n);
            for (ColorDrawable colorDrawable2 : list) {
                if (!colorDrawable2.isColorActive() || !colorDrawable2.isEnableDraw(cluster, organism)) continue;
                colorDrawable = colorDrawable2;
                break;
            }
            if (colorDrawable == null) continue;
            break;
        }
        if (colorDrawable == null) {
            return this.getBlankColorDrawable();
        }
        return colorDrawable;
    }

    private BlankColorDrawable getBlankColorDrawable() {
        return this.blankColorDrawable;
    }

    private DefaultColorDrawable getDefaultColorDrawable() {
        List list = (List)this.colorDrawableMap.get(new Integer(930));
        return (DefaultColorDrawable)list.get(0);
    }

    public Color getBlankColor(String string) {
        DefaultColorDrawable defaultColorDrawable = this.getDefaultColorDrawable();
        if (defaultColorDrawable != null && defaultColorDrawable.isColorActive()) {
            return this.getIngroupColor();
        }
        return this.getBlankColorDrawable().getColor();
    }

    protected Color getIngroupColor() {
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        Color color = ColorUtil.str2Color(optionValues.getIngroupColorString());
        return color;
    }

    public void saveColor() throws Exception {
        OptionTbl optionTbl = OptionTbl.getInstance();
        optionTbl.writeOption();
        ArrayList<ApplicationPropertyAccessable> arrayList = new ArrayList<ApplicationPropertyAccessable>();
        arrayList.add(this.clusterTbl.getSetConditionGroup());
        arrayList.add(this.clusterTbl.getBaseColorCondition());
        arrayList.add(this);
        ApplicationPropertyFacade.saveProperty(this.clusterTbl.getClusterId(), arrayList);
    }

    public ColorDrawable getNextColorDrawable(ColorDrawable colorDrawable) {
        Object e;
        List list;
        ColorDrawable colorDrawable2 = null;
        int n = this.colorOrderList.indexOf(new Integer(colorDrawable.getType()));
        if (n < this.colorOrderList.size() - 1 && !CollectionUtil.isNull(list = (List)this.colorDrawableMap.get(e = this.colorOrderList.get(n + 1)))) {
            colorDrawable2 = (ColorDrawable)list.get(0);
        }
        return colorDrawable2;
    }

    public ColorDrawable getNeighboringClusterColorDrawable() {
        List list = this.getColorDrawableList(35);
        if (CollectionUtil.isNull(list)) {
            return null;
        }
        return (ColorDrawable)list.get(0);
    }

    public List getColorOrderList() {
        return this.colorOrderList;
    }

    public Map getColorDrawableMap() {
        return this.colorDrawableMap;
    }

    private List getColorDrawableList(int n) {
        return (List)this.colorDrawableMap.get(new Integer(n));
    }

    public void setClusterTbl(ClusterTbl clusterTbl) {
        this.clusterTbl = clusterTbl;
        this.blankColorDrawable.setClusterTbl(clusterTbl);
        if (!this.isExistColorDrawable()) {
            this.init();
        }
        for (List list : this.colorDrawableMap.values()) {
            for (ColorDrawable colorDrawable : list) {
                colorDrawable.setClusterTbl(clusterTbl);
            }
        }
    }

    public void updateOrder(int n, List list) {
        this.colorOrderList.removeAll(list);
        int n2 = this.colorOrderList.indexOf(new Integer(n)) + 1;
        if (n2 < 0) {
            n2 = 0;
        }
        this.colorOrderList.addAll(n2, list);
    }

    private boolean isExistColorDrawable() {
        return !CollectionUtil.isNull(this.colorOrderList);
    }

    public String getCategory() {
        return "ColorFilterSet";
    }

    public List getPropertyList(Project project, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        Object object = this.colorOrderList.iterator();
        while (object.hasNext()) {
            int n2 = (Integer)object.next();
            if (ControlTitleType.isColorSearch(n2) || ControlTitleType.isColorGeneInfo(n2) || ControlTitleType.isColorNeighbor(n2)) {
                ++n;
                continue;
            }
            stringBuffer.append(n2);
            if (n != this.colorOrderList.size() - 1) {
                stringBuffer.append(DELIMITER);
            }
            ++n;
        }
        object = new ArrayList();
        object.add(ApplicationProperty.createProjectProperty(this.getCategory(), "ColorFilterSetColorOrder", stringBuffer.toString()));
        String string2 = this.createSetCondition2Str(36);
        object.add(ApplicationProperty.createProjectProperty(this.getCategory(), "ColorFilterSetGeneColorNameList", string2));
        String string3 = this.createSetCondition2Str(37);
        object.add(ApplicationProperty.createProjectProperty(this.getCategory(), "ColorFilterSetClusterColorNameList", string3));
        return object;
    }

    private String createSetCondition2Str(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = this.getColorDrawableList(n);
        if (CollectionUtil.isNull(list)) {
            return null;
        }
        for (SetColorDrawable setColorDrawable : this.getColorDrawableList(n)) {
            SetCondition setCondition = setColorDrawable.getSetCondition();
            arrayList.add(setCondition.getName());
        }
        return StringTool.conbineStrList(arrayList, ",");
    }

    public int getPropertyType() {
        return 2;
    }

    public void updateProperty(Map map, Project project, String string) {
        String string2;
        Object object;
        this.clearCondition();
        HashSet hashSet = new HashSet();
        if (map.containsKey("ColorFilterSetGeneColorNameList")) {
            object = (String)map.get("ColorFilterSetGeneColorNameList");
            hashSet.addAll(new ArrayList(StringTool.splitString((String)object, ",")));
        }
        object = new HashSet();
        if (map.containsKey("ColorFilterSetClusterColorNameList")) {
            string2 = (String)map.get("ColorFilterSetClusterColorNameList");
            object.addAll(new ArrayList(StringTool.splitString(string2, ",")));
        }
        if (map.containsKey("ColorFilterSetColorOrder")) {
            string2 = (String)map.get("ColorFilterSetColorOrder");
            Vector vector = StringTool.splitString(string2, DELIMITER);
            for (String string3 : vector) {
                int n;
                try {
                    n = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    logger.warn("Fail to parse control title type. [" + string3 + "]", numberFormatException);
                    continue;
                }
                if (ControlTitleType.isColorSearch(n) || ControlTitleType.isColorGeneInfo(n) || ControlTitleType.isColorNeighbor(n)) continue;
                List list = this.createColorDrawable(n, hashSet, (Set)object);
                for (ColorDrawable colorDrawable : list) {
                    colorDrawable.setClusterTbl(this.clusterTbl);
                }
                if (CollectionUtil.isNull(list)) continue;
                this.colorOrderList.add(new Integer(n));
                this.colorDrawableMap.put(new Integer(n), list);
            }
        }
    }

    public boolean containsSetCondition(SetCondition setCondition) {
        int n = SetType.getColorControlTitleTypeFromSetType(setCondition.getSetType());
        List list = this.getColorDrawableList(n);
        if (CollectionUtil.isNull(list)) {
            return false;
        }
        for (SetColorDrawable setColorDrawable : list) {
            SetCondition setCondition2 = setColorDrawable.getSetCondition();
            if (!setCondition2.equalsSetCondition(setCondition)) continue;
            return true;
        }
        return false;
    }

    private List createColorDrawable(int n, Set set, Set set2) {
        ArrayList<AbstractColorDrawable> arrayList = new ArrayList<AbstractColorDrawable>();
        if (ControlTitleType.isColorDefault(n)) {
            arrayList.add(new DefaultColorDrawable(this.mediator));
        } else if (ControlTitleType.isColorGeneCount(n)) {
            arrayList.add(new GeneCountColorDrawable(this.mediator));
        } else if (ControlTitleType.isColorGeneInfo(n)) {
            arrayList.add(new GeneInfoColorDrawable(this.mediator));
        } else if (ControlTitleType.isColorGeneSet(n)) {
            for (SetCondition setCondition : this.clusterTbl.getSetConditionList(1)) {
                if (!set.contains(setCondition.getName())) continue;
                arrayList.add(new SetColorDrawable(this.mediator, n, setCondition));
            }
        } else if (ControlTitleType.isColorClusterSet(n)) {
            for (SetCondition setCondition : this.clusterTbl.getSetConditionList(2)) {
                if (!set2.contains(setCondition.getName())) continue;
                arrayList.add(new SetColorDrawable(this.mediator, n, setCondition));
            }
        } else if (ControlTitleType.isColorNeighbor(n)) {
            arrayList.add(new NeighboringClusterColorDrawable(this.mediator));
        }
        return arrayList;
    }
}

