/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.color;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.color.AbstractColorDrawable;
import cgdp.recog.data.Cluster;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionValues;
import cgdp.recog.organism.Organism;
import cgdp.recog.util.ApplicationLogger;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.List;
import java.util.Map;

class GeneCountColorDrawable
extends AbstractColorDrawable {
    private static final ApplicationLogger logger = new ApplicationLogger(GeneCountColorDrawable.class);

    GeneCountColorDrawable(MediatorImpl mediatorImpl) {
        super(mediatorImpl, 31);
    }

    public String getNodeLabel() {
        return "Gene count [>=" + this.getThresholdGeneCount() + "]";
    }

    public void setColorActive(boolean bl) {
        OptionTbl optionTbl = OptionTbl.getInstance();
        OptionValues optionValues = optionTbl.getOptionValues();
        optionValues.setGeneCountColorFlag(bl);
        try {
            optionTbl.writeOption();
        }
        catch (IOException iOException) {
            logger.warn("Fail to save options.", iOException);
        }
    }

    public boolean isColorActive() {
        OptionTbl optionTbl = OptionTbl.getInstance();
        OptionValues optionValues = optionTbl.getOptionValues();
        return optionValues.isGeneCountColorFlag();
    }

    public boolean isEnableDraw(Cluster cluster, Organism organism) {
        if (cluster == null) {
            return false;
        }
        String string = organism.getOrganismCode();
        List list = cluster.getLocusTagList(string);
        if (list == null) {
            return false;
        }
        int n = cluster.getLocusTagList(string).size();
        return this.isDrawByGeneCount(n);
    }

    public Color drawPPMCell(Graphics2D graphics2D, double d, double d2, double d3, double d4, Cluster cluster, Organism organism, Map map) {
        Color color = this.getGeneCountCellColor();
        graphics2D.setColor(color);
        graphics2D.fill(new Rectangle2D.Double(d, d2, d3, d4));
        return color;
    }

    public boolean isDrawByGeneCount(int n) {
        return this.isShowGeneCountColor() && n >= this.getThresholdGeneCount();
    }

    public Color getColor(Cluster cluster, String string, String string2) {
        return this.getGeneCountCellColor();
    }

    public void drawPPMLabel(Graphics2D graphics2D, Cluster cluster, Organism organism, double d, double d2, double d3, double d4, double d5, double d6, int n, Color color) {
        String string = organism.getOrganismCode();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        List list = cluster.getLocusTagList(string);
        this.drawLocusTag(graphics2D, d4, n -= (list.size() - 1) * fontMetrics.getAscent() / 2, d, list, color);
    }

    public boolean isSyncEnable() {
        return false;
    }
}

