/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.color;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.color.AbstractColorDrawable;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.GeneInformation;
import cgdp.recog.neighbor.NeighborClustPPMColor;
import cgdp.recog.neighbor.NeighboringClustCondition;
import cgdp.recog.neighbor.NeighboringClustExecuter;
import cgdp.recog.organism.Organism;
import cgdp.recog.util.GeneUtil;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class NeighboringClusterColorDrawable
extends AbstractColorDrawable {
    private static final String TITLE = "Neighboring cluster";
    static final AlphaComposite ac = AlphaComposite.getInstance(5, 0.5f);
    static final float line_width = 3.0f;
    static final Stroke stroke = new BasicStroke(3.0f, 0, 0, 10.0f, new float[]{10.0f, 3.0f}, 0.0f);

    NeighboringClusterColorDrawable(MediatorImpl mediatorImpl) {
        super(mediatorImpl, 35);
    }

    public String getNodeLabel() {
        NeighboringClustCondition neighboringClustCondition = this.clusterTbl.getNeighboringClustCondition();
        String string = TITLE;
        if (neighboringClustCondition != null) {
            string = string + "[" + neighboringClustCondition.getLabel() + "]";
        }
        return string;
    }

    public boolean isEnableDraw(Cluster cluster, Organism organism) {
        if (this.clusterTbl == null) {
            return false;
        }
        if (cluster == null) {
            return false;
        }
        return this.clusterTbl.isEnableNeighboringCluster();
    }

    public Color drawPPMCell(Graphics2D graphics2D, double d, double d2, double d3, double d4, Cluster cluster, Organism organism, Map map) {
        Color color = Color.black;
        String string = organism.getOrganismCode();
        Map map2 = this.clusterTbl.getNeighborGroupLocusTagMap(cluster, string);
        if (map2.size() == 1) {
            int n = (Integer)map2.keySet().iterator().next();
            color = NeighborClustPPMColor.getColor(n, string);
            graphics2D.setColor(color);
            if (this.clusterTbl.isHilightNeighboringGene() && this.includeLocusTag(cluster.getLocusTagList(string), map)) {
                NeighboringClusterColorDrawable.fill3DRect(graphics2D, (int)d, (int)d2, (int)d3, (int)d4);
            } else {
                graphics2D.fill(new Rectangle2D.Double(d, d2, d3, d4));
            }
        } else {
            List list = cluster.getGeneInformationList(string);
            double d5 = d4 / (double)list.size();
            double d6 = d2;
            boolean bl = true;
            Iterator iterator = map2.keySet().iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                List list2 = (List)map2.get(new Integer(n));
                double d7 = d5 * (double)list2.size();
                Color color2 = NeighborClustPPMColor.getColor(n, string);
                if (bl) {
                    color = color2;
                    bl = false;
                }
                graphics2D.setColor(color2);
                if (this.clusterTbl.isHilightNeighboringGene() && this.includeLocusTag(list2, map)) {
                    NeighboringClusterColorDrawable.fill3DRect(graphics2D, (int)d, (int)d6, (int)d3, (int)(Math.floor(d6 + d7) - Math.floor(d6)));
                } else {
                    graphics2D.fill(new Rectangle2D.Double(d, d6, d3, d7));
                }
                d6 += d7;
            }
        }
        return color;
    }

    private boolean includeLocusTag(List list, Map map) {
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            if (string == null || !GeneUtil.isDomain(string) || !map.containsKey(GeneUtil.removeDomainNo(string))) continue;
            return true;
        }
        return false;
    }

    public Color getColor(Cluster cluster, String string, String string2) {
        GeneInformation geneInformation = cluster.getGeneInformation(string, string2);
        int n = this.clusterTbl.getNeighborGroupId(geneInformation);
        return NeighborClustPPMColor.getColor(n, string);
    }

    public void drawPPMLabel(Graphics2D graphics2D, Cluster cluster, Organism organism, double d, double d2, double d3, double d4, double d5, double d6, int n, Color color) {
        String string = organism.getOrganismCode();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        List list = cluster.getLocusTagList(string);
        Map map = this.clusterTbl.getNeighborGroupLocusTagMap(cluster, string);
        if (map.size() == 1) {
            this.drawLocusTag(graphics2D, d4, n -= (list.size() - 1) * fontMetrics.getAscent() / 2, d, list, color);
        } else {
            List list2 = cluster.getGeneInformationList(string);
            double d7 = this.clusterTbl.isOutgroup(string) ? d3 : d2;
            double d8 = d7 / (double)list2.size();
            double d9 = this.clusterTbl.isOutgroup(string) ? d6 : d5;
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                int n2 = (Integer)iterator.next();
                List list3 = (List)map.get(new Integer(n2));
                double d10 = d8 * (double)list3.size();
                int n3 = (int)(d9 + d10 / 2.0 - (double)((list3.size() - 1) * fontMetrics.getAscent()) / 2.0 + (double)fontMetrics.getDescent());
                this.drawLocusTag(graphics2D, d4, n3, d, list3, color);
                d9 += d10;
            }
        }
    }

    public boolean isSyncEnable() {
        return false;
    }

    public void setColorActive(boolean bl) {
        boolean bl2 = this.isColorActive();
        super.setColorActive(bl);
        NeighboringClustCondition neighboringClustCondition = this.clusterTbl.getNeighboringClustCondition();
        if (bl && !bl2 && neighboringClustCondition.isNeededRecalc()) {
            neighboringClustCondition.setNeededRecalc(false);
            NeighboringClustExecuter.reexecuteNeighborClustering(null, this.clusterTbl.isExistNeighboringCluster(), this.clusterTbl.getNeighboringClustCondition(), this.mediator);
        }
    }

    private static void fill3DRect(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        Color color = graphics2D.getColor();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.fillRect(n, n2, n3, n4);
        graphics2D.setStroke(NeighboringClusterColorDrawable.stroke);
        graphics2D.setColor(Color.red);
        graphics2D.drawRect((int)((float)n + 1.5f), (int)((float)n2 + 1.5f), (int)((float)n3 - 3.0f), (int)((float)n4 - 3.0f));
        graphics2D.setColor(color);
        graphics2D.setStroke(stroke);
    }

    protected static int getNewRGB(Color color) {
        int n = color.getRed();
        int n2 = NeighboringClusterColorDrawable.getComplement(n);
        int n3 = color.getGreen();
        int n4 = NeighboringClusterColorDrawable.getComplement(n3);
        int n5 = color.getBlue();
        int n6 = NeighboringClusterColorDrawable.getComplement(n5);
        return n2 << 16 + n4 << 8 + n6;
    }

    private static int getComplement(int n) {
        int n2 = n >= 128 ? -n : 255 - n;
        int n3 = (int)Math.round((double)n2 / 2.0);
        int n4 = n + n3;
        return n4;
    }
}

