/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.color;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.color.AbstractColorDrawable;
import cgdp.recog.color.ColorFacade;
import cgdp.recog.data.Cluster;
import cgdp.recog.organism.Organism;
import cgdp.recog.search.SearchCondition;
import cgdp.recog.util.CollectionUtil;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

class SearchColorDrawable
extends AbstractColorDrawable {
    private static final String TITLE = "Keyword search";

    SearchColorDrawable(MediatorImpl mediatorImpl) {
        super(mediatorImpl, 34);
    }

    public String getNodeLabel() {
        SearchCondition searchCondition = this.clusterTbl.getSearchCondition();
        String string = TITLE;
        if (searchCondition != null) {
            string = string + "[" + searchCondition.getLabel() + "]";
        }
        return string;
    }

    public void setColorActive(boolean bl) {
        if (bl) {
            this.mediator.highlightBySearchResult();
        } else {
            this.mediator.clearHighlightBySearchResult();
        }
    }

    public boolean isColorActive() {
        return this.clusterTbl.getSearchResultGroup().isColorActive();
    }

    public boolean isEnableDraw(Cluster cluster, Organism organism) {
        return this.isSearchResultCluster(cluster, organism.getOrganismCode());
    }

    private boolean isSearchResultCluster(Cluster cluster, String string) {
        if (!this.clusterTbl.isEnableHighlightSearchResult()) {
            return false;
        }
        if (this.clusterTbl.isSearchTypeCluster()) {
            return this.clusterTbl.containsSearchResult(cluster);
        }
        return this.clusterTbl.containsSearchResultOrganism(cluster, string);
    }

    public Color drawPPMCell(Graphics2D graphics2D, double d, double d2, double d3, double d4, Cluster cluster, Organism organism, Map map) {
        Color color = Color.black;
        String string = organism.getOrganismCode();
        List list = this.clusterTbl.getSearchResultLocusTagList(cluster, string);
        if (CollectionUtil.isNull(list)) {
            color = ColorFacade.getInstance().getBlankColor(string);
            graphics2D.setColor(color);
            graphics2D.fill(new Rectangle2D.Double(d, d2, d3, d4));
        } else if (this.clusterTbl.isSearchTypeCluster()) {
            color = this.getSearchResultColor();
            graphics2D.setColor(color);
            graphics2D.fill(new Rectangle2D.Double(d, d2, d3, d4));
        } else {
            List list2 = cluster.getGeneInformationList(string);
            if (list2.size() == list.size()) {
                color = this.getSearchResultColor();
                graphics2D.setColor(color);
                graphics2D.fill(new Rectangle2D.Double(d, d2, d3, d4));
            } else {
                double d5 = d4 / (double)list2.size();
                double d6 = d5 * (double)list.size();
                double d7 = d4 - d6;
                color = this.getSearchResultColor();
                graphics2D.setColor(color);
                graphics2D.fill(new Rectangle2D.Double(d, d2, d3, d6));
                graphics2D.setColor(ColorFacade.getInstance().getBlankColor(string));
                graphics2D.fill(new Rectangle2D.Double(d, d2 + d6, d3, d7));
            }
        }
        return color;
    }

    public void drawPPMLabel(Graphics2D graphics2D, Cluster cluster, Organism organism, double d, double d2, double d3, double d4, double d5, double d6, int n, Color color) {
        String string = organism.getOrganismCode();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        List list = cluster.getLocusTagList(string);
        if (this.clusterTbl.isSearchTypeGene() && this.clusterTbl.isEnableHighlightSearchResult()) {
            List list2 = this.clusterTbl.getSearchResultLocusTagList(cluster, string);
            if (list.size() == list2.size()) {
                this.drawLocusTag(graphics2D, d4, n -= (list.size() - 1) * fontMetrics.getAscent() / 2, d, list, color);
            } else {
                ArrayList arrayList = new ArrayList(list);
                arrayList.removeAll(list2);
                double d7 = this.getCellHeight(d2, d3, string);
                double d8 = d7 / (double)list.size();
                double d9 = d8 * (double)list2.size();
                double d10 = d7 - d9;
                int n2 = (int)(d6 + d9 / 2.0 - (double)((list2.size() - 1) * fontMetrics.getAscent()) / 2.0 + (double)fontMetrics.getDescent());
                int n3 = (int)(d6 + d10 / 2.0 - (double)((arrayList.size() - 1) * fontMetrics.getAscent()) / 2.0 + (double)fontMetrics.getDescent() + d9);
                this.drawLocusTag(graphics2D, d4, n2, d, list2, color);
                this.drawLocusTag(graphics2D, d4, n3, d, arrayList, color);
            }
        } else {
            this.drawLocusTag(graphics2D, d4, n -= (list.size() - 1) * fontMetrics.getAscent() / 2, d, list, color);
        }
    }

    private double getCellHeight(double d, double d2, String string) {
        if (this.clusterTbl.isOutgroup(string)) {
            return d2;
        }
        return d;
    }

    public Color getColor(Cluster cluster, String string, String string2) {
        HashSet hashSet = new HashSet(this.clusterTbl.getSearchResultLocusTagList(cluster, string));
        Color color = hashSet.contains(string2) ? this.getSearchResultColor() : ColorFacade.getInstance().getBlankColor(string);
        return color;
    }

    public boolean isSyncEnable() {
        return false;
    }
}

