/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.coregenome.CoreGenomeContext;
import cgdp.recog.coregenome.CoreGenomeViewModel;
import cgdp.recog.coregenome.GenomeAlign;
import cgdp.recog.coregenome.OrthologGroup;
import cgdp.recog.coregenome.OrthologSpNode;
import cgdp.recog.coregenome.OrthologSpNodeConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ConnectionDepthCalculator {
    private CoreGenomeViewModel coreGenomeViewModel;
    private CoreGenomeContext coreGenomeContext;
    private int[] skipDepths;
    private int maxHeight;

    ConnectionDepthCalculator(CoreGenomeViewModel coreGenomeViewModel, CoreGenomeContext coreGenomeContext, int n, int n2) {
        this.coreGenomeViewModel = coreGenomeViewModel;
        this.coreGenomeContext = coreGenomeContext;
        this.skipDepths = new int[n];
        this.maxHeight = n2;
    }

    int calcDepth(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        if (n >= n2) {
            int n5;
            int n6;
            for (n6 = n - 1; n6 > n2; --n6) {
                n3 |= this.skipDepths[n6];
            }
            n6 = 0;
            for (n5 = 0; n5 < this.maxHeight; ++n5) {
                if ((n3 >> n5 & 1) != 0) continue;
                n4 = n5;
                n6 = 1;
                break;
            }
            if (n6 == 0) {
                n4 = this.maxHeight;
            }
            n5 = n;
            while (n5 >= n2) {
                int n7 = n5--;
                this.skipDepths[n7] = this.skipDepths[n7] | 1 << n4;
            }
        } else {
            int n8;
            int n9;
            for (n9 = n - 1; n9 >= 0; --n9) {
                n3 |= this.skipDepths[n9];
            }
            for (n9 = this.skipDepths.length - 1; n9 > n2; --n9) {
                n3 |= this.skipDepths[n9];
            }
            n9 = 0;
            for (n8 = 0; n8 < this.maxHeight; ++n8) {
                if ((n3 >> n8 & 1) != 0) continue;
                n4 = n8;
                n9 = 1;
                break;
            }
            if (n9 == 0) {
                n4 = this.maxHeight;
            }
            n8 = n;
            while (n8 >= 0) {
                int n10 = n8--;
                this.skipDepths[n10] = this.skipDepths[n10] | 1 << n4;
            }
            n8 = this.skipDepths.length - 1;
            while (n8 >= n2) {
                int n11 = n8--;
                this.skipDepths[n11] = this.skipDepths[n11] | 1 << n4;
            }
        }
        return n4;
    }

    private GenomeAlign getGenomeAlign() {
        return this.coreGenomeViewModel.getGenomeAlign();
    }

    Map calcConnectionDepth() {
        HashMap<OrthologSpNodeConnection, Double> hashMap = new HashMap<OrthologSpNodeConnection, Double>();
        HashMap<String, ConnectionDepthCalculator> hashMap2 = new HashMap<String, ConnectionDepthCalculator>();
        for (int i = 0; i < this.getGenomeAlign().getOrthologGroupSize(); ++i) {
            OrthologGroup orthologGroup = this.getGenomeAlign().getOrthologGroup(i);
            for (String string : this.coreGenomeViewModel.getViewOrganismCodeList()) {
                OrthologSpNode orthologSpNode;
                ConnectionDepthCalculator connectionDepthCalculator = (ConnectionDepthCalculator)hashMap2.get(string);
                if (connectionDepthCalculator == null) {
                    connectionDepthCalculator = new ConnectionDepthCalculator(this.coreGenomeViewModel, this.coreGenomeContext, this.getGenomeAlign().getOrthologGroupSize(), this.coreGenomeContext.getConnectionMaxViewCount());
                    hashMap2.put(string, connectionDepthCalculator);
                }
                if ((orthologSpNode = orthologGroup.getOrthologSpNode(string)) == null) continue;
                List list = this.getGenomeAlign().getConnectionList(orthologSpNode);
                int n = 0;
                for (OrthologSpNodeConnection orthologSpNodeConnection : list) {
                    int n2 = orthologSpNodeConnection.getFromOrthologGroup().getRealOrderIndex();
                    int n3 = orthologSpNodeConnection.getToOrthologGroup().getRealOrderIndex();
                    double d = connectionDepthCalculator.calcDepth(n2, n3);
                    hashMap.put(orthologSpNodeConnection, new Double(d));
                    ++n;
                }
            }
        }
        return hashMap;
    }
}

