/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.coregenome.ConnectionUpdater;
import cgdp.recog.coregenome.CoreGenomeAlignmentCondition;
import cgdp.recog.coregenome.CoreGenomeAlignmentExecuter;
import cgdp.recog.coregenome.CoreGenomeFrame;
import cgdp.recog.coregenome.CoreGenomeViewModel;
import cgdp.recog.coregenome.FileCoreGenomeAlignment;
import cgdp.recog.coregenome.FullCoreGenomeAlignment;
import cgdp.recog.coregenome.GenomeAlign;
import cgdp.recog.coregenome.GenomeAlignGenerater;
import cgdp.recog.coregenome.OrthologGroup;
import cgdp.recog.coregenome.OrthologSpNode;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.process.ProcessImpl;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.StringTool;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public abstract class CoreGenomeAlignment
implements ProcessImpl {
    private static final ApplicationLogger logger = new ApplicationLogger(CoreGenomeAlignment.class);
    protected MediatorImpl mediator;
    protected Component parent;
    private boolean error = false;
    private String errorMessage;
    private String errorCode;
    private String errorNo;
    protected ClusterTbl clusterTbl;

    public CoreGenomeAlignment(MediatorImpl mediatorImpl, Component component, ClusterTbl clusterTbl) {
        this.mediator = mediatorImpl;
        this.parent = component;
        this.clusterTbl = clusterTbl;
    }

    public static FullCoreGenomeAlignment createFullCoreGenomeAlignment(MediatorImpl mediatorImpl, Component component, ClusterTbl clusterTbl, List list, CoreGenomeAlignmentCondition coreGenomeAlignmentCondition) {
        return new FullCoreGenomeAlignment(mediatorImpl, component, clusterTbl, list, coreGenomeAlignmentCondition);
    }

    public static ConnectionUpdater createConnectionUpdater(MediatorImpl mediatorImpl, Component component, ClusterTbl clusterTbl, CoreGenomeFrame coreGenomeFrame, CoreGenomeViewModel coreGenomeViewModel, CoreGenomeAlignmentCondition coreGenomeAlignmentCondition) {
        return new ConnectionUpdater(mediatorImpl, component, clusterTbl, coreGenomeFrame, coreGenomeViewModel, coreGenomeAlignmentCondition);
    }

    public static FileCoreGenomeAlignment createFileCoreGenomeAlignment(MediatorImpl mediatorImpl, Component component, ClusterTbl clusterTbl, String string, List list) {
        return new FileCoreGenomeAlignment(mediatorImpl, component, clusterTbl, string, list);
    }

    protected String executeCoreGenomeOnServer(ProgressImpl progressImpl, ClusterTbl clusterTbl, CoreGenomeAlignmentCondition coreGenomeAlignmentCondition) throws Exception {
        CoreGenomeAlignmentExecuter coreGenomeAlignmentExecuter = new CoreGenomeAlignmentExecuter(progressImpl);
        coreGenomeAlignmentExecuter.setCondition(coreGenomeAlignmentCondition);
        coreGenomeAlignmentExecuter.execute();
        if (coreGenomeAlignmentExecuter.isError()) {
            this.setError(coreGenomeAlignmentExecuter.isError());
            this.setErrorMessage(coreGenomeAlignmentExecuter.getMessage());
            this.setErrorCode(coreGenomeAlignmentExecuter.getErrorCode());
            this.setErrorNo(coreGenomeAlignmentExecuter.getErrorNo());
        }
        return coreGenomeAlignmentExecuter.getFilepath();
    }

    protected static GenomeAlign createGenomeAlign(ProgressImpl progressImpl, ClusterTbl clusterTbl, String string, CoreGenomeAlignmentCondition coreGenomeAlignmentCondition) throws Exception {
        GenomeAlignGenerater genomeAlignGenerater = new GenomeAlignGenerater();
        genomeAlignGenerater.setFilepath(string);
        genomeAlignGenerater.setCondition(coreGenomeAlignmentCondition);
        genomeAlignGenerater.setClusterTbl(clusterTbl);
        genomeAlignGenerater.execute(progressImpl);
        GenomeAlign genomeAlign = genomeAlignGenerater.getGenomeAlign();
        genomeAlign.setOrganismList(coreGenomeAlignmentCondition.getOrganismList());
        return genomeAlign;
    }

    protected void showCoreGenomeFrame(final CoreGenomeViewModel coreGenomeViewModel) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CoreGenomeAlignment.this.mediator.showCoreGenomeFrame(coreGenomeViewModel);
                CoreGenomeAlignment.this.mediator.updateMemory();
            }
        });
    }

    protected static CoreGenomeViewModel createCoreGenomeViewModel(GenomeAlign genomeAlign, CoreGenomeAlignmentCondition coreGenomeAlignmentCondition) {
        CoreGenomeViewModel coreGenomeViewModel = new CoreGenomeViewModel();
        coreGenomeViewModel.setGenomeAlign(genomeAlign);
        coreGenomeViewModel.setCondition(coreGenomeAlignmentCondition);
        CoreGenomeAlignment.setHeadGeneNames(coreGenomeViewModel);
        return coreGenomeViewModel;
    }

    protected static void setHeadGeneNames(CoreGenomeViewModel coreGenomeViewModel) {
        String string = coreGenomeViewModel.getReferenceOrganism().getOrganismCode();
        GenomeAlign genomeAlign = coreGenomeViewModel.getGenomeAlign();
        for (OrthologGroup orthologGroup : genomeAlign.getOrthologGroupList()) {
            String string2 = CoreGenomeAlignment.setHeadGeneName(orthologGroup, string, coreGenomeViewModel.getOrganismCodeList(), coreGenomeViewModel.getViewOrganismCodeList());
            orthologGroup.setDisplayGeneName(string2);
        }
    }

    private static String setHeadGeneName(OrthologGroup orthologGroup, String string, List list, List list2) {
        String string2 = "";
        OrthologSpNode orthologSpNode = orthologGroup.getOrthologSpNode(string);
        if (orthologSpNode != null) {
            string2 = orthologSpNode.getHeadGeneName();
            if (StringTool.isNull(string2)) {
                string2 = orthologSpNode.getHeadLocusTag();
            }
        } else {
            Object object;
            OrthologSpNode orthologSpNode2 = null;
            for (Object object2 : list2) {
                object = orthologGroup.getOrthologSpNode((String)object2);
                if (object == null) continue;
                if (orthologSpNode2 == null && object != null) {
                    orthologSpNode2 = object;
                }
                if (StringTool.isNull(string2 = ((OrthologSpNode)object).getHeadGeneName())) continue;
                break;
            }
            if (!StringTool.isNull(string2)) {
                return string2;
            }
            if (orthologSpNode2 == null) {
                Object object2;
                ArrayList arrayList = new ArrayList(list);
                arrayList.removeAll(list2);
                object2 = arrayList.iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    OrthologSpNode orthologSpNode3 = orthologGroup.getOrthologSpNode((String)object);
                    if (orthologSpNode3 == null) continue;
                    orthologSpNode2 = orthologSpNode3;
                    break;
                }
            }
            string2 = orthologSpNode2.getHeadLocusTag();
        }
        return string2;
    }

    public void done() {
    }

    public abstract String[] getProgressMessages();

    protected boolean validateGenomeAlign(GenomeAlign genomeAlign) {
        return genomeAlign.getOrthologGroupSize() != 0;
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean bl) {
        this.error = bl;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public void setErrorNo(String string) {
        this.errorNo = string;
    }

    public String getErrorNo() {
        return this.errorNo;
    }

    public void setErrorCode(String string) {
        this.errorCode = string;
    }

    public String getErrorCode() {
        return this.errorCode;
    }
}

