/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.coregenome.CoreGenomeAlignmentCondition;
import cgdp.recog.coregenome.CoreGenomeChangeStartIndexEvent;
import cgdp.recog.coregenome.CoreGenomeContext;
import cgdp.recog.coregenome.CoreGenomeOrthologLabelChangeEvent;
import cgdp.recog.coregenome.CoreGenomeRenderer;
import cgdp.recog.coregenome.CoreGenomeViewModel;
import cgdp.recog.coregenome.CoreGenomeViewModelUpdateEvent;
import cgdp.recog.coregenome.CoreGenomeZoomEvent;
import cgdp.recog.coregenome.GenomeAlign;
import cgdp.recog.coregenome.OrthologGroup;
import cgdp.recog.coregenome.StartPointChangeEvent;
import cgdp.recog.coregenome.StartPointChangeItem;
import cgdp.recog.data.ClusterUtil;
import cgdp.recog.observer.ApplicationObserver;
import cgdp.recog.organism.Organism;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.process.ThreadManager;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

class CoreGenomeMainPanel
extends JPanel
implements ApplicationObserver,
ActionListener,
MouseListener {
    private static final ApplicationLogger logger = new ApplicationLogger(CoreGenomeMainPanel.class);
    private MediatorImpl mediator;
    private JPanel columnHeaderPanel;
    private CoreGenomeViewModel coreGenomeViewModel;
    private CoreGenomeRenderer coreGenomeRenderer;
    private boolean resizeFlag = true;
    private JScrollPane mainScrollPane;

    CoreGenomeMainPanel(MediatorImpl mediatorImpl, CoreGenomeViewModel coreGenomeViewModel) {
        this.mediator = mediatorImpl;
        this.coreGenomeViewModel = coreGenomeViewModel;
        this.coreGenomeRenderer = new CoreGenomeRenderer();
        CoreGenomeContext coreGenomeContext = new CoreGenomeContext();
        coreGenomeContext.setBaseMarginRight(0.0);
        this.coreGenomeRenderer.setModel(coreGenomeViewModel, coreGenomeContext);
        this.addMouseListener(this);
    }

    void setMainScrollPane(JScrollPane jScrollPane) {
        this.mainScrollPane = jScrollPane;
        this.columnHeaderPanel = new GeneNameDirectionPanel();
        JViewport jViewport = new JViewport();
        jViewport.add(this.columnHeaderPanel);
        this.mainScrollPane.setColumnHeader(jViewport);
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.coreGenomeRenderer.drawMatrixAll((Graphics2D)graphics);
        this.columnHeaderPanel.repaint();
        this.coreGenomeRenderer.drawSelectedOrthologGroup((Graphics2D)graphics);
        this.coreGenomeRenderer.drawHitOrthologGroup((Graphics2D)graphics);
        this.coreGenomeRenderer.drawFocusOrthologGroup((Graphics2D)graphics);
        if (this.resizeFlag) {
            int n = this.getViewOrthologGroupCount();
            this.coreGenomeViewModel.setViewOrthologGroupCountOnMain(n);
            this.resizeFlag = false;
        }
    }

    double calcHeight() {
        return this.coreGenomeRenderer.calcHeaderHeight() + this.coreGenomeRenderer.calcMatrixHeight();
    }

    void setViewSize(Dimension dimension) {
        CoreGenomeContext coreGenomeContext = this.coreGenomeRenderer.getCoreGenomeContext();
        coreGenomeContext.setCanvasWidth(dimension.getWidth());
        coreGenomeContext.setCanvasHeight(dimension.getHeight());
        this.resizeFlag = true;
    }

    int getViewOrthologGroupCount() {
        return this.coreGenomeRenderer.getViewOrthologGroupCount();
    }

    public void update(Observable observable, Object object) {
        if (object instanceof CoreGenomeChangeStartIndexEvent) {
            CoreGenomeChangeStartIndexEvent coreGenomeChangeStartIndexEvent = (CoreGenomeChangeStartIndexEvent)object;
            this.coreGenomeRenderer.getCoreGenomeContext().setOrthologGroupStartIndex(coreGenomeChangeStartIndexEvent.getOrthologGroupStartIndex());
            this.repaint();
        } else if (object instanceof CoreGenomeViewModelUpdateEvent) {
            this.coreGenomeRenderer.clearCache();
            int n = this.getViewOrthologGroupCount();
            this.coreGenomeViewModel.setViewOrthologGroupCountOnMain(n);
            this.repaint();
        } else if (object instanceof CoreGenomeZoomEvent) {
            CoreGenomeZoomEvent coreGenomeZoomEvent = (CoreGenomeZoomEvent)object;
            this.coreGenomeRenderer.getCoreGenomeContext().zoom(coreGenomeZoomEvent.getScale());
            this.updatePreferredSize();
        } else if (object instanceof CoreGenomeOrthologLabelChangeEvent) {
            this.coreGenomeRenderer.clearCache();
            int n = this.getViewOrthologGroupCount();
            this.coreGenomeViewModel.setViewOrthologGroupCountOnMain(n);
            this.updatePreferredSize();
        }
    }

    void updatePreferredSize() {
        this.setPreferredSize(new Dimension(700, (int)this.coreGenomeRenderer.calcMatrixHeight()));
        this.revalidate();
        this.columnHeaderPanel.setPreferredSize(new Dimension(700, (int)this.coreGenomeRenderer.calcHeaderHeight()));
        this.columnHeaderPanel.revalidate();
    }

    private void showPopup(Point point) {
        int n = this.coreGenomeRenderer.getCoreGenomeContext().getOrhologGroupIndex(point.x, this.coreGenomeViewModel.getGenomeAlign(), false);
        if (n == -1) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new StartPointChangeItem(this, this.mediator, this.coreGenomeViewModel, n));
        jPopupMenu.show(this, point.x, point.y);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ((CommandImpl)actionEvent.getSource()).execute();
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.coreGenomeRenderer.getCoreGenomeContext().getOrhologGroupIndex(point.x, this.coreGenomeViewModel.getGenomeAlign(), false);
        if (n != -1) {
            this.selectOrthologGroup(n);
            OrthologGroup orthologGroup = this.coreGenomeViewModel.getGenomeAlign().getOrthologGroup(n);
            this.mediator.selectOrthologGroupOnGlobalAlign(orthologGroup.getOrthologGroupId());
            int n2 = point.y;
            Organism organism = this.coreGenomeRenderer.getOrganism(n2);
            if (organism != null) {
                List list = orthologGroup.getLocusTagList(organism.getOrganismCode());
                String string = null;
                if (!CollectionUtil.isNull(list)) {
                    string = (String)list.get(0);
                }
                this.mediator.selectClusterOnPPM(organism.getOrganismCode(), string, orthologGroup.getCluster());
            }
            this.mediator.setSelectClusterOnGenomeMap(orthologGroup.getCluster());
            if (mouseEvent.getClickCount() == 2) {
                this.changeCentralOrthologGroup(n);
                this.mediator.changeCentralPositionOnGlobalAlign(orthologGroup.getOrthologGroupId());
            }
        } else if (this.coreGenomeRenderer.isOrganismTitleX(mouseEvent.getPoint()) && mouseEvent.getClickCount() == 2) {
            int n3 = point.y;
            Organism organism = this.coreGenomeRenderer.getOrganism(n3);
            if (organism != null) {
                CoreGenomeAlignmentCondition coreGenomeAlignmentCondition = this.coreGenomeViewModel.createCoreGenomeAlignmentCondition();
                coreGenomeAlignmentCondition.setReferenceOrganism(organism);
                this.mediator.updateCoreGenomeMap(this.coreGenomeViewModel, coreGenomeAlignmentCondition, true);
            }
        } else {
            this.coreGenomeViewModel.clearSelectedOrthologGroupList();
            this.repaint();
            return;
        }
    }

    private void selectOrthologGroup(int n) {
        OrthologGroup orthologGroup = this.coreGenomeViewModel.getGenomeAlign().getOrthologGroup(n);
        this.coreGenomeViewModel.setSelectOrthologGroup(orthologGroup);
        this.repaint();
    }

    void selectOrthologGroup(String string) {
        OrthologGroup orthologGroup = this.coreGenomeViewModel.getGenomeAlign().getOrthologGroup(string);
        this.coreGenomeViewModel.setSelectOrthologGroup(orthologGroup);
        this.selectOrthologGroupAfter(orthologGroup);
    }

    void selectOrthologGroup(Set set) {
        Set set2 = this.coreGenomeViewModel.getGenomeAlign().getOrthologGroupSet(set);
        this.coreGenomeViewModel.setSelectOrthologGroupSet(set2);
        OrthologGroup orthologGroup = (OrthologGroup)set2.iterator().next();
        this.selectOrthologGroupAfter(orthologGroup);
    }

    private void selectOrthologGroupAfter(OrthologGroup orthologGroup) {
        GenomeAlign genomeAlign = this.coreGenomeViewModel.getGenomeAlign();
        int n = genomeAlign.indexOfOrthologGroup(orthologGroup);
        this.coreGenomeViewModel.moveViewOrthologGroupStartIndexForCenter(n);
        this.coreGenomeRenderer.getCoreGenomeContext().setOrthologGroupStartIndex(this.coreGenomeViewModel.getViewOrthologGroupStartIndexOnMain());
        this.repaint();
        CoreGenomeChangeStartIndexEvent coreGenomeChangeStartIndexEvent = new CoreGenomeChangeStartIndexEvent(this, this.coreGenomeViewModel.getViewOrthologGroupStartIndexOnMain());
        this.coreGenomeViewModel.nodifyObservers(coreGenomeChangeStartIndexEvent);
    }

    void selectOrthologGroup(List list) {
        Set set = ClusterUtil.getClusterIdSet(list);
        Set set2 = this.coreGenomeViewModel.getOrthologGroupSetByClusterId(set);
        if (CollectionUtil.isNull(set2)) {
            return;
        }
        this.coreGenomeViewModel.setSelectOrthologGroupSet(set2);
        OrthologGroup orthologGroup = (OrthologGroup)set2.iterator().next();
        this.selectOrthologGroupAfter(orthologGroup);
    }

    private void changeCentralOrthologGroup(int n) {
        int n2 = this.coreGenomeViewModel.calcStartOrthologGroupIndexByCenterIndex(n);
        StartPointChangeEvent startPointChangeEvent = new StartPointChangeEvent(this, n2);
        this.coreGenomeViewModel.nodifyObservers(startPointChangeEvent);
    }

    void changeCentralPosition(String string) {
        OrthologGroup orthologGroup = this.coreGenomeViewModel.getGenomeAlign().getOrthologGroup(string);
        int n = this.coreGenomeViewModel.getGenomeAlign().indexOfOrthologGroup(orthologGroup);
        this.changeCentralOrthologGroup(n);
    }

    void changeOrthologGroupLabel(final int n) {
        Runnable runnable = new Runnable(){

            public void run() {
                CoreGenomeMainPanel.this.coreGenomeViewModel.setOrthologGroupLabelType(n);
                CoreGenomeOrthologLabelChangeEvent coreGenomeOrthologLabelChangeEvent = new CoreGenomeOrthologLabelChangeEvent(this);
                CoreGenomeMainPanel.this.coreGenomeViewModel.nodifyObservers(coreGenomeOrthologLabelChangeEvent);
            }
        };
        ThreadManager threadManager = ThreadManager.getInstance();
        threadManager.execute(runnable);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private class GeneNameDirectionPanel
    extends JPanel {
        private GeneNameDirectionPanel() {
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            CoreGenomeMainPanel.this.coreGenomeRenderer.drawHeader((Graphics2D)graphics);
            CoreGenomeMainPanel.this.coreGenomeRenderer.drawSelectedOrthologGroup((Graphics2D)graphics);
            CoreGenomeMainPanel.this.coreGenomeRenderer.drawHitOrthologGroup((Graphics2D)graphics);
            CoreGenomeMainPanel.this.coreGenomeRenderer.drawFocusOrthologGroup((Graphics2D)graphics);
        }
    }
}

