/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.data;

import cgdp.recog.bean.Const;
import cgdp.recog.data.AminoCode;
import cgdp.recog.util.StringTool;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JOptionPane;

public class AminoCodeTbl
extends TreeMap {
    private static AminoCodeTbl m_aminoCodeTbl = new AminoCodeTbl();

    private AminoCodeTbl() {
        super(new Comparator(){

            public int compare(Object object, Object object2) {
                return ((String)object).compareToIgnoreCase((String)object2);
            }
        });
        try {
            this.readAminoCode();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, iOException.getMessage(), "Error", 0);
            System.exit(0);
        }
    }

    private void readAminoCode() throws IOException {
        String string;
        FileInputStream fileInputStream = new FileInputStream(Const.USER_AMINO_CODE_DAT_PATH);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        while ((string = bufferedReader.readLine()) != null) {
            if (StringTool.isNull(string)) continue;
            Vector vector = StringTool.splitString(string, "<>");
            if (vector.size() != 4) {
                vector.clear();
                vector = null;
                continue;
            }
            AminoCode aminoCode = new AminoCode();
            aminoCode.setCode((String)vector.get(0));
            aminoCode.setCode3((String)vector.get(1));
            aminoCode.setCodeFull((String)vector.get(2));
            aminoCode.setColor((String)vector.get(3));
            this.put("" + aminoCode.getCode(), aminoCode);
            vector.clear();
            vector = null;
        }
        fileInputStream.close();
    }

    public void writeAminoCode() throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(Const.USER_AMINO_CODE_DAT_PATH);
        PrintWriter printWriter = new PrintWriter(fileOutputStream);
        for (AminoCode aminoCode : this.values()) {
            printWriter.print(aminoCode.getCode());
            printWriter.print("<>");
            printWriter.print(aminoCode.getCode3());
            printWriter.print("<>");
            printWriter.print(aminoCode.getCodeFull());
            printWriter.print("<>");
            printWriter.println(aminoCode.getColor());
        }
        printWriter.flush();
        fileOutputStream.close();
    }

    public void restore() {
        String[][] stringArrayArray = new String[][]{{"A", "#ff0000"}, {"C", "#ff00ff"}, {"D", "#ff9900"}, {"E", "#ffcc99"}, {"F", "#808000"}, {"G", "#99cc00"}, {"H", "#ffff00"}, {"I", "#008000"}, {"K", "#00ff00"}, {"L", "#33cccc"}, {"M", "#00ffff"}, {"N", "#0000ff"}, {"P", "#00ccff"}, {"Q", "#666699"}, {"R", "#800080"}, {"S", "#cc99ff"}, {"T", "#c0c0c0"}, {"V", "#993300"}, {"W", "#333399"}, {"X", "#000000"}, {"Y", "#ff99cc"}};
        for (int i = 0; i < stringArrayArray.length; ++i) {
            AminoCode aminoCode = (AminoCode)this.get(stringArrayArray[i][0]);
            aminoCode.setColor(stringArrayArray[i][1]);
        }
    }

    public static AminoCodeTbl getInstance() {
        return m_aminoCodeTbl;
    }
}

