/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.data;

import cgdp.recog.data.DataManager;
import cgdp.recog.data.GenomeTbl;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.server.AccessServer;
import cgdp.recog.server.ServerAccessException;
import cgdp.recog.system.property.ApplicationPropertyFacade;
import cgdp.recog.util.AbstractServerConnection;
import cgdp.recog.util.ApplicationLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

public class DataFileDownloader {
    private static final DataFileDownloader DATA_FILE_DOWNLOADER = new DataFileDownloader();
    private static final ApplicationLogger logger = new ApplicationLogger(DataFileDownloader.class);
    private OptionTbl optionTbl = OptionTbl.getInstance();

    private DataFileDownloader() {
    }

    public static DataFileDownloader getInstance() {
        return DATA_FILE_DOWNLOADER;
    }

    public void downloadTaxonomyData() throws Exception {
        this.downloadTaxonomyData(true);
    }

    public boolean downloadTaxonomyData(boolean bl) throws Exception {
        String string = "?table=taxonomy";
        String string2 = DataManager.getTaxonomyDat();
        if (bl || !bl && !new File(string2).isFile()) {
            this.downloadData(string, string2);
            return true;
        }
        return false;
    }

    public boolean downloadTaxonomyData(String string) throws Exception {
        return this.downloadTaxonomyData(string, true);
    }

    private boolean downloadTaxonomyData(String string, boolean bl) throws Exception {
        String string2 = "?table=taxonomy";
        if (bl || !bl && !new File(string).isFile()) {
            this.downloadData(string2, string);
            return true;
        }
        return false;
    }

    public void downloadGenomeParamData() throws Exception {
        String string = GenomeTbl.getGenomeParamURLOption();
        String string2 = DataManager.getGenomeParamDat();
        this.downloadData(string, string2);
    }

    public void downloadGenomeParamData(String string) throws Exception {
        String string2 = GenomeTbl.getGenomeParamURLOption();
        this.downloadData(string2, string);
    }

    public void downloadGenomeData() throws Exception {
        String string = GenomeTbl.getURLOption();
        String string2 = DataManager.getGenomeDat();
        this.downloadData(string, string2);
    }

    public void downloadGenomeData(String string) throws Exception {
        String string2 = GenomeTbl.getURLOption();
        this.downloadData(string2, string);
    }

    public void downloadGeneAndChromosomeData(Collection collection, File file, ProgressImpl progressImpl) throws Exception {
        if (collection.isEmpty()) {
            return;
        }
        ArrayList arrayList = new ArrayList(collection);
        Set set = ApplicationPropertyFacade.getIncompleteOrganismCodeSet();
        for (String string : arrayList) {
            String string2;
            String string3 = DataManager.getChromosomeFilePath(file, string);
            this.downloadData("?table=chromosome&key=" + string, string3);
            if (progressImpl.isCanceled()) {
                return;
            }
            if (set.contains(string)) {
                string2 = DataManager.getContigFilePath(file, string);
                this.downloadData("?table=contig&key=" + string, string2);
                String string4 = DataManager.getMappingFilePath(file, string);
                this.downloadData("?table=mapview&key=" + string, string4);
            }
            string2 = DataManager.getGeneFilePath(file, string);
            this.downloadData("?table=gene&key=" + string, string2);
            if (progressImpl.isCanceled()) {
                return;
            }
            progressImpl.increment();
        }
    }

    private void downloadData(String string, String string2) throws Exception {
        this.downloadData(this.getDataUrl(), string, string2);
    }

    private void downloadData(String string, String string2, String string3) throws Exception {
        if (!AccessServer.getInstance().isEnableAccess()) {
            throw new ServerAccessException();
        }
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            String string4;
            logger.info("URL : " + string + string2);
            URL uRL = new URL(string + string2);
            URLConnection uRLConnection = uRL.openConnection();
            if (!AbstractServerConnection.checkHttpStatus(uRLConnection)) {
                throw new Exception("Fail to access server.");
            }
            inputStream = uRLConnection.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            fileOutputStream = new FileOutputStream(string3);
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            while ((string4 = bufferedReader.readLine()) != null) {
                printWriter.println(string4);
            }
            printWriter.flush();
        }
        catch (Exception exception) {
            logger.warn("Fail to download data file : " + string3, exception);
            throw exception;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    logger.warn("Fail to close fos.", iOException);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    logger.warn("Fail to close is.", iOException);
                }
            }
        }
    }

    private String getDataUrl() {
        return AccessServer.getInstance().getServerUrl() + this.optionTbl.getOptionValues().getGetDataUrl();
    }
}

