/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.data;

import cgdp.recog.data.DataManager;
import cgdp.recog.data.Gene;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileImporter;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class GeneImporter
extends FileImporter {
    private static final ApplicationLogger logger = new ApplicationLogger(GeneImporter.class);
    public static final String DELIMITER = "\t";
    private static final String COLUMN_ID = "id";
    private static final String COLUMN_UDATE = "udate";
    private static final String COLUMN_SPID = "spid";
    private static final String COLUMN_SP = "sp";
    public static final String COLUMN_NAME = "name";
    private static final String COLUMN_GENE = "gene";
    public static final String COLUMN_CHRID = "chrid";
    public static final String COLUMN_CONTIGID = "contigid";
    public static final String COLUMN_FROM1 = "from1";
    public static final String COLUMN_TO1 = "to1";
    private static final String COLUMN_DIR = "dir";
    private static final String COLUMN_LOCATION = "location";
    private static final String COLUMN_TYPE = "type";
    private static final String COLUMN_TRANSL_TABLE = "transl_table";
    private static final String COLUMN_CODON_START = "codon_start";
    private static final String COLUMN_PROTID = "protid";
    private static final String COLUMN_GI = "gi";
    private static final String COLUMN_GENEID = "geneid";
    private static final String COLUMN_NTSEQ = "ntseq";
    private static final String COLUMN_AASEQ = "aaseq";
    private static final String COLUMN_DESCR = "descr";
    private static final String COLUMN_AALEN = "aalen";
    private static final String COLUMN_FUNCCAT = "funccat";
    private String organismCode;
    private String locusTag;
    private List columnNameList = new ArrayList();
    private List geneList = new ArrayList();
    private Set includeFieldSet = new HashSet();
    private int locusTagIndex = -1;
    private String filepath;

    public GeneImporter(String string, String string2) {
        this.organismCode = string;
        this.locusTag = string2;
        this.filepath = DataManager.getGeneFilePath(string);
    }

    public void setFilepath(String string) {
        this.filepath = string;
    }

    public void setGeneNameOnly() {
        this.includeFieldSet.add(COLUMN_NAME);
        this.includeFieldSet.add(COLUMN_GENE);
    }

    public void setLoadFields(Set set) {
        this.includeFieldSet.addAll(set);
    }

    private boolean isTargetRecode(String string) {
        if (!this.isReadOneLocusTag()) {
            return true;
        }
        return this.locusTag.equals(string);
    }

    private boolean isReadOneLocusTag() {
        return !StringTool.isNull(this.locusTag);
    }

    protected void parseHeaderLine(String string) {
        this.columnNameList.addAll(StringTool.splitString(string, DELIMITER));
        this.locusTagIndex = this.columnNameList.indexOf(COLUMN_NAME);
    }

    protected void parseDataLine(int n, String string) {
        Gene gene = new Gene();
        Vector vector = StringTool.splitString(string, DELIMITER);
        String string2 = (String)vector.get(this.locusTagIndex);
        if (StringTool.isNull(string2)) {
            return;
        }
        if (!this.isTargetRecode(string2)) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            String string3 = (String)this.columnNameList.get(i);
            if (!this.includeFieldSet.isEmpty() && !this.includeFieldSet.contains(string3)) continue;
            String string4 = String.valueOf(vector.get(i));
            this.setParameter(string3, string4, gene);
        }
        this.geneList.add(gene);
        if (this.isReadOneLocusTag()) {
            return;
        }
    }

    private void setParameter(String string, String string2, Gene gene) {
        if (string.equals(COLUMN_ID)) {
            try {
                gene.setId(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                logger.warn("Fail to parse id. " + string2, numberFormatException);
            }
        } else if (string.equals(COLUMN_UDATE)) {
            gene.setUdate(string2);
        } else if (string.equals(COLUMN_SP)) {
            gene.setOrganism(string2);
        } else if (string.equals(COLUMN_SPID)) {
            gene.setSpid(string2);
        } else if (string.equals(COLUMN_NAME)) {
            gene.setLocusTag(string2);
        } else if (string.equals(COLUMN_GENE)) {
            gene.setGeneName(string2);
        } else if (string.equals(COLUMN_CHRID)) {
            if (!StringTool.isNull(string2)) {
                try {
                    gene.setChromId(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    logger.warn("Fail to parse chromosome id. " + string2, numberFormatException);
                }
            }
        } else if (string.equals(COLUMN_CONTIGID)) {
            if (!StringTool.isNull(string2)) {
                try {
                    gene.setContigId(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    logger.warn("Fail to parse contig id. " + string2, numberFormatException);
                }
            }
        } else if (string.equals(COLUMN_FROM1)) {
            try {
                gene.setStart(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                logger.warn("Fail to parse start. " + string2, numberFormatException);
            }
        } else if (string.equals(COLUMN_TO1)) {
            try {
                gene.setEnd(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                logger.warn("Fail to parse end. " + string2, numberFormatException);
            }
        } else if (string.equals(COLUMN_DIR)) {
            try {
                gene.setDirection(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                logger.warn("Fail to parse direction. " + string2, numberFormatException);
            }
        } else if (string.equals(COLUMN_LOCATION)) {
            gene.setLocation(string2);
        } else if (string.equals(COLUMN_TYPE)) {
            gene.setFeatureKey(string2);
        } else if (string.equals(COLUMN_TRANSL_TABLE)) {
            gene.setTranslTable(string2);
        } else if (string.equals(COLUMN_CODON_START)) {
            if (!StringTool.isNull(string2)) {
                try {
                    gene.setCodonStart(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    logger.warn("Fail to parse codon start. " + string2, numberFormatException);
                }
            }
        } else if (string.equals(COLUMN_PROTID)) {
            gene.setAccession(string2);
        } else if (string.equals(COLUMN_GI)) {
            gene.setGi(string2);
        } else if (string.equals(COLUMN_GENEID)) {
            gene.setGeneId(string2);
        } else if (string.equals(COLUMN_DESCR)) {
            gene.setDescription(string2);
        } else if (string.equals(COLUMN_AALEN) && gene.getFeatureKey() == "CDS") {
            try {
                gene.setAalen(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                logger.warn("Fail to parse aalen. " + string2, numberFormatException);
            }
        }
    }

    protected String getFilepath() {
        return this.filepath;
    }

    public List getGeneList() {
        return this.geneList;
    }
}

