/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.data;

import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.server.AccessServer;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.MessageManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class InnerTbl
extends HashMap {
    private static final ApplicationLogger logger = new ApplicationLogger(InnerTbl.class);
    private static final String INNER_DAT_NAME = "inner.dat";
    private static final String INNER_DAT_NAME_PREFIX = "inner";
    private static final String INNER_DAT_NAME_EXTENSION = ".dat";
    private static final InnerTbl INNTER_TBL = new InnerTbl();

    private InnerTbl() {
        try {
            this.readInner();
        }
        catch (IOException iOException) {
            String string = "Fail to load ingroup file.";
            logger.warn(string, iOException);
            MessageManager.showErrorMessage(null, string);
            System.exit(0);
        }
    }

    public void initInner() throws IOException {
        this.clear();
        this.readInner();
    }

    public void setInner(Collection collection) {
        this.clear();
        for (String string : collection) {
            this.put(string, "OK");
        }
    }

    public void addInner(Collection collection) {
        for (String string : collection) {
            this.put(string, "OK");
        }
    }

    public void removeInner(Collection collection) {
        for (String string : collection) {
            this.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readInner() throws IOException {
        File file = InnerTbl.getInnerFile();
        if (!file.isFile()) {
            return;
        }
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            String string;
            fileInputStream = new FileInputStream(file);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            while ((string = bufferedReader.readLine()) != null) {
                this.put(string, "OK");
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    private static File getInnerFile() {
        String string;
        File file;
        String string2;
        File file2 = ProjectAccesser.getProjectDir();
        File file3 = new File(file2, string2 = "inner_" + AccessServer.getServerName() + INNER_DAT_NAME_EXTENSION);
        if (!file3.isFile() && (file = new File(file2, string = INNER_DAT_NAME)).isFile()) {
            file.renameTo(file3);
        }
        return file3;
    }

    public void writeInner() throws IOException {
        File file = InnerTbl.getInnerFile();
        if (this.size() == 0) {
            file.delete();
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next());
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        FileUtil.outputFile(stringBuffer.toString(), file.getAbsolutePath());
    }

    public static InnerTbl getInstance() {
        return INNTER_TBL;
    }
}

