/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.domclust;

import cgdp.recog.domclust.DomClustCondition;
import cgdp.recog.domclust.DomClustFileUtil;
import cgdp.recog.domclust.DomClustKeyGenerator;
import cgdp.recog.domclust.DomClustQuery;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.ProgressServerConnection;
import cgdp.recog.util.ServerStatus;
import cgdp.recog.util.SimpleServerConnection;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class DomClustExecuter
extends ProgressServerConnection {
    private static final ApplicationLogger logger = new ApplicationLogger(DomClustExecuter.class);
    private DomClustCondition domClustCondition;
    private Project project;
    private String domClustId;
    private Map procMap;
    private StringBuffer sb;
    private String filepath;
    private boolean dataFlag = false;
    private boolean outputFile = true;

    public DomClustExecuter(DomClustCondition domClustCondition, ProgressImpl progressImpl, String string) {
        this.domClustCondition = domClustCondition;
        this.procMap = DomClustExecuter.createProcMap();
        this.setContextPath(OptionTbl.getInstance().getOptionValues().getDomClustUrl());
        this.setOptions(string);
        this.setProgressImpl(progressImpl);
        this.setIncreaseRate(1.1f);
    }

    DomClustExecuter(DomClustCondition domClustCondition, ProgressImpl progressImpl, Map map) {
        this.domClustCondition = domClustCondition;
        this.procMap = map;
        this.setContextPath(OptionTbl.getInstance().getOptionValues().getDomClustUrl());
        this.setCondition();
        this.setProgressImpl(progressImpl);
        this.setIncreaseRate(1.1f);
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void parseOutputString(int n, String string) {
        if (n == 0) {
            this.sb = new StringBuffer();
        }
        if (ServerStatus.isStartData(string) && !this.dataFlag) {
            this.sb.append(ServerStatus.createQuery(DomClustQuery.getQueryOption(this.domClustCondition)));
            this.sb.append(FileUtil.LINE_SEPARETOR);
            this.sb.append(ServerStatus.createClusterViewIdMessage(DomClustKeyGenerator.createKey()));
            this.sb.append(FileUtil.LINE_SEPARETOR);
            this.dataFlag = true;
        }
        this.sb.append(string);
        this.sb.append(FileUtil.LINE_SEPARETOR);
    }

    protected void before() {
    }

    protected void after() {
        if (this.isCanceled() || this.isError()) {
            return;
        }
        if (this.domClustCondition.isNoexec()) {
            return;
        }
        if (this.isOutputFile()) {
            try {
                this.filepath = this.getOutputFilePath();
                FileUtil.outputFile(this.sb.toString(), this.filepath);
            }
            catch (IOException iOException) {
                this.setError();
                this.setMessage("Fail to save domclust file.");
            }
        }
    }

    private String getOutputFilePath() {
        if (this.project == null) {
            return DomClustExecuter.getOutputFilePath(this.domClustCondition.getDomClustName());
        }
        return DomClustExecuter.getOutputFilePath(this.project, this.domClustCondition.getDomClustName());
    }

    static String getOutputFilePath(String string) {
        return DomClustExecuter.getOutputFilePath(ProjectAccesser.getSelectedProject(), string);
    }

    private static String getOutputFilePath(Project project, String string) {
        return DomClustFileUtil.createDomClustFilepath(project, string);
    }

    private void setCondition() {
        this.setOptions(DomClustQuery.getQueryOption(this.domClustCondition));
    }

    protected boolean setParameter(String string) {
        if (!ServerStatus.isParameter(string)) {
            return false;
        }
        if (super.setParameter(string)) {
            if (ServerStatus.isProgress(string)) {
                this.setProgress(this.procMap);
            }
            return true;
        }
        if (ServerStatus.isClusterId(string)) {
            this.setDomClustId(ServerStatus.getClusterId(string));
        }
        return false;
    }

    String getDomClustId() {
        return this.domClustId;
    }

    void setDomClustId(String string) {
        this.domClustId = string;
    }

    String getFilepath() {
        return this.filepath;
    }

    private boolean isReading() {
        return this.getMessage().equals("reading");
    }

    private boolean isSorting() {
        return this.getMessage().equals("sorting");
    }

    private boolean isIndexing() {
        return this.getMessage().equals("indexing");
    }

    private boolean isClustering() {
        return this.getMessage().equals("clustering");
    }

    public void setOutputFile(boolean bl) {
        this.outputFile = bl;
    }

    public boolean isOutputFile() {
        return this.outputFile;
    }

    public String getContents() {
        return this.sb.toString();
    }

    private void setProgress(Map map) {
        if (map == null) {
            return;
        }
        ProgressImpl progressImpl = this.getProgressImpl();
        if (this.isReading()) {
            progressImpl.setCount(this.getProgress());
            progressImpl.increment();
        } else if (this.isSorting()) {
            if (map.get("reading") != null) {
                progressImpl.nextProc();
                map.remove("reading");
            }
            progressImpl.setCount(this.getProgress());
            progressImpl.increment();
        } else if (this.isIndexing()) {
            if (map.get("reading") != null) {
                progressImpl.nextProc();
                map.remove("reading");
            }
            if (map.get("sorting") != null) {
                progressImpl.nextProc();
                map.remove("sorting");
            }
            progressImpl.setCount(this.getProgress());
            progressImpl.increment();
        } else if (this.isClustering()) {
            if (map.get("reading") != null) {
                progressImpl.nextProc();
                map.remove("reading");
            }
            if (map.get("sorting") != null) {
                progressImpl.nextProc();
                map.remove("sorting");
            }
            if (map.get("indexing") != null) {
                progressImpl.nextProc();
                map.remove("indexing");
            }
            progressImpl.setCount(this.getProgress());
            progressImpl.increment();
        } else {
            if (map.get("reading") != null) {
                progressImpl.nextProc();
                map.remove("reading");
            }
            if (map.get("sorting") != null) {
                progressImpl.nextProc();
                map.remove("sorting");
            }
            if (map.get("indexing") != null) {
                progressImpl.nextProc();
                map.remove("indexing");
            }
            if (map.get("clustering") != null) {
                progressImpl.nextProc();
                map.remove("clustering");
            }
            progressImpl.setCount(this.getProgress());
            progressImpl.increment();
        }
    }

    static final Map createProcMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("reading", "OK");
        hashMap.put("sorting", "OK");
        hashMap.put("indexing", "OK");
        hashMap.put("clustering", "OK");
        hashMap.put("create_result_table", "OK");
        return hashMap;
    }

    protected void cancel() {
        DomClustKiller domClustKiller = new DomClustKiller();
        try {
            domClustKiller.execute();
        }
        catch (Exception exception) {
            logger.warn("Fail to kill domclust process. " + this.getDomClustId(), exception);
        }
        if (domClustKiller.isError()) {
            logger.warn("Fail to kill domclust process. " + this.getDomClustId() + " " + domClustKiller.getMessage());
        }
    }

    private class DomClustKiller
    extends SimpleServerConnection {
        DomClustKiller() {
            this.setContextPath(OptionTbl.getInstance().getOptionValues().getDomClustKillUrl());
            this.setCondition();
        }

        public void parseOutputString(int n, String string) {
        }

        private void setCondition() {
            this.setOptions("clust_id=" + DomClustExecuter.this.getDomClustId());
        }
    }
}

