/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.domclust;

import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterUtil;
import cgdp.recog.data.GeneInformation;
import cgdp.recog.domclust.AbstractDomClustExporter;
import cgdp.recog.domclust.AbstractDomClustImporter;
import cgdp.recog.funccat.FuncCat;
import cgdp.recog.funccat.FuncCatTbl;
import cgdp.recog.info.AbstractInfo;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.InfoUtil;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.MapUtil;
import cgdp.recog.util.ServerStatus;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DomClustTabExporter
extends AbstractDomClustExporter {
    private static final ApplicationLogger logger = new ApplicationLogger(DomClustTabExporter.class);
    private static final String DELIMITER = "\t";
    private static final String ORGANISM_DELIMITER = ",";
    private static final String LOCUSTAG_DELIMITER = " ";
    private List ingroupOrganismCodeList;
    private List outgroupOrganismCodeList;
    private List organismCodeList;
    private List clusterList;
    private boolean outgroupFlag;
    private FuncCatTbl funcCatTbl = FuncCatTbl.getInstance();
    private Map infoMap;
    private Map parameterMap;
    private List infoTitleList;

    DomClustTabExporter(String string, String string2, List list, boolean bl, List list2, List list3) {
        this.setFilepath(string);
        this.setDomClustFilepath(string2);
        this.clusterList = new ArrayList(list);
        this.outgroupFlag = bl;
        this.ingroupOrganismCodeList = new ArrayList(list2);
        this.outgroupOrganismCodeList = new ArrayList(list3);
        this.organismCodeList = new ArrayList(list2);
        this.organismCodeList.addAll(list3);
    }

    public void setInfoMap(Map map) {
        this.infoMap = map;
        if (!MapUtil.isNull(map)) {
            this.infoTitleList = InfoUtil.getInfoTitleList(this.infoMap.values());
        }
    }

    public void setParameterMap(Map map) {
        this.parameterMap = map;
    }

    public boolean isExistInfoMap() {
        return !MapUtil.isNull(this.infoMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        FileOutputStream fileOutputStream = null;
        PrintWriter printWriter = null;
        try {
            fileOutputStream = new FileOutputStream(this.getFilepath(), false);
            printWriter = new PrintWriter(fileOutputStream);
            printWriter.println(this.createParameterLines());
            printWriter.println(this.createHeaderLine());
            for (Cluster cluster : this.clusterList) {
                String string = this.createClusterLine(cluster);
                printWriter.println(string);
            }
            printWriter.flush();
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    private String createParameterLines() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            AbstractDomClustImporter abstractDomClustImporter = AbstractDomClustImporter.createDomClustImporter(this.getDomClustFilepath());
            abstractDomClustImporter.setParameterOnly(true);
            abstractDomClustImporter.execute();
            stringBuffer.append("#DomClust Result");
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            int n = this.ingroupOrganismCodeList.size() + this.outgroupOrganismCodeList.size();
            stringBuffer.append(ServerStatus.createNSpecies(n));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append(ServerStatus.createIngroup(this.ingroupOrganismCodeList));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append(ServerStatus.createOutgroup(this.outgroupOrganismCodeList));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append(ServerStatus.createNClusters(ClusterUtil.getClusterCount(this.clusterList)));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            Project project = ProjectAccesser.getSelectedProject();
            stringBuffer.append(ServerStatus.createDclstName(DomClustTabExporter.createDclstName(project, new File(this.getFilepath()).getName())));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            if (!MapUtil.isNull(this.parameterMap)) {
                ArrayList arrayList = new ArrayList(this.parameterMap.keySet());
                for (String string : arrayList) {
                    String string2 = (String)this.parameterMap.get(string);
                    stringBuffer.append(ServerStatus.createParameterMessageAddPrefix(string, string2));
                    stringBuffer.append(FileUtil.LINE_SEPARETOR);
                }
            }
        }
        catch (IOException iOException) {
            logger.warn("Fail to import domclust parameter.", iOException);
        }
        return stringBuffer.toString();
    }

    private static String createDclstName(Project project, String string) {
        return project.getProjectName() + "/" + string;
    }

    private String createHeaderLine() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Cluster ID");
        stringBuffer.append(DELIMITER);
        stringBuffer.append("Gene Name");
        stringBuffer.append(DELIMITER);
        stringBuffer.append("Function Category(" + this.funcCatTbl.getFuctionCategoryName() + ")");
        stringBuffer.append(DELIMITER);
        stringBuffer.append(DELIMITER);
        stringBuffer.append("Description");
        stringBuffer.append(DELIMITER);
        if (this.outgroupFlag) {
            stringBuffer.append("Sub Cluster ID");
            stringBuffer.append(DELIMITER);
            stringBuffer.append("Sub Gene Name");
            stringBuffer.append(DELIMITER);
            stringBuffer.append("Sub Function Category");
            stringBuffer.append(DELIMITER);
            stringBuffer.append(DELIMITER);
            stringBuffer.append("Sub Description");
            stringBuffer.append(DELIMITER);
        }
        if (this.isExistInfoMap()) {
            for (Object object : this.infoTitleList) {
                stringBuffer.append(((AbstractInfoTitle)object).getName());
                stringBuffer.append(DELIMITER);
            }
        }
        int n = 0;
        for (String string : this.organismCodeList) {
            stringBuffer.append(string);
            if (n != this.organismCodeList.size() - 1) {
                stringBuffer.append(DELIMITER);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private String createClusterLine(Cluster cluster) {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(cluster.getClusterId());
        stringBuffer.append(DELIMITER);
        stringBuffer.append(cluster.getGeneName());
        stringBuffer.append(DELIMITER);
        FuncCat funcCat = this.funcCatTbl.getFuncCat(cluster.getFunctionCategory());
        stringBuffer.append(funcCat.getFunctionCategoryNo());
        stringBuffer.append(DELIMITER);
        stringBuffer.append(funcCat.getName());
        stringBuffer.append(DELIMITER);
        stringBuffer.append(cluster.getDescription());
        stringBuffer.append(DELIMITER);
        if (this.outgroupFlag) {
            stringBuffer.append(cluster.getSubClusterId());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(cluster.getSubGeneName());
            stringBuffer.append(DELIMITER);
            object2 = this.funcCatTbl.getFuncCat(cluster.getSubFunctionCategory());
            stringBuffer.append(((FuncCat)object2).getFunctionCategoryNo());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(((FuncCat)object2).getName());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(cluster.getSubDescription());
            stringBuffer.append(DELIMITER);
        }
        if (this.isExistInfoMap()) {
            object2 = (AbstractInfo)this.infoMap.get(cluster.getKey());
            for (Object object3 : this.infoTitleList) {
                object = ((AbstractInfo)object2).getInfo((AbstractInfoTitle)object3);
                stringBuffer.append(object.toString());
                stringBuffer.append(DELIMITER);
            }
        }
        int n = 0;
        for (Object object3 : this.organismCodeList) {
            object = cluster.getGeneInformationList((String)object3);
            this.createLocusTagString(stringBuffer, (List)object);
            if (n != this.organismCodeList.size() - 1) {
                stringBuffer.append(DELIMITER);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private void createLocusTagString(StringBuffer stringBuffer, List list) {
        if (list == null) {
            return;
        }
        int n = 0;
        for (GeneInformation geneInformation : list) {
            stringBuffer.append(geneInformation.getLocusTag());
            if (n != list.size() - 1) {
                stringBuffer.append(LOCUSTAG_DELIMITER);
            }
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        try {
            AbstractDomClustImporter abstractDomClustImporter = AbstractDomClustImporter.createDomClustImporter("testdata/domclust/cluster_list_both");
            abstractDomClustImporter.execute();
            List list = abstractDomClustImporter.getIngroupOrganismCodeList();
            List list2 = abstractDomClustImporter.getOutgroupOrganismCodeList();
            boolean bl = list2.size() != 0;
            DomClustTabExporter domClustTabExporter = new DomClustTabExporter("C:/project/m/tmp/test.cluster", "testdata/domclust/cluster_list_both", abstractDomClustImporter.getClusterList(), bl, list, list2);
            domClustTabExporter.execute();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

