/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.domclust;

import cgdp.recog.data.ClusterTbl;
import cgdp.recog.domclust.DomClustAnalysis;
import cgdp.recog.domclust.DomClustUploader;
import cgdp.recog.info.InfoUtil;
import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.info.cluster.ClusterInfoUploadExecuter;
import cgdp.recog.info.gene.GeneInfoUploadExecuter;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.DummyProgressComponent;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.set.AbstractElementSetFacade;
import cgdp.recog.set.SetUploadExecuter;
import cgdp.recog.set.cluster.ClusterSetFacade;
import cgdp.recog.set.gene.GeneSetFacade;
import cgdp.recog.system.property.ApplicationPropertyFacade;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DomClustUploadExecuter
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(DomClustUploadExecuter.class);
    private Component parent;
    private ClusterTbl clusterTbl;
    private DomClustAnalysis analysis;
    private boolean viewParameter = false;
    private Set unableUploadGeneInfoTitleSet = new HashSet();
    private Set unableUploadClusterInfoTitleSet = new HashSet();
    private Set unableUploadGeneSetSet = new HashSet();
    private Set unableUploadClusterSetSet = new HashSet();

    public DomClustUploadExecuter(Component component, ClusterTbl clusterTbl, DomClustAnalysis domClustAnalysis, boolean bl, boolean bl2) {
        this.parent = component;
        this.clusterTbl = clusterTbl;
        this.analysis = domClustAnalysis;
        this.viewParameter = bl2;
    }

    public void execute(ProgressImpl progressImpl) {
        progressImpl.setTotal(5);
        try {
            if (this.viewParameter) {
                this.unableUploadGeneInfoTitleSet = this.uploadGeneInfo();
                if (progressImpl.isCanceled()) {
                    this.setCancel(true);
                    return;
                }
                progressImpl.increment();
                this.unableUploadClusterInfoTitleSet = this.uploadClusterInfo();
                if (progressImpl.isCanceled()) {
                    this.setCancel(true);
                    return;
                }
                progressImpl.increment();
                this.unableUploadGeneSetSet = this.uploadGeneSet();
                if (progressImpl.isCanceled()) {
                    this.setCancel(true);
                    return;
                }
                progressImpl.increment();
                this.unableUploadClusterSetSet = this.uploadClusterSet();
                if (progressImpl.isCanceled()) {
                    this.setCancel(true);
                    return;
                }
                progressImpl.increment();
            } else {
                progressImpl.setCount(3);
                progressImpl.increment();
            }
            DomClustUploader domClustUploader = new DomClustUploader(this.analysis, false, this.viewParameter);
            domClustUploader.execute();
            progressImpl.increment();
            if (domClustUploader.isErrorAlreadyExist()) {
                if (!MessageManager.showConfirmMessage(this.parent, "Overwrite [" + this.analysis.getName() + "] ?")) {
                    this.setError(true);
                    this.setErrorMessage(domClustUploader.getMessage());
                }
                DomClustUploader domClustUploader2 = new DomClustUploader(this.analysis, true, this.viewParameter);
                domClustUploader2.execute();
                if (domClustUploader2.isError()) {
                    this.setError(true);
                    this.setErrorMessage(domClustUploader2.getMessage());
                }
            } else if (domClustUploader.isError()) {
                this.setError(true);
                this.setErrorMessage(domClustUploader.getMessage());
                return;
            }
        }
        catch (Exception exception) {
            String string = "Fail to upload domclust results.";
            logger.warn(string, exception);
            this.setError(true);
            this.setErrorMessage(string);
        }
    }

    private Set uploadGeneInfo() throws IOException {
        Object object;
        Set set = null;
        try {
            object = new HashSet(this.clusterTbl.getOrganismCodeList());
            set = ApplicationPropertyFacade.getGeneInfoTitleSetFromConfFile(this.analysis.getProject(), this.analysis.getDomClustId(), object);
            if (CollectionUtil.isNull(set)) {
                return new HashSet();
            }
        }
        catch (IOException iOException) {
            String string = "Fail to extract relatived gene properties from app_property etc.";
            logger.warn(string, iOException);
            return new HashSet();
        }
        object = new GeneInfoUploadExecuter(this.parent, set);
        ((GeneInfoUploadExecuter)object).setExecDone(false);
        ((GeneInfoUploadExecuter)object).execute(new DummyProgressComponent());
        return ((GeneInfoUploadExecuter)object).getUnableUploadInfoTitleSet();
    }

    private Set uploadClusterInfo() {
        List list = ClusterInfoFacade.getInfoTitleListWithoutGlobalByDomClustId(3, this.analysis.getDomClustId());
        List list2 = ClusterInfoFacade.getInfoTitleListWithoutGlobalByDomClustId(4, this.analysis.getDomClustId());
        ArrayList arrayList = new ArrayList(list);
        arrayList.addAll(list2);
        if (CollectionUtil.isNull(arrayList)) {
            return new HashSet();
        }
        ClusterInfoUploadExecuter clusterInfoUploadExecuter = new ClusterInfoUploadExecuter(this.parent, arrayList, this.clusterTbl);
        clusterInfoUploadExecuter.setExecDone(false);
        clusterInfoUploadExecuter.execute(new DummyProgressComponent());
        return clusterInfoUploadExecuter.getUnableUploadTitleSet();
    }

    private Set uploadGeneSet() {
        List list = GeneSetFacade.getElementSetList(1, this.analysis.getDomClustId());
        if (CollectionUtil.isNull(list)) {
            return new HashSet();
        }
        SetUploadExecuter setUploadExecuter = new SetUploadExecuter(this.parent, list, this.analysis.getProject());
        setUploadExecuter.setExecDone(false);
        setUploadExecuter.execute(new DummyProgressComponent());
        return setUploadExecuter.getUnableUploadSetSet();
    }

    private Set uploadClusterSet() {
        List list = ClusterSetFacade.getElementSetList(2, this.analysis.getDomClustId());
        if (CollectionUtil.isNull(list)) {
            return new HashSet();
        }
        SetUploadExecuter setUploadExecuter = new SetUploadExecuter(this.parent, list, this.analysis.getProject());
        setUploadExecuter.setExecDone(false);
        setUploadExecuter.execute(new DummyProgressComponent());
        return setUploadExecuter.getUnableUploadSetSet();
    }

    public void done() {
        if (this.isCancel()) {
            return;
        }
        if (!(CollectionUtil.isNull(this.unableUploadGeneInfoTitleSet) && CollectionUtil.isNull(this.unableUploadClusterInfoTitleSet) && CollectionUtil.isNull(this.unableUploadGeneSetSet) && CollectionUtil.isNull(this.unableUploadClusterSetSet))) {
            HashSet hashSet = new HashSet(this.unableUploadGeneInfoTitleSet);
            hashSet.addAll(this.unableUploadClusterInfoTitleSet);
            ArrayList<String> arrayList = new ArrayList<String>();
            if (!CollectionUtil.isNull(this.unableUploadGeneInfoTitleSet) || !CollectionUtil.isNull(this.unableUploadClusterInfoTitleSet)) {
                arrayList.add("The following property was not able to be uploaded.");
                if (!CollectionUtil.isNull(this.unableUploadGeneInfoTitleSet)) {
                    arrayList.add("  Gene:" + InfoUtil.createInfoTitleNameString(this.unableUploadGeneInfoTitleSet));
                }
                if (!CollectionUtil.isNull(this.unableUploadClusterInfoTitleSet)) {
                    arrayList.add("  Cluster:" + InfoUtil.createInfoTitleNameString(this.unableUploadClusterInfoTitleSet));
                }
            }
            if (!CollectionUtil.isNull(this.unableUploadGeneSetSet) || !CollectionUtil.isNull(this.unableUploadClusterSetSet)) {
                if (!arrayList.isEmpty()) {
                    arrayList.add(FileUtil.LINE_SEPARETOR);
                }
                arrayList.add("The following set was not able to be uploaded.");
                if (!CollectionUtil.isNull(this.unableUploadGeneSetSet)) {
                    arrayList.add("  Gene:" + AbstractElementSetFacade.createElementSetNameString(this.unableUploadGeneSetSet));
                }
                if (!CollectionUtil.isNull(this.unableUploadClusterSetSet)) {
                    arrayList.add("  Cluster:" + AbstractElementSetFacade.createElementSetNameString(this.unableUploadClusterSetSet));
                }
            }
            String[] stringArray = new String[arrayList.size()];
            int n = 0;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string;
                stringArray[n] = string = (String)iterator.next();
                ++n;
            }
            MessageManager.showErrorMessage(this.parent, stringArray);
        }
        if (this.isError()) {
            MessageManager.showErrorMessage(this.parent, this.getErrorMessages());
            return;
        }
    }
}

