/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.domclust;

import cgdp.recog.data.DataManager;
import cgdp.recog.domclust.DomClustAnalysis;
import cgdp.recog.server.AbstractServerResourceAccesser;
import cgdp.recog.system.Codec;
import cgdp.recog.system.URLList;
import cgdp.recog.system.property.ApplicationPropertyConf;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.StringTool;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;

class DomClustUploader
extends AbstractServerResourceAccesser {
    private static final ApplicationLogger logger = new ApplicationLogger(DomClustUploader.class);
    private static final String FILE_PREFIX_DELIMITER = "\t";
    private DomClustAnalysis analysis;
    private boolean overwrite = false;
    private boolean viewParameters = false;

    DomClustUploader(DomClustAnalysis domClustAnalysis, boolean bl, boolean bl2) throws UnsupportedEncodingException {
        this.analysis = domClustAnalysis;
        this.overwrite = bl;
        this.viewParameters = bl2;
        this.setProject(domClustAnalysis.getProject());
        this.setContextPath(URLList.getInstance().getPutProjectCluster());
        this.setOptions();
    }

    protected void parseOutputStringData(int n, String string) {
    }

    private void setOptions() throws UnsupportedEncodingException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("proj_id=");
        stringBuffer.append(Codec.encode(this.analysis.getProjectId4Server()));
        stringBuffer.append("&mode=");
        if (this.overwrite) {
            stringBuffer.append("replace");
        }
        stringBuffer.append("&type=domclust");
        stringBuffer.append("&clusttabid=");
        stringBuffer.append(Codec.encode(this.analysis.getDomClustId()));
        stringBuffer.append("&name=");
        stringBuffer.append(Codec.encode(this.analysis.getName()));
        stringBuffer.append("&descr=");
        stringBuffer.append(Codec.encode(this.analysis.getDescription()));
        stringBuffer.append("&view_opts=");
        if (this.viewParameters) {
            stringBuffer.append(Codec.encode(this.getPropertyFileString()));
        }
        this.setOptions(stringBuffer.toString());
    }

    private String getPropertyFileString() {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        String string = DataManager.getDomClustDirpath(this.analysis.getProject(), this.analysis.getDomClustId());
        for (int i = 0; i < ApplicationPropertyConf.CONF_FILE_NAMES.length; ++i) {
            object2 = ApplicationPropertyConf.CONF_FILE_NAMES[i];
            object = new File(string, (String)object2);
            if (!((File)object).isFile()) continue;
            stringBuffer.append(this.createFileContents(((File)object).getAbsolutePath()));
        }
        String string2 = DataManager.getDomClustDataDirPath(this.analysis.getDomClustId());
        object2 = new File(string2);
        if (((File)object2).isDirectory()) {
            object = FileUtil.listFiles((File)object2);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                stringBuffer.append(this.createFileContents(file.getAbsolutePath()));
            }
        }
        return stringBuffer.toString();
    }

    private String createFileContents(String string) {
        return this.createFileContents(string, null);
    }

    private String createFileContents(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!new File(string).isFile()) {
            return stringBuffer.toString();
        }
        int n = string.indexOf(this.analysis.getDomClustId());
        String string3 = string.substring(n + this.analysis.getDomClustId().length() + 1, string.length());
        try {
            String string4 = FileUtil.readFile(string);
            if (!StringTool.isNull(string4)) {
                stringBuffer.append("===");
                stringBuffer.append(string3);
                stringBuffer.append(FileUtil.LINE_SEPARETOR);
                stringBuffer.append(string4);
                if (!string4.endsWith(FileUtil.LINE_SEPARETOR)) {
                    stringBuffer.append(FileUtil.LINE_SEPARETOR);
                }
            }
        }
        catch (IOException iOException) {
            String string5 = "Fail to read property file. " + string;
            logger.warn(string5, iOException);
        }
        return stringBuffer.toString();
    }
}

