/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.domclust;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.coregenome.CoreGenomeAlignment;
import cgdp.recog.coregenome.CoreGenomeImporter;
import cgdp.recog.coregenome.CoreGenomeUtil;
import cgdp.recog.coregenome.FileCoreGenomeAlignment;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.ClusterTblCreater;
import cgdp.recog.domclust.AbstractDomClustImporter;
import cgdp.recog.domclust.DomClustFileOpenHelper;
import cgdp.recog.mapping.MapFacade;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.ProcessImpl;
import cgdp.recog.process.ProgressDialog;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.system.property.ApplicationPropertyConf;
import cgdp.recog.system.property.ApplicationPropertyFacade;
import cgdp.recog.system.property.ApplicationPropertyVirtualFile;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.StringTool;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class FileLoader
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(FileLoader.class);
    private MediatorImpl mediator;
    private Component parent;
    private String domClustFilepath;
    private String domClustFormat = "dclst";
    private ApplicationPropertyConf conf;
    private String coreGenomeFilepath;
    private boolean loadDomClust = true;
    private boolean loadCoreGenome = false;
    private boolean domClustImport = false;
    private ClusterTbl clusterTbl;

    private FileLoader(Component component, MediatorImpl mediatorImpl) {
        this.parent = component;
        this.mediator = mediatorImpl;
    }

    public static FileLoader createDomClustLoader(Component component, MediatorImpl mediatorImpl, String string) {
        FileLoader fileLoader = new FileLoader(component, mediatorImpl);
        fileLoader.setDomClust(string);
        return fileLoader;
    }

    public static FileLoader createDomClustLoader(Component component, MediatorImpl mediatorImpl, File file) {
        FileLoader fileLoader = new FileLoader(component, mediatorImpl);
        fileLoader.setDomClustFile(file);
        return fileLoader;
    }

    public static FileLoader createDomClustImporter(Component component, MediatorImpl mediatorImpl, String string, String string2) {
        FileLoader fileLoader = new FileLoader(component, mediatorImpl);
        fileLoader.setDomClust(string);
        fileLoader.setDomClustImport(true);
        fileLoader.domClustFormat = string2;
        return fileLoader;
    }

    public static FileLoader createCoreGenomeLoader(Component component, MediatorImpl mediatorImpl, ClusterTbl clusterTbl, String string) {
        FileLoader fileLoader = new FileLoader(component, mediatorImpl);
        if (!fileLoader.setCoreGenome(clusterTbl, string)) {
            return null;
        }
        return fileLoader;
    }

    private void setDomClust(String string) {
        this.domClustFilepath = string;
    }

    private void setConf(ApplicationPropertyConf applicationPropertyConf) {
        this.conf = applicationPropertyConf;
    }

    private void setDomClustFile(File file) {
        if (file instanceof ApplicationPropertyVirtualFile) {
            ApplicationPropertyVirtualFile applicationPropertyVirtualFile = (ApplicationPropertyVirtualFile)file;
            File file2 = applicationPropertyVirtualFile.getRealFile();
            this.setDomClust(file2.getAbsolutePath());
            this.setConf(applicationPropertyVirtualFile.getConf());
        } else {
            this.setDomClust(file.getAbsolutePath());
        }
    }

    private boolean setCoreGenome(ClusterTbl clusterTbl, String string) {
        this.coreGenomeFilepath = string;
        this.clusterTbl = clusterTbl;
        this.loadCoreGenome = true;
        return this.searchDomClust();
    }

    private boolean searchDomClust() {
        try {
            String string = null;
            String string2 = null;
            if (this.clusterTbl != null) {
                string = this.clusterTbl.getClusterId();
                string2 = this.clusterTbl.getClusterViewId();
            }
            CoreGenomeImporter coreGenomeImporter = new CoreGenomeImporter(this.coreGenomeFilepath);
            coreGenomeImporter.setParameterOnly(true);
            coreGenomeImporter.execute();
            String string3 = coreGenomeImporter.getGenomeAlign().getDomClustId();
            String string4 = coreGenomeImporter.getGenomeAlign().getClusterViewId();
            if (!StringTool.isNull(string2) && !StringTool.isNull(string4)) {
                if (string2.equals(string4)) {
                    this.loadDomClust = false;
                    return true;
                }
                if (!StringTool.isNull(string) && string.equals(string3)) {
                    String string5 = ProjectAccesser.searchDomClustFileByClsterViewId(string4);
                    if (string5 != null) {
                        this.domClustFilepath = string5;
                        this.loadDomClust = true;
                        return true;
                    }
                    this.loadDomClust = false;
                    return true;
                }
                String string6 = ProjectAccesser.searchDomClustFileByClsterViewId(string4);
                if (!StringTool.isNull(string6)) {
                    this.domClustFilepath = string6;
                    this.loadDomClust = true;
                    return true;
                }
                string6 = ProjectAccesser.searchDomClustFileByDomClustId(string3);
                if (!StringTool.isNull(string6)) {
                    this.domClustFilepath = string6;
                    this.loadDomClust = true;
                    return true;
                }
                return false;
            }
            if (StringTool.isNull(string2) && !StringTool.isNull(string4)) {
                String string7 = ProjectAccesser.searchDomClustFileByClsterViewId(string4);
                if (string7 != null) {
                    this.domClustFilepath = string7;
                    this.loadDomClust = true;
                    return true;
                }
                if (!StringTool.isNull(string) && string.equals(string3)) {
                    this.loadDomClust = false;
                    return true;
                }
                string7 = ProjectAccesser.searchDomClustFileByDomClustId(string3);
                if (!StringTool.isNull(string7)) {
                    this.domClustFilepath = string7;
                    this.loadDomClust = true;
                    return true;
                }
                return false;
            }
            if (!StringTool.isNull(string) && string.equals(string3)) {
                this.loadDomClust = false;
                return true;
            }
            String string8 = ProjectAccesser.searchDomClustFileByDomClustId(string3);
            if (!StringTool.isNull(string8)) {
                this.domClustFilepath = string8;
                this.loadDomClust = true;
                return true;
            }
            return false;
        }
        catch (IOException iOException) {
            logger.warn("Fail to search domclust file.", iOException);
            return false;
        }
    }

    public boolean isLoadDomClust() {
        return this.loadDomClust;
    }

    private boolean isLoadCoreGenome() {
        return this.loadCoreGenome;
    }

    public boolean isDomClustImport() {
        return this.domClustImport;
    }

    public void setDomClustImport(boolean bl) {
        this.domClustImport = bl;
    }

    public void execute(ProgressImpl progressImpl) {
        try {
            final ClusterTbl clusterTbl = this.loadDomClust(progressImpl);
            if (clusterTbl == null) {
                return;
            }
            Runnable runnable = new Runnable(){

                public void run() {
                    FileLoader.this.mediator.updateForLoadDomClust(clusterTbl);
                    if (FileLoader.this.isLoadCoreGenome()) {
                        FileLoader.this.loadCoreGenome(FileLoader.this.coreGenomeFilepath, clusterTbl);
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
        catch (Exception exception) {
            String string = "Fail to load domclust file.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage(this.parent, string);
        }
    }

    private ClusterTbl loadDomClust(ProgressImpl progressImpl) throws Exception {
        Object object;
        if (!this.isLoadDomClust()) {
            return this.clusterTbl;
        }
        DomClustFileOpenHelper domClustFileOpenHelper = new DomClustFileOpenHelper(this.parent, this.mediator, this.domClustFilepath);
        if (this.isDomClustImport() && !domClustFileOpenHelper.copyDomClustFileToProjectDir()) {
            return null;
        }
        this.mediator.newAnalysis();
        domClustFileOpenHelper.changeAccessServer();
        this.mediator.updateDataForDomClustOpen(domClustFileOpenHelper.getOrganismCodeSet());
        MapFacade.saveDefaultMap(domClustFileOpenHelper.getOrganismCodeSet());
        String string = DomClustFileOpenHelper.getNewDomClustFilepath(this.domClustFilepath);
        AbstractDomClustImporter abstractDomClustImporter = AbstractDomClustImporter.createDomClustImporter(string, this.domClustFormat);
        abstractDomClustImporter.setProgressImpl(progressImpl);
        abstractDomClustImporter.setParameterOnly(false);
        abstractDomClustImporter.execute();
        if (abstractDomClustImporter.isCanceled()) {
            return null;
        }
        Project project = ProjectAccesser.getSelectedProject();
        if (this.conf != null) {
            ApplicationPropertyFacade.replaceConf(project, this.conf);
        } else {
            object = ApplicationPropertyConf.createDefaultConf(abstractDomClustImporter.getDomClustId(), abstractDomClustImporter.getClusterViewId());
            ApplicationPropertyFacade.replaceConf(project, (ApplicationPropertyConf)object);
        }
        if (!abstractDomClustImporter.isExistCluster()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MessageManager.showMessage(FileLoader.this.parent, "There is no cluster.");
                }
            });
            return null;
        }
        this.mediator.readTaxonomyData(abstractDomClustImporter.getDomClustId());
        object = new ClusterTblCreater(string, abstractDomClustImporter.getDomClustId(), abstractDomClustImporter.getClusterViewId(), abstractDomClustImporter.getIngroupOrganismCodeList(), abstractDomClustImporter.getOutgroupOrganismCodeList(), abstractDomClustImporter.getClusterList(), abstractDomClustImporter.getServerUrl(), abstractDomClustImporter.isExistHomCluster(), abstractDomClustImporter.getDomClustConditionString(), this.conf);
        ((ClusterTblCreater)object).execute(progressImpl);
        ClusterTbl clusterTbl = ((ClusterTblCreater)object).getClusterTbl();
        return clusterTbl;
    }

    private void loadCoreGenome(String string, ClusterTbl clusterTbl) {
        ArrayList arrayList = new ArrayList(clusterTbl.getOrganismList());
        CoreGenomeUtil.setInOutgroupForOrganims(arrayList, clusterTbl.getIngroupSpList(), clusterTbl.getOutgroupSpList());
        FileCoreGenomeAlignment fileCoreGenomeAlignment = CoreGenomeAlignment.createFileCoreGenomeAlignment(this.mediator, this.parent, clusterTbl, string, arrayList);
        ProgressDialog.executeProgress(this.parent, this.mediator, 100, ((CoreGenomeAlignment)fileCoreGenomeAlignment).getProgressMessages(), true, (ProcessImpl)fileCoreGenomeAlignment);
    }

    public void done() {
    }
}

