/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.filefilter;

import cgdp.recog.filefilter.AllFileFilter;
import cgdp.recog.filefilter.AllRecogFileFilter;
import cgdp.recog.filefilter.CoreGenomeIOFileFilter;
import cgdp.recog.filefilter.DomClustIOFileFilter;
import cgdp.recog.filefilter.FastAFileFilter;
import cgdp.recog.filefilter.FileExtension;
import cgdp.recog.filefilter.PhpatIOFileFilter;
import cgdp.recog.filefilter.SingleFileFilter;
import java.util.List;

public class FileFilterFactory {
    private FileFilterFactory() {
    }

    public static final SingleFileFilter createDomClustFileFilter() {
        SingleFileFilter singleFileFilter = new SingleFileFilter(FileExtension.getDomClustFileExtensionList(), "DomClust File(" + FileExtension.getDomClustFileExtensionString() + ")");
        singleFileFilter.setFilterType(1);
        return singleFileFilter;
    }

    public static final SingleFileFilter createDomClustFileWithDirFilter() {
        SingleFileFilter singleFileFilter = new SingleFileFilter(FileExtension.getDomClustFileExtensionList(), "DomClust File(" + FileExtension.getDomClustFileExtensionString() + ")", true);
        singleFileFilter.setFilterType(2);
        return singleFileFilter;
    }

    public static final SingleFileFilter createPhpadFileFilter() {
        SingleFileFilter singleFileFilter = new SingleFileFilter(FileExtension.getPhylopatFileExtensionList(), "Phylogenetic Pattern Clustering File(" + FileExtension.getPhylopatFileExtensionString() + ")");
        singleFileFilter.setFilterType(15);
        return singleFileFilter;
    }

    public static final SingleFileFilter createGeneInfoFileWithDirFilter() {
        SingleFileFilter singleFileFilter = new SingleFileFilter((List)null, "Gene Property File(.*)", true);
        singleFileFilter.setFilterType(3);
        return singleFileFilter;
    }

    public static final SingleFileFilter createGeneInfoFileProjectWithDirFilter() {
        SingleFileFilter singleFileFilter = new SingleFileFilter((List)null, "Gene Property File(Save to the project) (.*)", true);
        singleFileFilter.setFilterType(5);
        return singleFileFilter;
    }

    public static final SingleFileFilter createClusterInfoFileWithDirFilter() {
        SingleFileFilter singleFileFilter = new SingleFileFilter((List)null, "Cluster Property File(.*)", true);
        singleFileFilter.setFilterType(14);
        return singleFileFilter;
    }

    public static final SingleFileFilter createGeneSetFileWithDirFilter() {
        SingleFileFilter singleFileFilter = new SingleFileFilter((List)null, "Gene Set File(.*)", true);
        singleFileFilter.setFilterType(8);
        return singleFileFilter;
    }

    public static final SingleFileFilter createGeneSetProjectFileWithDirFilter() {
        SingleFileFilter singleFileFilter = new SingleFileFilter((List)null, "Gene Set File(.*)", true);
        singleFileFilter.setFilterType(9);
        return singleFileFilter;
    }

    public static final SingleFileFilter createClusterSetFileWithDirFilter() {
        SingleFileFilter singleFileFilter = new SingleFileFilter((List)null, "Cluster Set File(.*)", true);
        singleFileFilter.setFilterType(10);
        return singleFileFilter;
    }

    public static final SingleFileFilter createClusterSetProjectFileWithDirFilter() {
        SingleFileFilter singleFileFilter = new SingleFileFilter((List)null, "Cluster Set File(.*)", true);
        singleFileFilter.setFilterType(11);
        return singleFileFilter;
    }

    public static final SingleFileFilter createDomClustTabFileWithDirFilter() {
        SingleFileFilter singleFileFilter = new SingleFileFilter(".clusttab", "DomClust Tab File(.clusttab)", true);
        singleFileFilter.setFilterType(4);
        return singleFileFilter;
    }

    public static final SingleFileFilter createCoreGenomeFileFilter() {
        SingleFileFilter singleFileFilter = new SingleFileFilter(FileExtension.getCoreGenomeFileExtensionList(), "Core Genome File(" + FileExtension.getCoreGenomeFileExtensionString() + ")");
        singleFileFilter.setFilterType(5);
        return singleFileFilter;
    }

    public static final SingleFileFilter createPPMPdfFileWithDirFilter() {
        SingleFileFilter singleFileFilter = new SingleFileFilter(".pdf", "PPM Image PDF(.pdf)", true);
        singleFileFilter.setFilterType(6);
        return singleFileFilter;
    }

    public static final AllRecogFileFilter createAllRecogFileFilter() {
        return new AllRecogFileFilter();
    }

    public static final AllFileFilter createAllFileFilter() {
        return new AllFileFilter();
    }

    public static final DomClustIOFileFilter createDomClustIOFileFilter() {
        return new DomClustIOFileFilter();
    }

    public static final PhpatIOFileFilter createPhpatIOFileFilter() {
        return new PhpatIOFileFilter();
    }

    public static final CoreGenomeIOFileFilter createCoreGenomeIOFileFilter() {
        return new CoreGenomeIOFileFilter();
    }

    public static final FastAFileFilter createFastAFileFilter() {
        return new FastAFileFilter();
    }

    public static final SingleFileFilter createGeneSetFileFilter() {
        SingleFileFilter singleFileFilter = new SingleFileFilter(".gset", "Gene set File(.gset)");
        singleFileFilter.setFilterType(13);
        return singleFileFilter;
    }

    public static final SingleFileFilter createGeneSetDetailFileFilter() {
        SingleFileFilter singleFileFilter = new SingleFileFilter(".txt", "Gene information File(.txt)");
        singleFileFilter.setFilterType(16);
        return singleFileFilter;
    }

    public static final SingleFileFilter createClusterSetFileFilter() {
        SingleFileFilter singleFileFilter = new SingleFileFilter(".clusttab", "Cluster set File(.clusttab)");
        singleFileFilter.setFilterType(12);
        return singleFileFilter;
    }

    public static final SingleFileFilter createTextFileWithDirFilter() {
        SingleFileFilter singleFileFilter = new SingleFileFilter(".txt", "Text File(.txt)", true);
        singleFileFilter.setFilterType(100);
        return singleFileFilter;
    }
}

