/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.filter;

import cgdp.recog.filter.AbstractFilterNode;
import cgdp.recog.filter.CountFilterCondition;
import cgdp.recog.filter.FilterUtil;
import cgdp.recog.filter.GeneCountFilterCondition;
import cgdp.recog.filter.OrganismCountFilterCondition;

public class CountFilterTreeNode
extends AbstractFilterNode {
    public CountFilterTreeNode(CountFilterCondition countFilterCondition) {
        super(countFilterCondition);
        this.setUserObject(this.getLabel());
    }

    private boolean isTargetGene() {
        return this.getFilterActivation() instanceof GeneCountFilterCondition;
    }

    private boolean isTargetOrganism() {
        return this.getFilterActivation() instanceof OrganismCountFilterCondition;
    }

    private String getPrefix() {
        String string = "";
        string = this.isTargetGene() ? "Gene" : "Organism";
        return string;
    }

    private String getLabel() {
        return this.getPrefix() + "[" + FilterUtil.createThresholdString(this.getCountFilterCondition().isLessFilter(), this.getCountFilterCondition().isMoreFilter(), this.getCountFilterCondition().getLessThreshold(), this.getCountFilterCondition().getMoreThreshold()) + "]";
    }

    public CountFilterCondition getCountFilterCondition() {
        return (CountFilterCondition)this.getFilterActivation();
    }

    public boolean isLeaf() {
        return true;
    }
}

