/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.filter;

import cgdp.recog.data.Cluster;
import cgdp.recog.filter.CountFilterCondition;
import cgdp.recog.project.Project;
import cgdp.recog.system.property.ApplicationProperty;
import cgdp.recog.util.Converter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GeneCountFilterCondition
extends CountFilterCondition {
    public List getPropertyList(Project project, String string) {
        ArrayList<ApplicationProperty> arrayList = new ArrayList<ApplicationProperty>();
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "FilterCountGeneLessFlag", String.valueOf(this.isLessFilter())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "FilterCountGeneMoreFlag", String.valueOf(this.isMoreFilter())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "FilterCountGeneLessCount", String.valueOf(this.getLessThreshold())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "FilterCountGeneMoreCount", String.valueOf(this.getMoreThreshold())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "FilterCountGeneEnable", String.valueOf(this.isFilterActive())));
        return arrayList;
    }

    public void updateProperty(Map map, Project project, String string) {
        Object v = map.get("FilterCountGeneLessFlag");
        if (v != null) {
            this.setLessFilter(Converter.convertBool(v));
        }
        if ((v = map.get("FilterCountGeneMoreFlag")) != null) {
            this.setMoreFilter(Converter.convertBool(v));
        }
        if ((v = map.get("FilterCountGeneLessCount")) != null) {
            this.setLessThreshold(Converter.convertInt(v));
        }
        if ((v = map.get("FilterCountGeneMoreCount")) != null) {
            this.setMoreThreshold(Converter.convertInt(v));
        }
        if ((v = map.get("FilterCountGeneEnable")) != null) {
            this.setFilterActive(Converter.convertBool(v));
        }
    }

    public boolean isMatchCount(Cluster cluster) {
        return GeneCountFilterCondition.isMatchCount(cluster.getGeneCount(), this.getLessThreshold(), this.getMoreThreshold(), this.isLessFilter(), this.isMoreFilter());
    }

    public boolean isSyncEnable() {
        return false;
    }
}

