/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.funccat;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.funccat.FuncCat;
import cgdp.recog.funccat.FuncCatTbl;
import cgdp.recog.funccat.FunctionCategoryColorCellRenderer;
import cgdp.recog.funccat.FunctionCategoryImporter;
import cgdp.recog.funccat.FunctionCategoryLabelCellRenderer;
import cgdp.recog.funccat.FunctionCategoryTableModel;
import cgdp.recog.funccat.FunctionCategoryType;
import cgdp.recog.funccat.FunctionColorUtil;
import cgdp.recog.menu.SyncPPMSelectItem;
import cgdp.recog.menu.UrlItem;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.server.AccessServer;
import cgdp.recog.set.cluster.ClusterSetCondition;
import cgdp.recog.system.OS;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.ColorUtil;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.StringTool;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;

public class FuncCatTable
extends JPanel
implements MouseListener,
ActionListener,
ItemListener,
ListSelectionListener {
    private static ApplicationLogger logger = new ApplicationLogger(FuncCatTable.class);
    private MediatorImpl mediator;
    private OptionTbl optionTbl = OptionTbl.getInstance();
    private FuncCatTbl funcCatTbl = FuncCatTbl.getInstance();
    private JComboBox typeComboBox;
    private JTable functionCategoryTable;
    private JScrollPane scrollPane;
    private ListSelectionModel listSelectionModel;
    private ClusterSetCondition ppmFilterClusterSetCodition = null;

    public FuncCatTable(MediatorImpl mediatorImpl) {
        this.mediator = mediatorImpl;
        this.createComponent();
    }

    private void createComponent() {
        JLabel jLabel = new JLabel("Function Category:");
        this.typeComboBox = new JComboBox<String>(FunctionCategoryType.DISPLAY_LIST);
        this.typeComboBox.addItemListener(this);
        this.functionCategoryTable = new JTable(new FunctionCategoryTableModel(this.funcCatTbl.getCopyFuncCatList()));
        this.functionCategoryTable.addMouseListener(this);
        this.functionCategoryTable.setSelectionMode(0);
        this.functionCategoryTable.setRowHeight(20);
        this.listSelectionModel = this.functionCategoryTable.getSelectionModel();
        this.listSelectionModel.addListSelectionListener(this);
        TableColumn tableColumn = this.functionCategoryTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new FunctionCategoryLabelCellRenderer());
        TableColumn tableColumn2 = this.functionCategoryTable.getColumnModel().getColumn(1);
        tableColumn2.setMaxWidth(80);
        tableColumn2.setCellRenderer(new FunctionCategoryColorCellRenderer());
        this.scrollPane = new JScrollPane(this.functionCategoryTable, 20, 31);
        this.scrollPane.setPreferredSize(new Dimension(450, 320));
        this.setLayout(new GridBagLayout());
        this.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.add((Component)this.typeComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.add((Component)this.scrollPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.updateValue();
    }

    public void setTableHeight(int n) {
        this.scrollPane.setPreferredSize(new Dimension(this.scrollPane.getPreferredSize().width, n));
    }

    private void updateValue() {
        String string = this.optionTbl.getOptionValues().getFunctionCategoryType();
        String string2 = FunctionCategoryType.getType2Display(string);
        this.typeComboBox.setSelectedItem(string2);
    }

    private void showPopup(Point point, int n) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        FuncCat funcCat = (FuncCat)this.functionCategoryTable.getValueAt(n, 0);
        String string = AccessServer.getInstance().getServerUrl();
        String string2 = string + this.optionTbl.getOptionValues().getFuncCatUrl();
        string2 = string2.replaceAll("%%%FUNC_CAT%%%", funcCat.getFunctionCategoryNo());
        jPopupMenu.add(new UrlItem(this, this.mediator, "Function Category", string2));
        jPopupMenu.add(new SyncPPMSelectItem(this, this.mediator, "Synchronize PPM Filter", this));
        jPopupMenu.show(this.functionCategoryTable, point.x, point.y);
    }

    private void setFuncCatColor(int n) {
        FuncCat funcCat = (FuncCat)this.functionCategoryTable.getValueAt(n, 1);
        Color color = JColorChooser.showDialog(this, "Color palette", ColorUtil.str2Color(funcCat.getColor()));
        if (color != null) {
            funcCat.setColor(ColorUtil.color2Str(color));
            this.functionCategoryTable.repaint();
        }
    }

    public void setFuncCatColor() {
        String string = this.getSelectedFunctionCategoryType();
        FunctionCategoryTableModel functionCategoryTableModel = (FunctionCategoryTableModel)this.functionCategoryTable.getModel();
        List list = functionCategoryTableModel.getFuncCatList();
        try {
            this.funcCatTbl.readFuncCat(string);
            for (FuncCat funcCat : list) {
                ((FuncCat)this.funcCatTbl.get(funcCat.getFunctionCategoryNo())).setColor(funcCat.getColor());
            }
            this.funcCatTbl.writeFuncCat(string);
            this.optionTbl.getOptionValues().setFunctionCategoryType(string);
        }
        catch (IOException iOException) {
            String string2 = "Fail to load function category file.";
            logger.warn(string2, iOException);
            MessageManager.showErrorMessage((Component)this, string2);
        }
    }

    public void restoreFuncCatColor() {
        FunctionCategoryTableModel functionCategoryTableModel = (FunctionCategoryTableModel)this.functionCategoryTable.getModel();
        List list = this.funcCatTbl.getCopyFuncCatList();
        functionCategoryTableModel.setFuncCatList(list);
    }

    public String getSelectedFunctionCategoryType() {
        String string = (String)this.typeComboBox.getSelectedItem();
        return FunctionCategoryType.getDisplay2Type(string);
    }

    public List getFunctionCategoryList() {
        FunctionCategoryTableModel functionCategoryTableModel = (FunctionCategoryTableModel)this.functionCategoryTable.getModel();
        return functionCategoryTableModel.getFuncCatList();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!OS.isWindows()) {
            this.showColorChooser(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (OS.isWindows()) {
            this.showColorChooser(mouseEvent);
        }
    }

    private void showColorChooser(MouseEvent mouseEvent) {
        int n = this.functionCategoryTable.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.functionCategoryTable.columnAtPoint(mouseEvent.getPoint());
        if (n >= 0 && n2 == 0 && mouseEvent.isPopupTrigger()) {
            this.showPopup(mouseEvent.getPoint(), n);
        } else if (n >= 0 && n2 == 1) {
            this.setFuncCatColor(n);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ((CommandImpl)actionEvent.getSource()).execute();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 2) {
            return;
        }
        if (itemEvent.getSource() == this.typeComboBox) {
            try {
                String string = this.getSelectedFunctionCategoryType();
                FunctionCategoryImporter functionCategoryImporter = new FunctionCategoryImporter(string);
                functionCategoryImporter.execute();
                Map map = functionCategoryImporter.getFunctionCategoryMap();
                this.setColorForNullColor(map);
                ArrayList arrayList = new ArrayList(map.values());
                FunctionCategoryTableModel functionCategoryTableModel = (FunctionCategoryTableModel)this.functionCategoryTable.getModel();
                functionCategoryTableModel.setFuncCatList(arrayList);
                this.updateFuncCatFilter();
            }
            catch (IOException iOException) {
                logger.warn("", iOException);
            }
        }
    }

    private void setColorForNullColor(Map map) {
        for (FuncCat funcCat : map.values()) {
            if (!StringTool.isNull(funcCat.getColor())) continue;
            String string = FunctionColorUtil.getFunctionCategoryColorString(funcCat, map);
            funcCat.setColor(string);
        }
    }

    public void updateFuncCatFilter() {
        if (!this.optionTbl.getOptionValues().getSyncPPMFilter()) {
            this.removeFuncCatFilter();
            return;
        }
        this.mediator.applyFunctionCategoryColor(this.getSelectedFunctionCategoryType(), this.getFunctionCategoryList());
        int n = this.functionCategoryTable.getSelectedRow();
        if (n < 0) {
            this.removeFuncCatFilter();
            return;
        }
        FuncCat funcCat = (FuncCat)this.functionCategoryTable.getValueAt(n, 0);
        ArrayList<FuncCat> arrayList = new ArrayList<FuncCat>();
        arrayList.add(funcCat);
        this.ppmFilterClusterSetCodition = this.mediator.setFuncCatFilterCondition(this.getSelectedFunctionCategoryType(), arrayList);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateFuncCatFilter();
    }

    public void removeFuncCatFilter() {
        if (this.ppmFilterClusterSetCodition != null) {
            this.mediator.removeFuncCatFilter(this.ppmFilterClusterSetCodition);
            this.ppmFilterClusterSetCodition = null;
        }
    }
}

