/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.gmap;

import cgdp.recog.bean.Commons;
import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.ClusterUtil;
import cgdp.recog.data.Gene;
import cgdp.recog.data.GeneInformation;
import cgdp.recog.data.GeneTbl;
import cgdp.recog.funccat.FunctionColorUtil;
import cgdp.recog.gmap.GenomeMapCondition;
import cgdp.recog.gmap.GenomeMapFrame;
import cgdp.recog.organism.Organism;
import cgdp.recog.util.AbstractPrintExecuter;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.GeneUtil;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JPanel;

class GenomeMap
extends JPanel
implements MouseListener,
MouseMotionListener {
    private GenomeMapFrame genomeMapFrame;
    private MediatorImpl m_mediatorImpl;
    private ClusterTbl clusterTbl;
    private GeneTbl m_geneTbl;
    BufferedImage m_image;
    Graphics m_g;
    Font m_font;
    Font m_fontNameI;
    Font m_fontName;
    FontMetrics m_fm;
    FontMetrics m_fmNameI;
    FontMetrics m_fmName;
    int m_id;
    private Organism organism;
    private boolean m_circular;
    private int m_length;
    private double m_diameter;
    double m_xOft1;
    double m_xOft2;
    double m_scale;
    double m_width;
    double m_height;
    private double m_cx;
    private double m_cy;
    DecimalFormat m_df;
    Point m_point;
    int m_pos;
    int m_from;
    int m_to;
    int m_selMode;
    double m_keepAngle;
    Color m_fColor;
    Color m_rColor;
    private Set highlightLocusTagSet = new HashSet();
    double m_geneH;
    Rectangle2D.Double m_rP;
    Rectangle2D.Double m_rM;
    Rectangle m_laneR;
    private GenomeMapCondition genomeMapCondition;

    GenomeMap(GenomeMapFrame genomeMapFrame, MediatorImpl mediatorImpl) {
        this.m_mediatorImpl = mediatorImpl;
        this.genomeMapFrame = genomeMapFrame;
        this.clear();
        this.setLayout(null);
        this.setFont(new Font("Monospaced", 0, 12));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    void updateValue(GenomeMapCondition genomeMapCondition) {
        this.genomeMapCondition = genomeMapCondition;
        this.updateGenomeMap();
    }

    private void clear() {
        this.m_image = null;
        this.m_g = null;
        this.m_font = new Font("Monospaced", 0, 12);
        this.m_fontNameI = new Font("Monospaced", 2, 16);
        this.m_fontName = new Font("Monospaced", 0, 16);
        this.m_fm = this.getFontMetrics(this.m_font);
        this.m_fmNameI = this.getFontMetrics(this.m_fontNameI);
        this.m_fmName = this.getFontMetrics(this.m_fontName);
        this.m_id = 0;
        this.organism = null;
        this.m_circular = false;
        this.m_length = 0;
        this.m_diameter = 0.0;
        this.m_xOft1 = 0.0;
        this.m_xOft2 = 0.0;
        this.m_scale = 0.0;
        this.m_width = 0.0;
        this.m_height = 0.0;
        this.m_cx = 0.0;
        this.m_cy = 0.0;
        this.m_geneTbl = null;
        this.m_df = new DecimalFormat();
        this.m_point = null;
        this.m_pos = Integer.MIN_VALUE;
        this.m_from = Integer.MIN_VALUE;
        this.m_to = Integer.MIN_VALUE;
        this.m_selMode = 1;
        this.m_keepAngle = 0.0;
        this.m_fColor = new Color(192, 192, 255);
        this.m_rColor = new Color(255, 192, 192);
        this.m_geneH = 0.0;
        this.m_rP = null;
        this.m_rM = null;
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setGroupingSeparator(',');
        this.m_df.setDecimalFormatSymbols(decimalFormatSymbols);
        this.m_df.setGroupingSize(3);
    }

    private double calcOuterDiameter(double d, double d2) {
        double d3 = (double)this.m_fm.stringWidth(this.m_df.format(this.m_length)) + 10.0;
        double d4 = -1.0;
        d4 = d < d2 ? d - d3 * 2.0 : d2 - d3 * 2.0;
        return d4;
    }

    void resizeGenomeMap(Dimension dimension) {
        if (this.m_image == null || dimension.width != this.m_image.getWidth() || dimension.height != this.m_image.getHeight()) {
            if (this.m_image != null) {
                this.m_image.flush();
                this.m_image = null;
            }
            this.m_image = new BufferedImage(dimension.width, dimension.height, 1);
            this.m_g = this.m_image.getGraphics();
            this.m_g.setFont(this.m_font);
        }
        this.m_width = dimension.width;
        this.m_height = dimension.height;
        this.m_cx = this.m_width / 2.0;
        this.m_cy = this.m_height / 2.0;
        if (this.m_circular) {
            this.m_diameter = this.calcOuterDiameter(this.m_width, this.m_height);
            this.m_geneH = this.m_diameter / 2.0 / 5.0 - 3.0;
            this.m_rP = new Rectangle2D.Double(this.m_cx - this.m_diameter / 2.0 + 3.0, this.m_cy - this.m_diameter / 2.0 + 3.0, this.m_diameter - 6.0, this.m_diameter - 6.0);
            this.m_rM = new Rectangle2D.Double(this.m_rP.x + this.m_geneH + 3.0, this.m_rP.y + this.m_geneH + 3.0, this.m_rP.width - (this.m_geneH + 3.0) * 2.0, this.m_rP.height - (this.m_geneH + 3.0) * 2.0);
        } else {
            this.m_xOft1 = (double)this.m_fm.stringWidth(this.m_df.format(this.m_length)) / 2.0 + 5.0;
            this.m_xOft2 = this.m_width - this.m_xOft1;
            this.m_scale = (this.m_xOft2 - this.m_xOft1) / (double)(this.m_length - 1);
        }
        this.draw();
        this.repaint();
    }

    void setChromosomeData(int n, Organism organism, boolean bl, int n2, ClusterTbl clusterTbl) throws Exception {
        this.m_id = n;
        this.organism = organism;
        this.m_circular = bl;
        this.m_length = n2;
        this.clusterTbl = clusterTbl;
        if (this.m_circular) {
            this.m_diameter = this.calcOuterDiameter(this.m_width, this.m_height);
            this.m_geneH = this.m_diameter / 2.0 / 5.0 - 3.0;
            this.m_rP = new Rectangle2D.Double(this.m_cx - this.m_diameter / 2.0 + 3.0, this.m_cy - this.m_diameter / 2.0 + 3.0, this.m_diameter - 6.0, this.m_diameter - 6.0);
            this.m_rM = new Rectangle2D.Double(this.m_rP.x + this.m_geneH + 3.0, this.m_rP.y + this.m_geneH + 3.0, this.m_rP.width - (this.m_geneH + 3.0) * 2.0, this.m_rP.height - (this.m_geneH + 3.0) * 2.0);
        } else {
            this.m_xOft1 = (double)this.m_fm.stringWidth(this.m_df.format(this.m_length)) / 2.0 + 5.0;
            this.m_xOft2 = this.m_width - this.m_xOft1;
            this.m_scale = (this.m_xOft2 - this.m_xOft1) / (double)(this.m_length - 1);
        }
        if (this.m_geneTbl != null) {
            this.m_geneTbl.clear();
            this.m_geneTbl = null;
        }
        this.m_geneTbl = new GeneTbl(this.organism);
        this.m_geneTbl.read();
        this.m_point = null;
        this.m_pos = Integer.MIN_VALUE;
        this.m_from = Integer.MIN_VALUE;
        this.m_to = Integer.MIN_VALUE;
        this.m_selMode = 1;
        this.m_keepAngle = 0.0;
        this.draw();
        this.repaint();
    }

    String getOrganismCode() {
        return this.organism.getOrganismCode();
    }

    void setRange(int n, int n2) {
        this.m_from = n;
        this.m_to = n2;
        this.repaint();
    }

    void setHighlightCluster(Collection collection) {
        this.clearHighlightLocustag();
        if (this.organism == null || !this.m_circular) {
            return;
        }
        for (Cluster cluster : collection) {
            if (cluster.getLocusTagList(this.organism.getOrganismCode()) == null) continue;
            this.highlightLocusTagSet.addAll(cluster.getLocusTagWithoutDomainList(this.organism.getOrganismCode()));
        }
        this.repaint();
    }

    void setHighlightLocusTag(String string, String string2) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string2);
        this.setHighlightLocusTag(string, hashSet);
    }

    void setHighlightLocusTag(String string, Collection collection) {
        this.clearHighlightLocustag();
        if (this.organism == null || !this.m_circular) {
            return;
        }
        if (!this.organism.equalsOrganismCode(string)) {
            return;
        }
        if (CollectionUtil.isNull(collection)) {
            return;
        }
        this.highlightLocusTagSet.addAll(collection);
        this.repaint();
    }

    int getId() {
        return this.m_id;
    }

    int getLength() {
        return this.m_length;
    }

    boolean isCircular() {
        return this.m_circular;
    }

    GeneTbl getGeneTbl() {
        return this.m_geneTbl;
    }

    private void draw() {
        this.draw(this.m_g, this.m_image.getWidth(), this.m_image.getHeight());
    }

    private void draw(Graphics graphics, int n, int n2) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, n, n2);
        if (this.organism == null) {
            return;
        }
        if (this.m_circular) {
            this.drawCircular(graphics);
        } else {
            this.drawLinear(graphics);
        }
    }

    private void drawCircular() {
        this.drawCircular(this.m_g);
    }

    private void drawCircular(Graphics graphics) {
        Color color;
        Cluster cluster;
        if (this.m_diameter / 2.0 / 5.0 < 4.0) {
            return;
        }
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        long l = System.currentTimeMillis();
        for (Gene gene : this.m_geneTbl.values()) {
            cluster = this.clusterTbl.getCluster(this.getOrganismCode(), gene.getLocusTag());
            color = this.genomeMapCondition.getColor(cluster, this.organism, gene, this.clusterTbl.isOutgroup());
            if (color == null) continue;
            graphics.setColor(color);
            if (!this.isPositiveGene(gene)) continue;
            if (this.isDomain(gene.getLocusTag())) {
                this.drawGeneLineForDomain(gene, this.m_rP, this.genomeMapCondition.isFunctionCategory());
                continue;
            }
            this.drawCircularFeature(graphics, this.m_rP, gene.getStart(), gene.getEnd());
        }
        graphics.setColor(Color.white);
        ((Graphics2D)graphics).fill(new Ellipse2D.Double(this.m_rP.x + this.m_geneH, this.m_rP.y + this.m_geneH, this.m_rP.width - this.m_geneH * 2.0, this.m_rP.height - this.m_geneH * 2.0));
        for (Gene gene : this.m_geneTbl.values()) {
            cluster = this.clusterTbl.getCluster(this.getOrganismCode(), gene.getLocusTag());
            color = this.genomeMapCondition.getColor(cluster, this.organism, gene, this.clusterTbl.isOutgroup());
            if (color == null) continue;
            graphics.setColor(color);
            if (!this.isNegativeGene(gene)) continue;
            if (this.isDomain(gene.getLocusTag())) {
                this.drawGeneLineForDomain(gene, this.m_rM, this.genomeMapCondition.isFunctionCategory());
                continue;
            }
            this.drawCircularFeature(graphics, this.m_rM, gene.getStart(), gene.getEnd());
        }
        long l2 = System.currentTimeMillis();
        graphics.setColor(Color.white);
        ((Graphics2D)graphics).fill(new Ellipse2D.Double(this.m_rM.x + this.m_geneH, this.m_rM.y + this.m_geneH, this.m_rM.width - this.m_geneH * 2.0, this.m_rM.height - this.m_geneH * 2.0));
        this.drawCircularLine((Graphics2D)graphics);
        this.drawCirculerScale((Graphics2D)graphics);
        this.drawOrganismName((Graphics2D)graphics);
    }

    private void drawCircularLine(Graphics2D graphics2D) {
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.setColor(Color.green.darker());
        double d = this.m_cx - this.m_diameter / 2.0;
        double d2 = this.m_cy - this.m_diameter / 2.0;
        double d3 = this.m_diameter;
        graphics2D.draw(new Ellipse2D.Double(d, d2, d3, d3));
        double d4 = d + this.m_geneH * 2.0 + 9.0;
        double d5 = d2 + this.m_geneH * 2.0 + 9.0;
        double d6 = this.m_diameter - this.m_geneH * 4.0 - 18.0;
        graphics2D.draw(new Ellipse2D.Double(d4, d5, d6, d6));
        graphics2D.setStroke(stroke);
    }

    private void drawCirculerScale(Graphics2D graphics2D) {
        graphics2D.setColor(Color.black);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        double d = this.m_cx;
        double d2 = (this.m_height - this.m_diameter) / 2.0;
        double d3 = d;
        double d4 = d2 - 10.0;
        int n = Commons.getInterval(this.m_length / 2);
        for (int i = 1; i <= this.m_length; i += n) {
            double d5 = i == 1 ? (double)i / (double)this.m_length : (double)(i - 1) / (double)this.m_length;
            double d6 = Math.PI * 2 * d5;
            double d7 = Math.sin(d6);
            double d8 = Math.cos(d6);
            double d9 = d8 * (d - this.m_cx) - d7 * (d2 - this.m_cy) + this.m_cx;
            double d10 = d7 * (d - this.m_cx) + d8 * (d2 - this.m_cy) + this.m_cy;
            double d11 = d8 * (d3 - this.m_cx) - d7 * (d4 - this.m_cy) + this.m_cx;
            double d12 = d7 * (d3 - this.m_cx) + d8 * (d4 - this.m_cy) + this.m_cy;
            graphics2D.draw(new Line2D.Double(d9, d10, d11, d12));
            String string = this.m_df.format(i == 1 ? (long)i : (long)(i - 1));
            if (d9 == d11) {
                if (d10 > d12) {
                    graphics2D.drawString(string, (int)(d9 - (double)(fontMetrics.stringWidth(string) / 2)), (int)d12);
                    continue;
                }
                graphics2D.drawString(string, (int)(d9 - (double)(fontMetrics.stringWidth(string) / 2)), (int)(d12 + (double)fontMetrics.getAscent()));
                continue;
            }
            if (d9 < d11) {
                graphics2D.drawString(string, (int)d11, (int)(d12 + (double)(fontMetrics.getAscent() / 2)));
                continue;
            }
            graphics2D.drawString(string, (int)(d11 - (double)fontMetrics.stringWidth(string)), (int)(d12 + (double)(fontMetrics.getAscent() / 2)));
        }
    }

    private void drawOrganismName(Graphics2D graphics2D) {
        String string = this.organism.getName();
        String string2 = this.organism.getStrain();
        String string3 = this.m_df.format(this.m_length) + "bp";
        double d = (double)this.m_fmNameI.getAscent() * 1.5;
        graphics2D.setColor(Color.black);
        graphics2D.setFont(this.m_fontNameI);
        graphics2D.drawString(string, (int)this.m_cx - this.m_fmName.stringWidth(string) / 2, (int)this.m_cy);
        graphics2D.setFont(this.m_fontName);
        d = (double)this.m_fmName.getAscent() * 1.5;
        graphics2D.drawString(string2, (int)this.m_cx - this.m_fmName.stringWidth(string2) / 2, (int)(this.m_cy + d));
        graphics2D.drawString(string3, (int)this.m_cx - this.m_fmName.stringWidth(string3) / 2, (int)(this.m_cy + d * 2.0));
        graphics2D.setFont(this.m_font);
    }

    private void drawGeneLineForDomain(Gene gene, Rectangle2D rectangle2D, boolean bl) {
        int n = 1;
        while (true) {
            String string = GeneUtil.combineLocusTagDomainNo(gene.getLocusTag(), n);
            Cluster cluster = this.clusterTbl.getCluster(this.getOrganismCode(), string);
            if (cluster == null) break;
            GeneInformation geneInformation = cluster.getGeneInformation(this.getOrganismCode(), string);
            if (bl) {
                String string2 = ClusterUtil.getFunctionCategoryNo(cluster, this.clusterTbl.isOutgroup());
                this.m_g.setColor(FunctionColorUtil.getFuncCatColor(string2));
            }
            this.drawCircularFeature(this.m_g, rectangle2D, geneInformation.getFrom(), geneInformation.getTo());
            ++n;
        }
    }

    private boolean isPositiveGene(Gene gene) {
        return gene.getStart() <= gene.getEnd() && gene.getRange() < this.m_length && gene.getChromId() == this.m_id && gene.isPositive();
    }

    private boolean isNegativeGene(Gene gene) {
        return gene.getStart() <= gene.getEnd() && gene.getRange() < this.m_length && gene.getChromId() == this.m_id && gene.isNegative();
    }

    private boolean isDomain(String string) {
        return this.clusterTbl.getCluster(this.getOrganismCode(), string) == null;
    }

    private void drawLinear() {
        this.drawLinear(this.m_g);
    }

    private void drawLinear(Graphics graphics) {
        int n;
        int n2;
        if (this.m_xOft2 - this.m_xOft1 <= 0.0) {
            return;
        }
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        String string = this.m_mediatorImpl.getOrganismName(this.getOrganismCode());
        int n3 = 0;
        graphics.setColor(Color.black);
        graphics.drawString(string, (int)this.m_cx - this.m_fm.stringWidth(string) / 2, n3 + this.m_fm.getAscent());
        int n4 = Commons.getInterval(this.m_length);
        graphics.drawLine((int)this.m_xOft1, (n3 += this.m_fm.getHeight()) + this.m_fm.getHeight() + 3, (int)this.m_xOft2, n3 + this.m_fm.getHeight() + 3);
        for (n2 = 1; n2 <= this.m_length; n2 += n4) {
            n = (int)((double)(n2 - 1) * this.m_scale + this.m_xOft1);
            graphics.drawLine(n, n3 + this.m_fm.getHeight(), n, n3 + this.m_fm.getHeight() + 3);
            String string2 = this.m_df.format(n2 == 1 ? 1L : (long)(n2 - 1));
            graphics.drawString(string2, n - this.m_fm.stringWidth(string2) / 2, n3 + this.m_fm.getAscent());
        }
        n2 = (int)this.m_xOft1;
        n = (int)((double)this.m_length * this.m_scale);
        int n5 = this.m_fm.getHeight() / 2 - 1;
        graphics.setColor(this.m_fColor);
        graphics.fillRect(n2, n3 += this.m_fm.getHeight() + 3 + 6, n, n5);
        graphics.setColor(this.m_rColor);
        graphics.fillRect(n2, n3 + this.m_fm.getHeight() - n5, n, n5);
        this.m_laneR = new Rectangle(n2, n3 - 3, n, this.m_fm.getHeight() + 6);
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    private void drawCircularFeature(Graphics graphics, Rectangle2D rectangle2D, int n, int n2) {
        double d = (double)n / (double)this.m_length * 2.0 * Math.PI / Math.PI * 180.0;
        double d2 = (double)n2 / (double)this.m_length * 2.0 * Math.PI / Math.PI * 180.0;
        double d3 = 360.0 - (d - 90.0);
        d3 = d3 > 360.0 ? d3 - 360.0 : d3;
        double d4 = d - d2;
        d4 = d4 < -360.0 ? 360.0 : d4;
        ((Graphics2D)graphics).fill(new Arc2D.Double(rectangle2D, d3, d4, 2));
    }

    private void drawRange(Graphics graphics) {
        if (this.m_selMode == 1 && this.m_pos != Integer.MIN_VALUE) {
            String string = this.m_df.format(this.m_pos);
            graphics.setColor(Color.red);
            graphics.drawString(string, this.m_point.x - this.m_fm.stringWidth(string) / 2, this.m_point.y);
        }
        if (this.m_from != Integer.MIN_VALUE && this.m_to != Integer.MIN_VALUE) {
            if (this.m_circular) {
                this.drawCircularRange(graphics);
            } else {
                this.drawLinearRange(graphics);
            }
        }
    }

    private void drawCircularRange(Graphics graphics) {
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Composite composite = ((Graphics2D)graphics).getComposite();
        ((Graphics2D)graphics).setComposite(AlphaComposite.getInstance(3, 0.25f));
        Rectangle2D.Double double_ = new Rectangle2D.Double(this.m_cx - this.m_diameter / 2.0 + 2.0, this.m_cy - this.m_diameter / 2.0 + 2.0, this.m_diameter - 4.0, this.m_diameter - 4.0);
        graphics.setColor(Color.blue);
        this.drawCircularFeature(graphics, double_, this.m_from, this.m_to);
        ((Graphics2D)graphics).setComposite(composite);
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.genomeMapFrame.setRange(this.m_from, this.m_to > this.m_length ? this.m_to - this.m_length : this.m_to);
    }

    private void drawLinearRange(Graphics graphics) {
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Composite composite = ((Graphics2D)graphics).getComposite();
        ((Graphics2D)graphics).setComposite(AlphaComposite.getInstance(3, 0.25f));
        int n = this.m_from < this.m_to ? this.m_from : this.m_to;
        int n2 = this.m_from > this.m_to ? this.m_from : this.m_to;
        double d = (double)(n - 1) * this.m_scale + this.m_xOft1;
        double d2 = (double)(n2 - n + 1) * this.m_scale;
        d2 = d2 < 1.0 ? 1.0 : d2;
        graphics.setColor(Color.blue);
        ((Graphics2D)graphics).fill(new Rectangle2D.Double(d, this.m_laneR.y, d2, this.m_laneR.height));
        ((Graphics2D)graphics).setComposite(composite);
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.genomeMapFrame.setRange(n, n2);
    }

    private void drawGene(Graphics graphics) {
        if (CollectionUtil.isNull(this.highlightLocusTagSet)) {
            return;
        }
        Iterator iterator = this.highlightLocusTagSet.iterator();
        while (iterator.hasNext()) {
            double d;
            String string = GeneUtil.removeDomainNo((String)iterator.next());
            Gene gene = (Gene)this.m_geneTbl.get(string);
            if (gene == null) continue;
            double d2 = gene.getStart();
            double d3 = gene.getEnd();
            double d4 = d3 - d2 + 1.0;
            double d5 = (double)this.m_length / 360.0;
            double d6 = this.m_cx;
            double d7 = gene.getDirection() == 1 ? this.m_rP.y : this.m_rM.y;
            double d8 = this.m_cx;
            double d9 = d = gene.getDirection() == 1 ? this.m_rP.y + this.m_geneH : this.m_rM.y + this.m_geneH;
            if (d4 < d5) {
                double d10 = (d5 - d4) / 2.0;
                d2 = (d2 -= d10) < 1.0 ? 1.0 : d2;
                d3 = d3 > (double)this.m_length ? (double)this.m_length : (d3 += d10);
            }
            d3 /= (double)this.m_length;
            Polygon polygon = new Polygon();
            double d11 = Math.PI * 2 * (d2 /= (double)this.m_length);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = d13 * (d6 - this.m_cx) - d12 * (d7 - this.m_cy) + this.m_cx;
            double d15 = d12 * (d6 - this.m_cx) + d13 * (d7 - this.m_cy) + this.m_cy;
            polygon.addPoint((int)d14, (int)d15);
            d11 = Math.PI * 2 * d3;
            d12 = Math.sin(d11);
            d13 = Math.cos(d11);
            d14 = d13 * (d6 - this.m_cx) - d12 * (d7 - this.m_cy) + this.m_cx;
            d15 = d12 * (d6 - this.m_cx) + d13 * (d7 - this.m_cy) + this.m_cy;
            polygon.addPoint((int)d14, (int)d15);
            d14 = d13 * (d8 - this.m_cx) - d12 * (d - this.m_cy) + this.m_cx;
            d15 = d12 * (d8 - this.m_cx) + d13 * (d - this.m_cy) + this.m_cy;
            polygon.addPoint((int)d14, (int)d15);
            d11 = Math.PI * 2 * d2;
            d12 = Math.sin(d11);
            d13 = Math.cos(d11);
            d14 = d13 * (d8 - this.m_cx) - d12 * (d - this.m_cy) + this.m_cx;
            d15 = d12 * (d8 - this.m_cx) + d13 * (d - this.m_cy) + this.m_cy;
            polygon.addPoint((int)d14, (int)d15);
            graphics.setColor(gene.getDirection() == 1 ? Color.blue : Color.red);
            graphics.fillPolygon(polygon);
            polygon = null;
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.m_image != null) {
            graphics.drawImage(this.m_image, 0, 0, null);
        }
        this.drawGene(graphics);
        this.drawRange(graphics);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.m_pos = Integer.MIN_VALUE;
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.organism == null) {
            return;
        }
        if (this.m_circular) {
            double d;
            if (this.m_diameter / 2.0 / 5.0 < 4.0) {
                this.repaint();
                return;
            }
            double d2 = (double)mouseEvent.getX() - this.m_width / 2.0;
            double d3 = Math.sqrt(d2 * d2 + (d = (double)mouseEvent.getY() - this.m_height / 2.0) * d);
            if (d3 > this.m_diameter / 2.0) {
                this.m_from = Integer.MIN_VALUE;
            } else {
                this.m_keepAngle = Math.atan(d / d2) / Math.PI * 180.0 + 90.0;
                this.m_keepAngle += mouseEvent.getX() < (int)this.m_cx ? 180.0 : 0.0;
                this.m_from = this.getCirclePosition(this.m_keepAngle, this.m_length);
            }
        } else {
            this.m_from = this.m_laneR.contains(mouseEvent.getX(), mouseEvent.getY()) ? (int)((double)(mouseEvent.getX() - this.m_laneR.x) / this.m_scale) + 1 : Integer.MIN_VALUE;
        }
        this.m_to = this.m_from;
        if (this.m_from != Integer.MIN_VALUE) {
            this.m_selMode = 2;
        }
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.m_selMode != 2) {
            return;
        }
        this.m_selMode = 1;
        this.genomeMapFrame.showRange();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n;
        if (this.m_selMode != 2) {
            return;
        }
        if (this.m_circular) {
            double d;
            double d2 = (double)mouseEvent.getX() - this.m_width / 2.0;
            double d3 = Math.sqrt(d2 * d2 + (d = (double)mouseEvent.getY() - this.m_height / 2.0) * d);
            if (d3 > this.m_diameter / 2.0) {
                n = Integer.MIN_VALUE;
            } else {
                double d4 = Math.atan(d / d2) / Math.PI * 180.0 + 90.0;
                if ((d4 += mouseEvent.getX() < (int)this.m_cx ? 180.0 : 0.0) < this.m_keepAngle) {
                    d4 += 360.0;
                }
                n = this.getCirclePosition(d4, this.m_length);
            }
        } else {
            n = this.m_laneR.contains(mouseEvent.getX(), mouseEvent.getY()) ? (int)((double)(mouseEvent.getX() - this.m_laneR.x) / this.m_scale) + 1 : (mouseEvent.getY() >= this.m_laneR.y && mouseEvent.getY() <= this.m_laneR.y + this.m_laneR.height - 1 ? (mouseEvent.getX() < this.m_laneR.x ? 1 : (mouseEvent.getX() > this.m_laneR.x + this.m_laneR.width - 1 ? this.m_length : (int)((double)(mouseEvent.getX() - this.m_laneR.x) / this.m_scale) + 1)) : Integer.MIN_VALUE);
        }
        if (n != Integer.MIN_VALUE) {
            this.m_to = n;
            this.repaint();
        }
    }

    private int getCirclePosition(double d, double d2) {
        return (int)(d / 360.0 * d2) + 1;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.organism == null) {
            return;
        }
        this.m_point = mouseEvent.getPoint();
        if (this.m_circular) {
            if (this.m_diameter / 2.0 / 5.0 < 4.0) {
                this.repaint();
                return;
            }
            double d = (double)this.m_point.x - this.m_width / 2.0;
            double d2 = (double)this.m_point.y - this.m_height / 2.0;
            double d3 = Math.sqrt(d * d + d2 * d2);
            if (d3 > this.m_diameter / 2.0) {
                this.m_pos = Integer.MIN_VALUE;
            } else {
                double d4 = Math.atan(d2 / d) / Math.PI * 180.0 + 90.0;
                this.m_pos = this.getCirclePosition(d4 += this.m_point.x < (int)this.m_cx ? 180.0 : 0.0, this.m_length);
            }
        } else {
            this.m_pos = this.m_laneR.contains(this.m_point.x, this.m_point.y) ? (int)((double)(this.m_point.x - this.m_laneR.x) / this.m_scale) + 1 : (this.m_point.y >= this.m_laneR.y && this.m_point.y <= this.m_laneR.y + this.m_laneR.height - 1 ? (this.m_point.x < this.m_laneR.x ? 1 : (this.m_point.x > this.m_laneR.x + this.m_laneR.width - 1 ? this.m_length : (int)((double)(this.m_point.x - this.m_laneR.x) / this.m_scale) + 1)) : Integer.MIN_VALUE);
        }
        this.repaint();
    }

    void updateGenomeMap() {
        this.draw();
        this.repaint();
    }

    void clearHighlightLocustag() {
        this.highlightLocusTagSet.clear();
    }

    public void print(PageFormat pageFormat) {
        AbstractPrintExecuter abstractPrintExecuter = new AbstractPrintExecuter(this, this.getWidth(), this.getHeight(), pageFormat){

            protected void draw(Graphics2D graphics2D, int n, int n2) {
                GenomeMap.this.draw(graphics2D, n, n2);
            }
        };
        abstractPrintExecuter.execute();
    }
}

