/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.gmap;

import cgdp.recog.color.ColorFacade;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterUtil;
import cgdp.recog.data.Gene;
import cgdp.recog.funccat.FunctionColorUtil;
import cgdp.recog.organism.Organism;
import cgdp.recog.project.Project;
import cgdp.recog.system.property.ApplicationProperty;
import cgdp.recog.system.property.ApplicationPropertyAccessable;
import cgdp.recog.util.ColorUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GenomeMapCondition
implements ApplicationPropertyAccessable {
    private static final Color DEFAULT_POSITIVE_COLOR = new Color(192, 192, 255);
    private static final Color DEFAULT_NEGATIVE_COLOR = new Color(255, 192, 192);
    static final int COLOR_FUNCCUT = 1;
    static final int COLOR_INOUT = 2;
    static final int COLOR_PPM = 3;
    private String domClustId;
    private int colorType = 1;
    private Color positiveColor = DEFAULT_POSITIVE_COLOR;
    private Color negativeColor = DEFAULT_NEGATIVE_COLOR;

    public String getDomClustId() {
        return this.domClustId;
    }

    public void setDomClustId(String string) {
        this.domClustId = string;
    }

    public int getColorType() {
        return this.colorType;
    }

    public void setColorType(int n) {
        this.colorType = n;
    }

    public boolean isFunctionCategory() {
        return this.getColorType() == 1;
    }

    public boolean isIngroupOutgroup() {
        return this.getColorType() == 2;
    }

    public boolean isPPM() {
        return this.getColorType() == 3;
    }

    public Color getFunctionCategoryColor(Cluster cluster, boolean bl) {
        String string = ClusterUtil.getFunctionCategoryNo(cluster, bl);
        Color color = FunctionColorUtil.getFuncCatColor(string);
        return color;
    }

    public Color getInOutColor(boolean bl) {
        Color color = null;
        color = bl ? this.getPositiveColor() : this.getNegativeColor();
        return color;
    }

    public Color getColor(Cluster cluster, Organism organism, Gene gene, boolean bl) {
        Color color = this.isFunctionCategory() ? this.getFunctionCategoryColor(cluster, bl) : (this.isIngroupOutgroup() ? this.getInOutColor(gene.isPositive()) : ColorFacade.getInstance().getPrimaryColor(cluster, organism, gene.getLocusTag()));
        return color;
    }

    public Color getPositiveColor() {
        return this.positiveColor;
    }

    public void setPositiveColor(Color color) {
        this.positiveColor = color;
    }

    public Color getNegativeColor() {
        return this.negativeColor;
    }

    public void setNegativeColor(Color color) {
        this.negativeColor = color;
    }

    public String getCategory() {
        return "GenomeMap";
    }

    public List getPropertyList(Project project, String string) {
        ArrayList<ApplicationProperty> arrayList = new ArrayList<ApplicationProperty>();
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "GenomeMapColorType", String.valueOf(this.getColorType())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "GenomeMapPositiveColor", ColorUtil.color2Str(this.getPositiveColor())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "GenomeMapNegativeColor", ColorUtil.color2Str(this.getNegativeColor())));
        return arrayList;
    }

    public int getPropertyType() {
        return 2;
    }

    public void updateProperty(Map map, Project project, String string) {
        if (map.containsKey("GenomeMapColorType")) {
            this.setColorType(Integer.parseInt((String)map.get("GenomeMapColorType")));
        }
        if (map.containsKey("GenomeMapPositiveColor")) {
            this.setPositiveColor(ColorUtil.str2Color((String)map.get("GenomeMapPositiveColor")));
        }
        if (map.containsKey("GenomeMapNegativeColor")) {
            this.setNegativeColor(ColorUtil.str2Color((String)map.get("GenomeMapNegativeColor")));
        }
    }
}

