/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info;

import cgdp.recog.info.AbstractInfoConfImporter;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.InfoTitleComparator;
import cgdp.recog.info.LocationType;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileExporter;
import cgdp.recog.util.StringTool;
import edu.emory.mathcs.backport.java.util.Collections;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractInfoManager {
    private static final ApplicationLogger logger = new ApplicationLogger(AbstractInfoManager.class);
    private Map infoTitleMap = new HashMap();
    private Set cachedInfoTitleSet = new HashSet();

    protected AbstractInfoManager() {
        this.updateInfoTitle();
    }

    public void clear() {
        this.cachedInfoTitleSet = new HashSet();
        this.infoTitleMap = new HashMap();
        this.updateInfoTitle();
    }

    private void updateInfoTitle() {
        this.infoTitleMap = this.createInfoTitleMap();
    }

    private Map createInfoTitleMap() {
        List list = this.getInfoTitleList(this.getConfFilepath());
        HashMap<String, AbstractInfoTitle> hashMap = new HashMap<String, AbstractInfoTitle>();
        for (AbstractInfoTitle abstractInfoTitle : list) {
            hashMap.put(abstractInfoTitle.getKey(), abstractInfoTitle);
        }
        return hashMap;
    }

    public List getInfoTitleList(String string) {
        try {
            AbstractInfoConfImporter abstractInfoConfImporter = this.createInfoTitleImporter(string);
            abstractInfoConfImporter.execute();
            List list = abstractInfoConfImporter.getInfoTitleList();
            return list;
        }
        catch (IOException iOException) {
            logger.warn("Fail to load gene_info.", iOException);
            return new ArrayList();
        }
    }

    public void exportTitleList(List list) throws IOException {
        FileExporter fileExporter = this.createInfoTitleExporter(list);
        fileExporter.execute();
        this.updateInfoTitle();
    }

    public Map getInfoTitleMap() {
        return this.infoTitleMap;
    }

    public List getInfoTitleList() {
        return this.getInfoTitleList(this.getConfFilepath());
    }

    public AbstractInfoTitle getInfoTitle(String string) {
        return (AbstractInfoTitle)this.infoTitleMap.get(string);
    }

    public List getInfoTitleListByAnalysisKey(String string, String string2) {
        ArrayList<AbstractInfoTitle> arrayList = new ArrayList<AbstractInfoTitle>();
        for (AbstractInfoTitle abstractInfoTitle : this.getInfoTitleMap().values()) {
            if (!abstractInfoTitle.isUseAnalysis(string) || !StringTool.isNull(string2) && !abstractInfoTitle.containsDomClustId(string2) || abstractInfoTitle.isCacheNeed() && LocationType.isNameSystem(abstractInfoTitle.getLocationName()) && !this.isCachedInfoTitle(abstractInfoTitle)) continue;
            arrayList.add(abstractInfoTitle);
        }
        Collections.sort(arrayList, new InfoTitleComparator(2));
        return arrayList;
    }

    protected abstract String getConfFilepath();

    protected abstract AbstractInfoConfImporter createInfoTitleImporter(String var1);

    protected abstract FileExporter createInfoTitleExporter(List var1);

    public Set getCachedInfoTitleSet() {
        return this.cachedInfoTitleSet;
    }

    protected void addCachedInfoTitle(AbstractInfoTitle abstractInfoTitle) {
        this.cachedInfoTitleSet.add(abstractInfoTitle);
    }

    protected void addCachedInfoTitle(Collection collection) {
        this.cachedInfoTitleSet.addAll(collection);
    }

    public abstract void removeCachedInfo(Collection var1);

    protected void removeCachedInfoTitle(Collection collection) {
        this.cachedInfoTitleSet.removeAll(collection);
    }

    public boolean isCachedInfoTitle(AbstractInfoTitle abstractInfoTitle) {
        return this.getCachedInfoTitleSet().contains(abstractInfoTitle);
    }
}

