/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info;

import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.InfoFacade;
import cgdp.recog.info.InfoType;
import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.FocusTextField;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.StringTool;
import cgdp.recog.util.TabPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class InfoEditPanel
extends TabPanel
implements ItemListener {
    private FocusTextField nameTextField;
    private JComboBox typeComboBox;
    private FocusTextField enumEleTextField;
    private JCheckBox multiCheckBox;
    private JComboBox locationComboBox;
    private AbstractInfoTitle infoTitle;

    public InfoEditPanel(Component component) {
        super(component);
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel("Name");
        this.nameTextField = new FocusTextField(20);
        JLabel jLabel2 = new JLabel("Type");
        this.typeComboBox = new JComboBox<String>(InfoType.TYPE_NAMES);
        this.typeComboBox.addItemListener(this);
        JLabel jLabel3 = new JLabel("Enum elements");
        this.enumEleTextField = new FocusTextField(20);
        this.multiCheckBox = new JCheckBox("Multi value");
        JLabel jLabel4 = new JLabel("Location");
        this.locationComboBox = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 10, 5, 0), 0, 0));
        this.add((Component)this.nameTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(15, 5, 5, 10), 0, 0));
        this.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 0), 0, 0));
        this.add((Component)this.typeComboBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 10), 0, 0));
        this.add((Component)jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 0), 0, 0));
        this.add((Component)this.enumEleTextField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 10), 0, 0));
        this.add((Component)this.multiCheckBox, new GridBagConstraints(0, 3, 2, 1, 0.0, 1.0, 18, 0, new Insets(5, 10, 5, 0), 0, 0));
    }

    public void updateValue(AbstractInfoTitle abstractInfoTitle) {
        this.infoTitle = abstractInfoTitle;
        this.setEnabledComponents(true);
        this.nameTextField.setText(abstractInfoTitle.getName());
        this.typeComboBox.setSelectedItem(abstractInfoTitle.getTypeName());
        if (InfoType.isEnum(abstractInfoTitle.getType())) {
            this.enumEleTextField.setText(StringTool.conbineStrList(abstractInfoTitle.getElementList(), ","));
        } else {
            this.enumEleTextField.setText("");
        }
        this.updateLocationComboBox();
        this.multiCheckBox.setSelected(abstractInfoTitle.isMulti());
        this.locationComboBox.setSelectedItem(abstractInfoTitle.getLocationName());
        this.setEnabledComponents(abstractInfoTitle.isEditable());
    }

    private void updateLocationComboBox() {
        this.locationComboBox.removeAllItems();
        String[] stringArray = this.createLocationItems();
        for (int i = 0; i < stringArray.length; ++i) {
            this.locationComboBox.addItem(stringArray[i]);
        }
    }

    private String[] createLocationItems() {
        List list = ProjectAccesser.loadProject();
        String[] stringArray = new String[list.size() + 1];
        stringArray[0] = "Global";
        for (int i = 1; i <= list.size(); ++i) {
            Project project = (Project)list.get(i - 1);
            stringArray[i] = project.getProjectName();
            if (!project.isSelect()) continue;
            int n = i;
            stringArray[n] = stringArray[n] + "(Selected)";
        }
        return stringArray;
    }

    private AbstractInfoTitle getInfoTitle() {
        return this.infoTitle;
    }

    protected void changeDefault() {
    }

    public boolean check() {
        String string = this.getInfoTitleName();
        if (StringTool.isNull(string)) {
            MessageManager.showErrorMessage((Component)this, "Input name.");
            return false;
        }
        if (this.containsName(string)) {
            MessageManager.showErrorMessage((Component)this, "The name is duplicated other properties.");
            return false;
        }
        if (InfoType.isEnum(this.getType()) && CollectionUtil.isNull(this.getEnumEleList())) {
            MessageManager.showErrorMessage((Component)this, "Input enum elements.");
            return false;
        }
        Object object = this.validateInfoValue();
        if (object != null) {
            String string2 = "Illegal value is existed. " + this.getInfoTitle().getName() + " : " + object;
            MessageManager.showErrorMessage((Component)this, string2);
            return false;
        }
        return true;
    }

    private Object validateInfoValue() {
        if (this.getInfoTitle().getType() == this.getType() && this.getInfoTitle().isMulti() == this.isMulti()) {
            return null;
        }
        if (InfoType.isCharactor(this.getType())) {
            return null;
        }
        AbstractInfoTitle abstractInfoTitle = this.createInfoTitle();
        if (this.getInfoTitle().isGene()) {
            return GeneInfoFacade.validateInfoValue(this.getInfoTitle(), abstractInfoTitle);
        }
        if (this.getInfoTitle().isCluster()) {
            return ClusterInfoFacade.validateInfoValue(this.getInfoTitle(), abstractInfoTitle);
        }
        if (this.getInfoTitle().isCell()) {
            // empty if block
        }
        return null;
    }

    private AbstractInfoTitle createInfoTitle() {
        AbstractInfoTitle abstractInfoTitle = (AbstractInfoTitle)this.getInfoTitle().clone();
        this.setParameter(abstractInfoTitle);
        return abstractInfoTitle;
    }

    private boolean containsName(String string) {
        List list = InfoFacade.getInfoTitleList(this.infoTitle.getCls());
        for (AbstractInfoTitle abstractInfoTitle : list) {
            if (this.infoTitle != null && this.infoTitle.equals(abstractInfoTitle) || !abstractInfoTitle.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    protected void updateParameters() {
    }

    public String getInfoTitleName() {
        return this.nameTextField.getText();
    }

    public int getType() {
        return InfoType.getTypeIndex((String)this.typeComboBox.getSelectedItem());
    }

    public List getEnumEleList() {
        if (StringTool.isNull(this.enumEleTextField.getText())) {
            return new ArrayList();
        }
        return StringTool.splitString(this.enumEleTextField.getText(), ",");
    }

    public boolean isMulti() {
        return this.multiCheckBox.isSelected();
    }

    private void setEnabledComponents(boolean bl) {
        this.nameTextField.setEnabled(bl);
        this.typeComboBox.setEnabled(bl);
        this.enumEleTextField.setEnabled(bl);
        this.multiCheckBox.setEnabled(bl);
    }

    private void setEnabledEnumEleTextField() {
        int n = this.getType();
        this.enumEleTextField.setEnabled(InfoType.isEnum(n));
    }

    public void setParameter(AbstractInfoTitle abstractInfoTitle) {
        abstractInfoTitle.setName(this.getInfoTitleName());
        abstractInfoTitle.setType(this.getType());
        abstractInfoTitle.setElementList(this.getEnumEleList());
        abstractInfoTitle.setMulti(this.isMulti());
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.typeComboBox) {
            this.setEnabledEnumEleTextField();
        }
    }
}

