/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info;

import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.AnalysisUseType;
import cgdp.recog.util.FileImporter;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public abstract class InfoImporter
extends FileImporter {
    private static final String PREFIX_PARAMETER = "#";
    private static final String PREFIX_COMMENT = "##";
    protected static final String DELIMITER = "\t";
    private String filepath;
    protected List infoTitleList = new ArrayList();
    private Map titleConvertMap = new HashMap();

    protected InfoImporter(String string) {
        this.filepath = string;
        this.initTitleConvertMap(this.titleConvertMap);
    }

    protected abstract void initTitleConvertMap(Map var1);

    public void addConvertTitle(String string, AbstractInfoTitle abstractInfoTitle) {
        this.titleConvertMap.put(string.toLowerCase(), abstractInfoTitle);
    }

    protected String getFilepath() {
        return this.filepath;
    }

    protected void parseDataLine(int n, String string) {
        if (string.startsWith(PREFIX_COMMENT)) {
            return;
        }
        if (string.startsWith(PREFIX_PARAMETER)) {
            return;
        }
        this.parseDataLineCore(n, string);
    }

    protected abstract void parseDataLineCore(int var1, String var2);

    protected void parseHeaderLine(String string) {
        Vector vector = StringTool.splitString(string, DELIMITER);
        for (String string2 : vector) {
            if (!AbstractInfoTitle.validateColumnName(string2)) {
                this.setError(true);
                this.setErrorMessage("The column name is not correct. " + string2);
                return;
            }
            AbstractInfoTitle abstractInfoTitle = this.createInfoTitle(string2);
            AbstractInfoTitle abstractInfoTitle2 = (AbstractInfoTitle)this.titleConvertMap.get(abstractInfoTitle.getName().toLowerCase());
            if (abstractInfoTitle2 != null) {
                abstractInfoTitle = abstractInfoTitle2;
            }
            if (abstractInfoTitle.isEditable()) {
                AnalysisUseType.setUserAnalysisFlag(abstractInfoTitle);
            }
            this.infoTitleList.add(abstractInfoTitle);
        }
    }

    protected abstract AbstractInfoTitle createInfoTitle(String var1);

    public List getInfoTitleList() {
        return this.infoTitleList;
    }
}

