/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.info.InfoClass;
import cgdp.recog.info.InfoEditDialog;
import cgdp.recog.info.cell.CellInfoTabPanel;
import cgdp.recog.info.cluster.ClusterInfoTabPanel;
import cgdp.recog.info.gene.GeneInfoTabPanel;
import cgdp.recog.util.TabDialog;
import java.awt.Dimension;
import java.awt.Frame;

public class InfoListDialog
extends TabDialog {
    private static final Dimension DIALOG_SIZE = new Dimension(600, 300);
    private static final String TITLE = "Gene/Cell/Cluster property";
    private static InfoEditDialog INFO_EDIT_DIALOG;
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;
    private GeneInfoTabPanel geneInfoTabPanel;
    private CellInfoTabPanel cellInfoTabPanel;
    private ClusterInfoTabPanel clusterInfoTabPanel;

    public InfoListDialog(Frame frame, MediatorImpl mediatorImpl) {
        super(frame);
        this.mediator = mediatorImpl;
        INFO_EDIT_DIALOG = new InfoEditDialog(this);
        this.createComponents();
    }

    public static InfoEditDialog getInfoEditDialog() {
        return INFO_EDIT_DIALOG;
    }

    protected void createComponents() {
        super.createComponents();
        this.setTitle(TITLE);
        this.setSize(DIALOG_SIZE);
        this.setLocationRelativeTo(this.getParent());
    }

    protected void addTabPanel() {
        this.geneInfoTabPanel = new GeneInfoTabPanel(this, this.mediator);
        this.cellInfoTabPanel = new CellInfoTabPanel(this, this.mediator);
        this.clusterInfoTabPanel = new ClusterInfoTabPanel(this, this.mediator);
        this.tabbedPane.add("Gene", this.geneInfoTabPanel);
        this.tabbedPane.add("Cell", this.cellInfoTabPanel);
        this.tabbedPane.add("Cluster", this.clusterInfoTabPanel);
    }

    public void updateValue(int n, ClusterTbl clusterTbl) {
        this.clusterTbl = clusterTbl;
        this.geneInfoTabPanel.updateValue(clusterTbl);
        this.cellInfoTabPanel.updateValue(clusterTbl);
        this.clusterInfoTabPanel.updateValue(clusterTbl);
        if (InfoClass.isGene(n)) {
            this.tabbedPane.setSelectedIndex(0);
        } else if (InfoClass.isCell(n)) {
            this.tabbedPane.setSelectedIndex(1);
        } else {
            this.tabbedPane.setSelectedIndex(2);
        }
    }
}

