/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.cluster;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.info.AbstractInfoTabPanel;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.InfoDeleteRequestExecuter;
import cgdp.recog.info.InfoEditDialog;
import cgdp.recog.info.InfoListDialog;
import cgdp.recog.info.InfoTitleTableCellRenderer;
import cgdp.recog.info.InfoUtil;
import cgdp.recog.info.LocationType;
import cgdp.recog.info.cluster.ClusterInfoDeleteRequestExecuter;
import cgdp.recog.info.cluster.ClusterInfoDownloadExecuter;
import cgdp.recog.info.cluster.ClusterInfoEditExecuter;
import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.info.cluster.ClusterInfoTitle;
import cgdp.recog.info.cluster.ClusterInfoTitleTableModel;
import cgdp.recog.info.cluster.ClusterInfoUploadExecuter;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.DummyProgressComponent;
import cgdp.recog.process.ProcessImpl;
import cgdp.recog.process.ProgressDialog;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.server.UploadDialog;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ClusterInfoTabPanel
extends AbstractInfoTabPanel
implements MouseListener {
    private static final ApplicationLogger logger = new ApplicationLogger(ClusterInfoTabPanel.class);
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;
    private JTable infoTable;

    public ClusterInfoTabPanel(Dialog dialog, MediatorImpl mediatorImpl) {
        super(dialog);
        this.mediator = mediatorImpl;
        this.createComponents();
    }

    private void createComponents() {
        Serializable serializable;
        this.infoTable = new JTable(new ClusterInfoTitleTableModel());
        this.infoTable.addMouseListener(this);
        TableColumnModel tableColumnModel = this.infoTable.getColumnModel();
        for (int i = 0; i < this.infoTable.getColumnCount(); ++i) {
            serializable = tableColumnModel.getColumn(i);
            serializable.setCellRenderer(new InfoTitleTableCellRenderer());
        }
        TableColumn tableColumn = tableColumnModel.getColumn(2);
        tableColumn.setMaxWidth(50);
        tableColumn.setMinWidth(50);
        this.infoTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ClusterInfoTabPanel.this.setEnabledButton();
            }
        });
        serializable = new JScrollPane(this.infoTable, 20, 30);
        this.setShowAddButton(false);
        this.setLayout(new GridBagLayout());
        this.add((Component)serializable, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.getControlButtonPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.setEnabledButton();
    }

    public void updateValue(ClusterTbl clusterTbl) {
        this.clusterTbl = clusterTbl;
        List list = this.getClusterInfoTitleList();
        ClusterInfoTitleTableModel clusterInfoTitleTableModel = this.getClusterInfoTitleTableModel();
        clusterInfoTitleTableModel.setClusterInfoTitleList(list);
        this.setEnabledButton();
    }

    private List getClusterInfoTitleList() {
        List list = ClusterInfoFacade.getInfoTitleList();
        Project project = ProjectAccesser.getSelectedProject();
        if (project.isServer() && this.clusterTbl != null) {
            try {
                List list2 = ClusterInfoFacade.downloadClusterInfoTitleList(this.clusterTbl.getClusterId(), project);
                list.addAll(list2);
            }
            catch (Exception exception) {
                String string = "Fail to load cluster information from server.";
                logger.warn(string, exception);
                MessageManager.showErrorMessage(this.parent, string);
            }
        }
        return list;
    }

    protected void setEnabledButton(int n) {
        super.setEnabledButton(n);
        if (this.clusterTbl == null || n == -1) {
            this.downloadButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.editButton.setEnabled(false);
            this.uploadButton.setEnabled(false);
        } else {
            this.deleteButton.setEnabled(this.enableDelete());
            ClusterInfoTitleTableModel clusterInfoTitleTableModel = this.getClusterInfoTitleTableModel();
            AbstractInfoTitle abstractInfoTitle = clusterInfoTitleTableModel.getInfoTitle(n);
            if (LocationType.isNameServer(abstractInfoTitle.getLocationName())) {
                this.downloadButton.setEnabled(true);
                this.editButton.setEnabled(true);
                this.uploadButton.setEnabled(false);
            } else {
                this.downloadButton.setEnabled(false);
                this.editButton.setEnabled(true);
                if (abstractInfoTitle.isEditable() && abstractInfoTitle.containsDomClustId(this.clusterTbl.getClusterId())) {
                    this.uploadButton.setEnabled(true);
                } else {
                    this.uploadButton.setEnabled(false);
                }
            }
        }
    }

    private List getSelectedClusterInfoTitleList() {
        ArrayList<AbstractInfoTitle> arrayList = new ArrayList<AbstractInfoTitle>();
        int[] nArray = this.infoTable.getSelectedRows();
        if (nArray == null || nArray.length == 0) {
            return arrayList;
        }
        ClusterInfoTitleTableModel clusterInfoTitleTableModel = this.getClusterInfoTitleTableModel();
        for (int i = 0; i < nArray.length; ++i) {
            AbstractInfoTitle abstractInfoTitle = clusterInfoTitleTableModel.getInfoTitle(nArray[i]);
            arrayList.add(abstractInfoTitle);
        }
        return arrayList;
    }

    private List getSelectedServerClusterInfoTitleList() {
        List list = this.getSelectedClusterInfoTitleList();
        return InfoUtil.getServerInfoTitleList(list);
    }

    private ClusterInfoTitleTableModel getClusterInfoTitleTableModel() {
        ClusterInfoTitleTableModel clusterInfoTitleTableModel = (ClusterInfoTitleTableModel)this.infoTable.getModel();
        return clusterInfoTitleTableModel;
    }

    private void setEnabledButton() {
        int n = this.infoTable.getSelectedRow();
        this.setEnabledButton(n);
    }

    protected void add() {
    }

    private boolean enableDelete() {
        List list = this.getSelectedClusterInfoTitleList();
        if (CollectionUtil.isNull(list)) {
            return false;
        }
        List list2 = InfoUtil.getServerInfoTitleList(list);
        return CollectionUtil.isNull(list2) || list2.size() == list.size();
    }

    protected void delete() {
        if (!this.enableDelete()) {
            return;
        }
        List list = this.getSelectedClusterInfoTitleList();
        List list2 = InfoUtil.getServerInfoTitleList(list);
        List list3 = InfoUtil.getLocalInfoTitleList(list);
        if (list.size() == list2.size()) {
            Object[] objectArray = new String[]{"Delete the following properties?", InfoUtil.createInfoTitleNameString(list2)};
            if (!MessageManager.showConfirmMessage((Component)this, objectArray)) {
                return;
            }
            ClusterInfoDeleteRequestExecuter clusterInfoDeleteRequestExecuter = new ClusterInfoDeleteRequestExecuter(this, list2, this.clusterTbl.getClusterId());
            clusterInfoDeleteRequestExecuter.setAfterRunnable(new InfoDeleteRequestExecuter.InfoDeleteAfterRunnable(){

                public void run() {
                    ClusterInfoTabPanel.this.updateValue(ClusterInfoTabPanel.this.clusterTbl);
                }
            });
            new ProgressDialog((Dialog)this.parent, this.mediator, 1, "Delete cluster property...", false, (ProcessImpl)clusterInfoDeleteRequestExecuter);
        } else if (list.size() == list3.size()) {
            int[] nArray = this.infoTable.getSelectedRows();
            ClusterInfoTitleTableModel clusterInfoTitleTableModel = this.getClusterInfoTitleTableModel();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < nArray.length; ++i) {
                AbstractInfoTitle abstractInfoTitle = clusterInfoTitleTableModel.getInfoTitle(nArray[i]);
                stringBuffer.append(abstractInfoTitle.getName());
                if (i == nArray.length - 1) continue;
                stringBuffer.append(",");
            }
            Object[] objectArray = new String[]{"Delete the following cluster propeties?", stringBuffer.toString()};
            if (!MessageManager.showConfirmMessage((Component)this, objectArray)) {
                return;
            }
            for (int i = 0; i < nArray.length; ++i) {
                AbstractInfoTitle abstractInfoTitle = clusterInfoTitleTableModel.getInfoTitle(nArray[i]);
                this.addDeleteInfoTitle(abstractInfoTitle);
            }
            clusterInfoTitleTableModel.remove(nArray);
        }
    }

    protected void edit() {
        int n = this.infoTable.getSelectedRow();
        if (n == -1) {
            return;
        }
        ClusterInfoTitleTableModel clusterInfoTitleTableModel = this.getClusterInfoTitleTableModel();
        AbstractInfoTitle abstractInfoTitle = clusterInfoTitleTableModel.getInfoTitle(n);
        List list = clusterInfoTitleTableModel.getClusterInfoTitleList();
        InfoEditDialog infoEditDialog = InfoListDialog.getInfoEditDialog();
        infoEditDialog.updateValue(abstractInfoTitle, list, this);
        infoEditDialog.setVisible(true);
    }

    protected void download() {
        Object object;
        Cloneable cloneable2;
        List list = this.getSelectedServerClusterInfoTitleList();
        Object[] objectArray = new String[]{"Download the following cluster properties?", InfoUtil.createInfoTitleNameString(list)};
        if (!MessageManager.showConfirmMessage((Component)this, objectArray)) {
            return;
        }
        Project project = ProjectAccesser.getSelectedProject();
        ArrayList<ClusterInfoTitle> arrayList = new ArrayList<ClusterInfoTitle>();
        for (Cloneable cloneable2 : list) {
            object = (ClusterInfoTitle)cloneable2.clone();
            ((AbstractInfoTitle)object).setLocationName(project.getProjectName());
            ((AbstractInfoTitle)object).setEditable(true);
            arrayList.add((ClusterInfoTitle)object);
        }
        List list2 = ClusterInfoFacade.getInfoTitleList();
        if (!ClusterInfoFacade.validateInfoTitle(this, arrayList, list2, (Set)((Object)(cloneable2 = new HashSet(ClusterInfoTitle.getSystemClusterInfoTitleKeyList()))))) {
            return;
        }
        object = new ClusterInfoDownloadExecuter(this, arrayList, this.clusterTbl.getClusterId(), project);
        ((AbstractThreadProcess)object).setAfterRunnable(new Runnable(){

            public void run() {
                ClusterInfoTabPanel.this.updateValue(ClusterInfoTabPanel.this.clusterTbl);
            }
        });
        new ProgressDialog((Dialog)this.parent, this.mediator, 1, "Download cluster property...", false, (ProcessImpl)object);
    }

    protected void upload() {
        List list = this.getSelectedClusterInfoTitleList();
        if (CollectionUtil.isNull(list)) {
            return;
        }
        List list2 = InfoUtil.getInfoTitleNameList(list);
        UploadDialog uploadDialog = UploadDialog.createInstance(this.parent);
        uploadDialog.updateValue("cluster property", list2);
        uploadDialog.setVisible(true);
        if (uploadDialog.isCanceled()) {
            return;
        }
        ClusterInfoUploadExecuter clusterInfoUploadExecuter = new ClusterInfoUploadExecuter(this, list, this.clusterTbl);
        clusterInfoUploadExecuter.setAfterRunnable(new Runnable(){

            public void run() {
                ClusterInfoTabPanel.this.updateValue(ClusterInfoTabPanel.this.clusterTbl);
            }
        });
        new ProgressDialog((Dialog)this.parent, this.mediator, 1, "Upload cluster property...", false, (ProcessImpl)clusterInfoUploadExecuter);
    }

    public boolean check() {
        return true;
    }

    protected void updateParameters() {
        if (CollectionUtil.isNull(this.newInfoTitleSet) && CollectionUtil.isNull(this.editInfoTitleSet) && CollectionUtil.isNull(this.deleteInfoTitleSet)) {
            return;
        }
        List list = this.getClusterInfoTitleTableModel().getClusterInfoTitleList();
        List list2 = InfoUtil.getLocalInfoTitleList(list);
        ClusterInfoEditExecuter clusterInfoEditExecuter = new ClusterInfoEditExecuter(this, this.mediator, list2, this.newInfoTitleSet, this.editInfoTitleSet, this.deleteInfoTitleSet);
        clusterInfoEditExecuter.execute(new DummyProgressComponent());
        clusterInfoEditExecuter.done();
    }

    public void updateTable(AbstractInfoTitle abstractInfoTitle) {
        int n = this.getClusterInfoTitleTableModel().indexOf(abstractInfoTitle);
        if (n == -1) {
            return;
        }
        this.getClusterInfoTitleTableModel().fireTableRowsUpdated(n, n);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.editButton.doClick();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

