/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.cluster;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.info.AbstractServerInfoListDialog;
import cgdp.recog.info.InfoDeleteRequestExecuter;
import cgdp.recog.info.InfoUtil;
import cgdp.recog.info.cluster.ClusterInfoDeleteRequestExecuter;
import cgdp.recog.info.cluster.ClusterInfoDownloadExecuter;
import cgdp.recog.info.cluster.ClusterInfoTitle;
import cgdp.recog.process.ProcessImpl;
import cgdp.recog.process.ProgressDialog;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.HashSet;
import java.util.List;

public class ServerClusterListDialog
extends AbstractServerInfoListDialog {
    private static final String TITLE = "Cluster Property List";
    private ClusterTbl clusterTbl;

    private ServerClusterListDialog(Dialog dialog, MediatorImpl mediatorImpl) {
        super(dialog, mediatorImpl);
    }

    private ServerClusterListDialog(Frame frame, MediatorImpl mediatorImpl) {
        super(frame, mediatorImpl);
    }

    public static ServerClusterListDialog createInstance(Component component, MediatorImpl mediatorImpl) {
        ServerClusterListDialog serverClusterListDialog = null;
        if (component instanceof Dialog) {
            serverClusterListDialog = new ServerClusterListDialog((Dialog)component, mediatorImpl);
        } else if (component instanceof Frame) {
            serverClusterListDialog = new ServerClusterListDialog((Frame)component, mediatorImpl);
        }
        return serverClusterListDialog;
    }

    public void updateValue(List list, ClusterTbl clusterTbl) {
        super.updateValue(list);
        this.clusterTbl = clusterTbl;
    }

    protected String getFrameTitle() {
        return TITLE;
    }

    protected void delete() {
        final List list = this.getSelectedInfoTitleList();
        Object[] objectArray = new String[]{"Delete the following properties?", InfoUtil.createInfoTitleNameString(list)};
        if (!MessageManager.showConfirmMessage((Component)this, objectArray)) {
            return;
        }
        ClusterInfoDeleteRequestExecuter clusterInfoDeleteRequestExecuter = new ClusterInfoDeleteRequestExecuter(this, list, this.clusterTbl.getClusterId());
        clusterInfoDeleteRequestExecuter.setAfterRunnable(new InfoDeleteRequestExecuter.InfoDeleteAfterRunnable(){

            public void run() {
                HashSet hashSet = new HashSet(list);
                hashSet.removeAll(this.getUnableDeleteTitleC());
                ServerClusterListDialog.this.getInfoTitleListTableModel().removeAll(hashSet);
            }
        });
        new ProgressDialog((Dialog)this, this.mediator, 1, "Delete cluster property...", false, (ProcessImpl)clusterInfoDeleteRequestExecuter);
    }

    protected boolean apply() {
        List list = this.getSelectedInfoTitleList();
        Object[] objectArray = new String[]{"Download the following cluster properties?", InfoUtil.createInfoTitleNameString(list)};
        if (!MessageManager.showConfirmMessage((Component)this, objectArray)) {
            return false;
        }
        Project project = ProjectAccesser.getSelectedProject();
        for (ClusterInfoTitle clusterInfoTitle : list) {
            clusterInfoTitle.setLocationName(project.getProjectName());
        }
        ClusterInfoDownloadExecuter clusterInfoDownloadExecuter = new ClusterInfoDownloadExecuter(this, list, this.clusterTbl.getClusterId(), project);
        new ProgressDialog((Dialog)this, this.mediator, 1, "Download cluster property...", false, (ProcessImpl)clusterInfoDownloadExecuter);
        return false;
    }
}

