/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.gene;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.info.gene.GeneList;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionValues;
import cgdp.recog.util.ApplicationFrame;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class GeneFrame
extends ApplicationFrame
implements ActionListener {
    private static final String TITLE = "Gene List";
    private JFrame parent;
    private MediatorImpl mediator;
    private GeneList geneListPanel;
    private JButton exportButton;

    public GeneFrame(JFrame jFrame, MediatorImpl mediatorImpl) {
        super(TITLE);
        this.mediator = mediatorImpl;
        this.parent = jFrame;
        this.mediator.register(this);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GeneFrame.this.mediator.closeGeneFrame();
            }
        });
        this.createComponent();
    }

    private void createComponent() {
        this.geneListPanel = new GeneList(this.mediator);
        this.getContentPane().add((Component)this.geneListPanel, "Center");
        this.exportButton = new JButton("Export...");
        this.exportButton.addActionListener(this);
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(this.exportButton);
        this.getContentPane().add((Component)jPanel, "South");
        this.pack();
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        if (optionValues.getGeneFrameW() != 0 && optionValues.getGeneFrameH() != 0) {
            this.setBounds(optionValues.getGeneFrameX(), optionValues.getGeneFrameY(), optionValues.getGeneFrameW(), optionValues.getGeneFrameH());
        } else {
            this.setLocationRelativeTo(this.parent);
        }
    }

    public void createGeneList(String string, List list, List list2) throws Exception {
        this.geneListPanel.createGeneList(string, list, list2);
    }

    public boolean isShowTable() {
        return this.geneListPanel.isShowTable();
    }

    public void saveGeneList(File file) throws Exception {
        this.geneListPanel.saveGeneList(file);
    }

    public void clearTable() {
        this.geneListPanel.clearTable();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.exportButton) {
            this.mediator.saveGeneList();
        }
    }
}

