/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.gene;

import cgdp.recog.bean.Const;
import cgdp.recog.info.AbstractInfoConfExporter;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.List;

public class GeneInfoConfExporter
extends AbstractInfoConfExporter {
    public GeneInfoConfExporter(List list) {
        this(list, Const.USER_GENE_INFO_PATH);
    }

    GeneInfoConfExporter(List list, String string) {
        super(list, string);
    }

    protected String getContents() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(StringTool.conbineStrList(this.getHeaderNameList(), "\t"));
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        for (GeneInfoTitle geneInfoTitle : this.infoTitleList) {
            stringBuffer.append(this.createLine(geneInfoTitle));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        return stringBuffer.toString();
    }

    private String createLine(GeneInfoTitle geneInfoTitle) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(geneInfoTitle.getName());
        stringBuffer.append("\t");
        stringBuffer.append(geneInfoTitle.getKey());
        stringBuffer.append("\t");
        stringBuffer.append(geneInfoTitle.getTypeString());
        stringBuffer.append("\t");
        stringBuffer.append(geneInfoTitle.getCategory());
        stringBuffer.append("\t");
        stringBuffer.append(geneInfoTitle.getLocationName());
        stringBuffer.append("\t");
        stringBuffer.append(geneInfoTitle.isEditable());
        stringBuffer.append("\t");
        stringBuffer.append(geneInfoTitle.isServerSearchEnable());
        stringBuffer.append("\t");
        stringBuffer.append(geneInfoTitle.getSearchEqualType());
        stringBuffer.append("\t");
        stringBuffer.append(this.createCalcOptionLine(geneInfoTitle));
        stringBuffer.append("\t");
        stringBuffer.append(StringTool.conbineStrList(geneInfoTitle.getOrganismCodeSet(), ","));
        return stringBuffer.toString();
    }

    protected List getHeaderNameList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Name");
        arrayList.add("Key");
        arrayList.add("Type");
        arrayList.add("Category");
        arrayList.add("Location");
        arrayList.add("Editable");
        arrayList.add("ServerSearchEnable");
        arrayList.add("SearchEqualType");
        for (int i = 0; i < CALC_HEADERS.length; ++i) {
            arrayList.add(CALC_HEADERS[i]);
        }
        arrayList.add("Organism");
        return arrayList;
    }
}

