/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.gene;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.info.gene.GeneInfoNameComparator;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.util.ApplicationLogger;
import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class GeneInfoListCreater
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(GeneInfoListCreater.class);
    private MediatorImpl mediator;
    private String organismCode;
    private List clusterList;

    public GeneInfoListCreater(MediatorImpl mediatorImpl, String string, List list) {
        this.mediator = mediatorImpl;
        this.organismCode = string;
        this.clusterList = list;
    }

    public void execute(ProgressImpl progressImpl) {
        progressImpl.setTotal(4);
        try {
            final List list = GeneInfoFacade.getGeneInfoTitleList(this.organismCode);
            progressImpl.increment();
            Map map = GeneInfoFacade.createGeneInfoMap(this.clusterList, this.organismCode, list);
            progressImpl.increment();
            final ArrayList arrayList = new ArrayList(map.values());
            for (GeneInfo geneInfo : arrayList) {
                geneInfo.putInfo(GeneInfoTitle.TITLE_ORGANISM_CODE, this.organismCode);
            }
            progressImpl.increment();
            Collections.sort(arrayList, new GeneInfoNameComparator());
            progressImpl.increment();
            progressImpl.setVisible(false);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GeneInfoListCreater.this.mediator.showGeneListFrame(GeneInfoListCreater.this.organismCode, list, arrayList);
                }
            });
        }
        catch (Exception exception) {
            String string = "Fail to load gene information.";
            logger.warn(string, exception);
        }
    }

    public void done() {
    }
}

