/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.gene;

import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.InfoType;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GeneInfoTitle
extends AbstractInfoTitle
implements Cloneable {
    public static final String KEY_ORGANISM_CODE = "sp";
    public static final String KEY_LOCUSTAG = "locustag";
    public static final String KEY_NAME = "name";
    public static final String KEY_GENE_NAME = "gene";
    public static final String KEY_CHRID = "chrid";
    public static final String KEY_CONTIGID = "contigid";
    public static final String KEY_ACCESSION = "protid";
    public static final String KEY_START = "from1";
    public static final String KEY_END = "to1";
    public static final String KEY_START_ON_GENE = "fromOnGene";
    public static final String KEY_END_ON_GENE = "toOnGene";
    public static final String KEY_STRAND = "dir";
    public static final String KEY_DESCRIPTION = "descr";
    public static final String KEY_CHROMOSOME = "chromosome";
    public static final String KEY_GI = "gi";
    public static final String KEY_GENEID = "geneid";
    public static final String KEY_TYPE = "type";
    public static final String KEY_AA_LEN = "aalen";
    public static final String KEY_NUM_DOMAIN = "num_domain";
    public static final String KEY_VENN_BIT_PATTERN = "venn_bit_pattern";
    public static final String KEY_LOWER_SCORE = "lower_score";
    public static final String KEY_LOWER_DIST = "lower_dist";
    public static final String KEY_UPPER_SCORE = "upper_score";
    public static final String KEY_UPPER_DIST = "upper_dist";
    public static final String KEY_CORE_GENE_FLAG = "##CORE_GENE_FLAG";
    public static final String NAME_ORGANISM_CODE = "Organism";
    public static final String NAME_LOCUSTAG = "LocusTag";
    public static final String NAME_GENE_NAME = "Gene Name";
    public static final String NAME_CHRID = "Chromosome ID";
    public static final String NAME_CONTIGID = "Contig ID";
    public static final String NAME_ACCESSION = "Accession";
    public static final String NAME_START = "Start";
    public static final String NAME_END = "End";
    public static final String NAME_START_ON_GENE = "StartOnGene";
    public static final String NAME_END_ON_GENE = "EndOnGene";
    public static final String NAME_STRAND = "Strand";
    public static final String NAME_DESCRIPTION = "Descritpion";
    public static final String NAME_CHROMOSOME = "Chromosome";
    public static final String NAME_TYPE = "Feature Key";
    public static final String NAME_AA_LEN = "AA length";
    public static final String NAME_NUM_DOMAIN = "Number of split domain";
    public static final String NAME_VENN_BIT_PATTERN = "Venn Bit Pattern";
    public static final String NAME_LOWER_SCORE = "Lower Score";
    public static final String NAME_LOWER_DIST = "Lower Dist";
    public static final String NAME_UPPER_SCORE = "Upper Score";
    public static final String NAME_UPPER_DIST = "Upper Dist";
    public static final GeneInfoTitle TITLE_ORGANISM_CODE = new GeneInfoTitle("sp", "Organism", 2);
    public static final GeneInfoTitle TITLE_LOCUS_TAG_USER = new GeneInfoTitle("locustag", "LocusTag", 2);
    public static final GeneInfoTitle TITLE_GENE_NAME = new GeneInfoTitle("gene", "Gene Name", 2);
    public static final GeneInfoTitle TITLE_CHRID = new GeneInfoTitle("chrid", "Chromosome ID", 1);
    public static final GeneInfoTitle TITLE_CONTIGID = new GeneInfoTitle("contigid", "Contig ID", 1);
    public static final GeneInfoTitle TITLE_START = new GeneInfoTitle("from1", "Start", 1);
    public static final GeneInfoTitle TITLE_END = new GeneInfoTitle("to1", "End", 1);
    public static final GeneInfoTitle TITLE_START_ON_GENE = new GeneInfoTitle("fromOnGene", "StartOnGene", 1);
    public static final GeneInfoTitle TITLE_END_ON_GENE = new GeneInfoTitle("toOnGene", "EndOnGene", 1);
    public static final GeneInfoTitle TITLE_STRAND = new GeneInfoTitle("dir", "Strand", 2);
    public static final GeneInfoTitle TITLE_DESCRIPTION = new GeneInfoTitle("descr", "Descritpion", 2);
    public static final GeneInfoTitle TITLE_LOCUSTAG_SERVER = new GeneInfoTitle("name", "LocusTag", 2);
    public static final GeneInfoTitle TITLE_CHROMOSOME = new GeneInfoTitle("chromosome", "Chromosome", 2);
    public static final GeneInfoTitle TITLE_TYPE = new GeneInfoTitle("type", "Feature Key", 2);
    public static final GeneInfoTitle TITLE_AA_LEN = new GeneInfoTitle("aalen", "AA length", 1);
    public static final GeneInfoTitle TITLE_NUM_DOMAIN = new GeneInfoTitle("num_domain", "Number of split domain", 1);
    public static final GeneInfoTitle TITLE_VENN_BIT_PATTERN = new GeneInfoTitle("venn_bit_pattern", "Venn Bit Pattern", 2);
    public static final GeneInfoTitle TITLE_LOWER_SCORE = new GeneInfoTitle("lower_score", "Lower Score", 1);
    public static final GeneInfoTitle TITLE_LOWER_DIST = new GeneInfoTitle("lower_dist", "Lower Dist", 1);
    public static final GeneInfoTitle TITLE_UPPER_SCORE = new GeneInfoTitle("upper_score", "Upper Score", 1);
    public static final GeneInfoTitle TITLE_UPPER_DIST = new GeneInfoTitle("upper_dist", "Upper Dist", 1);
    public static final GeneInfoTitle TITLE_CORE_GENE_FLAG = new GeneInfoTitle("##CORE_GENE_FLAG", "##CORE_GENE_FLAG", 1);
    private Set organismCodeSet = new HashSet();

    GeneInfoTitle() {
        this.setCls(1);
    }

    public GeneInfoTitle(String string, String string2, int n) {
        this.setCls(1);
        this.setKey(string);
        this.setName(string2);
        this.setType(n);
        this.setSearchEqualType(GeneInfoTitle.getSearchEqualTypeFromType(n));
        this.setEditable(false);
    }

    public boolean isSp() {
        return this.equalsKey(KEY_ORGANISM_CODE);
    }

    public boolean isLocusTag() {
        return this.equalsKey(KEY_NAME) || this.equalsKey(KEY_LOCUSTAG);
    }

    public Set getOrganismCodeSet() {
        return this.organismCodeSet;
    }

    public String getOrganismCodeString() {
        return StringTool.conbineStrList(this.getOrganismCodeSet(), ",");
    }

    public void addOrganismCode(String string) {
        this.organismCodeSet.add(string);
    }

    public void addAllOrganismCode(Collection collection) {
        this.organismCodeSet.addAll(collection);
    }

    public void setOrganismCodeSet(Set set) {
        this.organismCodeSet = set;
    }

    public boolean containsOrganismCode(String string) {
        return this.organismCodeSet.contains(string);
    }

    public boolean containsOrganismCode(Collection collection) {
        for (String string : collection) {
            if (!this.getOrganismCodeSet().contains(string)) continue;
            return true;
        }
        return false;
    }

    public static GeneInfoTitle createGeneInfoTitle(String string, String string2, int n, String string3) {
        GeneInfoTitle geneInfoTitle = new GeneInfoTitle(string2, string, n);
        geneInfoTitle.setLocationName(string3);
        return geneInfoTitle;
    }

    public static GeneInfoTitle createGeneInfoTitle(String string, String string2) {
        Map map = GeneInfoTitle.createNameTypeInfo(string);
        String string3 = (String)map.get("Name");
        String string4 = (String)map.get("TypeName");
        boolean bl = (Boolean)map.get("Multi");
        List list = (List)map.get("ElementList");
        GeneInfoTitle geneInfoTitle = new GeneInfoTitle(string3, string3, InfoType.getTypeIndex(string4));
        geneInfoTitle.setMulti(bl);
        geneInfoTitle.setElementList(list);
        geneInfoTitle.setLocationName(string2);
        geneInfoTitle.setEditable(true);
        return geneInfoTitle;
    }

    public static List getSystemGeneInfoTitleKeyList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(KEY_ORGANISM_CODE);
        arrayList.add(KEY_LOCUSTAG);
        arrayList.add(KEY_NAME);
        arrayList.add(KEY_GENE_NAME);
        arrayList.add(KEY_CHRID);
        arrayList.add(KEY_CONTIGID);
        arrayList.add(KEY_ACCESSION);
        arrayList.add(KEY_START);
        arrayList.add(KEY_END);
        arrayList.add(KEY_STRAND);
        arrayList.add(KEY_DESCRIPTION);
        arrayList.add(KEY_CHROMOSOME);
        arrayList.add(KEY_GI);
        arrayList.add(KEY_GENEID);
        arrayList.add(KEY_TYPE);
        arrayList.add(KEY_AA_LEN);
        arrayList.add(KEY_NUM_DOMAIN);
        arrayList.add(KEY_CORE_GENE_FLAG);
        arrayList.add(KEY_VENN_BIT_PATTERN);
        arrayList.add(KEY_LOWER_SCORE);
        arrayList.add(KEY_LOWER_DIST);
        arrayList.add(KEY_UPPER_SCORE);
        arrayList.add(KEY_UPPER_DIST);
        return arrayList;
    }

    public boolean equals(Object object) {
        if (!(object instanceof GeneInfoTitle)) {
            return false;
        }
        GeneInfoTitle geneInfoTitle = (GeneInfoTitle)object;
        return this.equalsKey(geneInfoTitle.getKey()) && this.equalsLocation(geneInfoTitle.getLocationName());
    }

    public int hashCode() {
        int n = 1;
        n = n * 31 + this.getKey().toLowerCase().hashCode();
        n = n * 31 + this.getLocationName().hashCode();
        return n;
    }

    public String toString() {
        return this.getKey();
    }

    public Object clone() {
        return super.clone();
    }
}

