/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.gene;

import cgdp.recog.info.AbstractInfo;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.server.AbstractServerResourceAccesser;
import cgdp.recog.system.Codec;
import cgdp.recog.system.URLList;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GeneInfoUploader
extends AbstractServerResourceAccesser {
    private static final ApplicationLogger logger = new ApplicationLogger(GeneInfoUploader.class);
    private static final String DELIMITER = "\t";
    private GeneInfoTitle geneInfoTitle;
    private List geneInfoList;
    private String uploadType = "";

    public GeneInfoUploader(GeneInfoTitle geneInfoTitle, List list, String string) throws Exception {
        this.geneInfoTitle = geneInfoTitle;
        this.geneInfoList = list;
        this.setUploadType(string);
        this.setContextPath(URLList.getInstance().getPutGeneProp());
        this.setOptions();
    }

    private void setUploadType(String string) {
        this.uploadType = string;
    }

    public void parseOutputStringData(int n, String string) {
    }

    public void setOptions() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("mode=");
        if (this.uploadType != null) {
            stringBuffer.append(this.uploadType);
        }
        stringBuffer.append("&prop_val=");
        stringBuffer.append(Codec.encode(this.getPropertyContents()));
        this.setOptions(stringBuffer.toString());
    }

    private String getPropertyContents() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("sp");
        stringBuffer.append(DELIMITER);
        stringBuffer.append("name");
        stringBuffer.append(DELIMITER);
        stringBuffer.append(AbstractInfoTitle.getNameTypeString(this.geneInfoTitle, true));
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        for (GeneInfo geneInfo : this.geneInfoList) {
            if (!geneInfo.containsTitle(this.geneInfoTitle)) continue;
            stringBuffer.append(geneInfo.getInfo(GeneInfoTitle.TITLE_ORGANISM_CODE));
            stringBuffer.append(DELIMITER);
            stringBuffer.append(geneInfo.getInfo(GeneInfoTitle.TITLE_LOCUSTAG_SERVER));
            stringBuffer.append(DELIMITER);
            stringBuffer.append(geneInfo.getInfo(this.geneInfoTitle));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        logger.info(stringBuffer.toString());
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            Object object2;
            GeneInfoTitle geneInfoTitle = GeneInfoFacade.getGeneInfoTitle("Test AA");
            String string = "OP1";
            Map map = GeneInfoFacade.getUserDefGeneInfoMap(string);
            ArrayList arrayList = new ArrayList(map.values());
            for (Object object2 : arrayList) {
                ((AbstractInfo)object2).putInfo(GeneInfoTitle.TITLE_ORGANISM_CODE, string);
            }
            GeneInfoUploader geneInfoUploader = new GeneInfoUploader(geneInfoTitle, arrayList, "");
            geneInfoUploader.setOptions();
            object2 = geneInfoUploader.getOptions();
            System.out.println((String)object2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

