/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.mapping;

import cgdp.recog.data.Chromosome;
import cgdp.recog.data.Contig;
import cgdp.recog.util.GeneDirection;

public class MapRecode {
    static final int NO_VALUE = Integer.MIN_VALUE;
    static final int NO_VALUE_ORDER = Integer.MAX_VALUE;
    static final int CONTIG = 1;
    static final int GAP = 2;
    private int type = 1;
    private String organismCode;
    private Chromosome chromosome;
    private Contig contig;
    private String seqNo;
    private int orderNo = Integer.MAX_VALUE;
    private int from = 1;
    private int to = 0;
    private GeneDirection geneDirection = new GeneDirection();

    public static MapRecode createGapMapRecode() {
        MapRecode mapRecode = new MapRecode();
        mapRecode.setType(2);
        return mapRecode;
    }

    public String getOrganismCode() {
        return this.organismCode;
    }

    public void setOrganismCode(String string) {
        this.organismCode = string;
    }

    public void setContig(Contig contig) {
        this.contig = contig;
    }

    public Contig getContig() {
        return this.contig;
    }

    public int getContigId() {
        if (!this.isExistContig()) {
            return Integer.MIN_VALUE;
        }
        return this.contig.getId();
    }

    private boolean isExistContig() {
        return this.contig != null;
    }

    public void setChromosome(Chromosome chromosome) {
        this.chromosome = chromosome;
    }

    public Chromosome getChromosome() {
        return this.chromosome;
    }

    public boolean isExistChromosome() {
        return this.getChromosome() != null;
    }

    public int getChrId() {
        if (!this.isExistChromosome()) {
            return Integer.MIN_VALUE;
        }
        return this.getChromosome().getId();
    }

    public String getChrNo() {
        return this.getChromosome().getName();
    }

    public String getSeqNo() {
        return this.seqNo;
    }

    public void setSeqNo(String string) {
        this.seqNo = string;
    }

    public int getOrderNo() {
        return this.orderNo;
    }

    public void setOrderNo(int n) {
        this.orderNo = n;
    }

    public boolean isNoOrderNo() {
        return this.getOrderNo() == Integer.MAX_VALUE;
    }

    public int getFrom() {
        return this.from;
    }

    public void setFrom(int n) {
        this.from = n;
    }

    public int getTo() {
        return this.to;
    }

    public void setTo(int n) {
        this.to = n;
    }

    public int getLength() {
        return Math.abs(this.getTo() - this.getFrom() + 1);
    }

    public void setDirection(short s) {
        this.geneDirection.setDirection(s);
    }

    public int getDirection() {
        if (this.isGap()) {
            return 0;
        }
        return this.geneDirection.getDirection();
    }

    public boolean isPositive() {
        return this.geneDirection.isPositive();
    }

    public boolean isNegative() {
        return this.geneDirection.isNegative();
    }

    public boolean isNoDirection() {
        return this.geneDirection.isNoSet();
    }

    public GeneDirection getGeneDirection() {
        return this.geneDirection;
    }

    public void setGeneDirection(GeneDirection geneDirection) {
        this.geneDirection = geneDirection;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public boolean isContig() {
        return this.getType() == 1;
    }

    public boolean isGap() {
        return this.getType() == 2;
    }

    public void setGap() {
        this.setType(2);
    }

    public static boolean isNoValue(int n) {
        return n == Integer.MIN_VALUE;
    }

    public boolean equalsContig(MapRecode mapRecode) {
        if (this.getContig() == null || mapRecode.getContig() == null) {
            return false;
        }
        return this.getContig().equalsChromId(mapRecode.getContig().getId());
    }
}

