/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.menu;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.util.JLicenserTool;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class ClusterModeTool
extends JButton
implements CommandImpl {
    private MediatorImpl mediator;

    public ClusterModeTool(ActionListener actionListener, MediatorImpl mediatorImpl) {
        this.setMargin(new Insets(2, 2, 2, 2));
        this.changeMode();
        this.setEnabled(false);
        this.addActionListener(actionListener);
        this.mediator = mediatorImpl;
        this.mediator.register(this);
    }

    public void execute() {
        this.mediator.setClusterMode(!this.isClusterMode());
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        return new Point(mouseEvent.getX(), this.getSize().height);
    }

    public void changeMode() {
        this.setToolTipText(this.getLabelText());
        this.changeIcon();
    }

    private String getLabelText() {
        return this.isClusterMode() ? "Cluster Mode" : "Sub Cluster Mode";
    }

    private void changeIcon() {
        try {
            if (this.isClusterMode()) {
                this.setIcon(new ImageIcon(JLicenserTool.getResource("cgdp.recog.startup.Startup", "images/base_cluster.png")));
            } else {
                this.setIcon(new ImageIcon(JLicenserTool.getResource("cgdp.recog.startup.Startup", "images/base_subcluster.png")));
            }
        }
        catch (Exception exception) {
            this.setText("0");
        }
    }

    private boolean isClusterMode() {
        return OptionTbl.getInstance().getOptionValues().isClusterMode();
    }
}

