/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.mgmap;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.PatternColor;
import cgdp.recog.data.PatternTbl;
import cgdp.recog.table.AminoCodeCellRenderer;
import cgdp.recog.table.PatternTableModel;
import cgdp.recog.util.ColorUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.JColorChooser;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class PatternTable
extends JScrollPane
implements MouseListener {
    MediatorImpl m_mediatorImpl;
    PatternTbl m_patternTbl;
    int m_width;
    JTable m_table;

    public PatternTable(MediatorImpl mediatorImpl) {
        this.m_mediatorImpl = mediatorImpl;
        this.clear();
        this.createComponent();
        this.setPreferredSize(new Dimension(this.m_width + 20, 350));
        this.setHorizontalScrollBarPolicy(31);
    }

    private void clear() {
        this.m_patternTbl = PatternTbl.getInstance();
        this.m_width = 0;
    }

    private void createComponent() {
        int[] nArray = new int[]{80, 80};
        Object[] objectArray = new String[]{"Foreground", "Background"};
        Object[][] objectArray2 = new Object[this.m_patternTbl.size()][2];
        Iterator iterator = this.m_patternTbl.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            PatternColor patternColor = (PatternColor)iterator.next();
            objectArray2[n][0] = ColorUtil.color2Str(patternColor.getForeground());
            objectArray2[n][1] = ColorUtil.color2Str(patternColor.getBackground());
            ++n;
        }
        this.m_table = new JTable(new PatternTableModel(objectArray2, objectArray));
        this.m_table.addMouseListener(this);
        this.m_table.setSelectionMode(0);
        this.m_table.setRowHeight(20);
        Enumeration<TableColumn> enumeration = this.m_table.getColumnModel().getColumns();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setPreferredWidth(nArray[n2]);
            tableColumn.setCellRenderer(new AminoCodeCellRenderer());
            this.m_width += nArray[n2];
            ++n2;
        }
        this.setViewportView(this.m_table);
    }

    private void setPatternColor(int n, int n2) {
        String string = (String)this.m_table.getValueAt(n, n2);
        Color color = JColorChooser.showDialog(this.m_table, "Color palette", ColorUtil.str2Color(string));
        if (color != null) {
            this.m_table.setValueAt(ColorUtil.color2Str(color), n, n2);
            this.m_table.repaint();
        }
    }

    public void setPatternColor() {
        int n = this.m_table.getRowCount();
        for (int i = 0; i < n; ++i) {
            String string = (String)this.m_table.getValueAt(i, 0);
            String string2 = (String)this.m_table.getValueAt(i, 1);
            PatternColor patternColor = (PatternColor)this.m_patternTbl.get(i);
            patternColor.setForeground(ColorUtil.str2Color(string));
            patternColor.setBackground(ColorUtil.str2Color(string2));
        }
    }

    public List getPatternList() {
        ArrayList<PatternColor> arrayList = new ArrayList<PatternColor>();
        int n = this.m_table.getRowCount();
        for (int i = 0; i < n; ++i) {
            String string = (String)this.m_table.getValueAt(i, 0);
            String string2 = (String)this.m_table.getValueAt(i, 1);
            PatternColor patternColor = new PatternColor();
            patternColor.setForeground(ColorUtil.str2Color(string));
            patternColor.setBackground(ColorUtil.str2Color(string2));
            arrayList.add(patternColor);
        }
        return arrayList;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.m_table.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.m_table.columnAtPoint(mouseEvent.getPoint());
        if (n >= 0 && n2 >= 0 && mouseEvent.getButton() == 1) {
            this.setPatternColor(n, n2);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

