/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.option;

import cgdp.recog.bean.Const;
import cgdp.recog.coregenome.CoreGenomeAlignmentCondition;
import cgdp.recog.neighbor.NeighboringClustCondition;
import cgdp.recog.option.OptionValues;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.StringTool;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class OptionTbl {
    private static final ApplicationLogger logger = new ApplicationLogger(OptionTbl.class);
    String m_header;
    String m_oldHeader;
    OptionValues m_optionValues;
    private static final String OPTION_VALUES = "OPTION VALUES:";
    private static final String USER_IMPORT_DIR = "userImportDir";
    private static final String USER_EXPORT_DIR = "userExportDir";
    private static final String INTENSIVE = "intensive";
    private static final String CLUSTER_TREE_URL = "clusterTreeUrl";
    private static final String GENE_INFO_URL = "geneInfoUrl";
    private static final String GENE_ANNOTATION_URL = "geneAnnotationUrl";
    private static final String CLUSTER_ANNOTATION_URL = "clusterAnnotationUrl";
    private static final String FUNC_CAT_URL = "funcCatUrl";
    private static final String FUNCTION_CATEGORY_TYPE = "functionCategory";
    private static final String NA_URL = "naUrl";
    private static final String AA_URL = "aaUrl";
    private static final String DOMAIN_URL = "domainUrl";
    private static final String MAIN_WINDOW_X = "mainWindowX";
    private static final String MAIN_WINDOW_Y = "mainWindowY";
    private static final String MAIN_WINDOW_W = "mainWindowW";
    private static final String MAIN_WINDOW_H = "mainWindowH";
    private static final String DIVIDER_LOCATION1 = "dividerLocation1";
    private static final String DIVIDER_LOCATION2 = "dividerLocation2";
    private static final String DIVIDER_LOCATION3 = "dividerLocation3";
    private static final String DIVIDER_LOCATION4 = "dividerLocation4";
    private static final String DIVIDER_LOCATION5 = "dividerLocation5";
    private static final String CLUSTER_FROM = "clusterFrom";
    private static final String CLUSTER_TO = "clusterTo";
    private static final String CLUSTER_COUNT = "clusterCount";
    private static final String ALIGNMENT_FRAME_X = "alignmentFrameX";
    private static final String ALIGNMENT_FRAME_Y = "alignmentFrameY";
    private static final String ALIGNMENT_FRAME_W = "alignmentFrameW";
    private static final String ALIGNMENT_FRAME_H = "alignmentFrameH";
    private static final String CLUSTAL_W = "clustalW";
    private static final String MULTI_FRAME_X = "multiFrameX";
    private static final String MULTI_FRAME_Y = "multiFrameY";
    private static final String MULTI_FRAME_W = "multiFrameW";
    private static final String MULTI_FRAME_H = "multiFrameH";
    private static final String TREE_TYPE = "treeType";
    private static final String TOPLEVEL = "toplevel";
    private static final String SUPERKINGDOM = "superkingdom";
    private static final String NO_RANK = "no rank";
    private static final String KINGDOM = "kingdom";
    private static final String SUPERPHYLUM = "superphylum";
    private static final String PHYLUM = "phylum";
    private static final String SUBPHYLUM = "subphylum";
    private static final String CLASS = "class";
    private static final String SUBCLASS = "subclass";
    private static final String ORDER = "order";
    private static final String SUBORDER = "suborder";
    private static final String FAMILY = "family";
    private static final String TRIBE = "tribe";
    private static final String GENUS = "genus";
    private static final String SPECIESGROUP = "speciesgroup";
    private static final String SPECIES = "species";
    private static final String RANKITEMS = "rankItems";
    private static final String GENOME_MAP_FRAME_X = "genomeMapFrameX";
    private static final String GENOME_MAP_FRAME_Y = "genomeMapFrameY";
    private static final String GENOME_MAP_FRAME_W = "genomeMapFrameW";
    private static final String GENOME_MAP_FRAME_H = "genomeMapFrameH";
    private static final String DOM_CLUST_URL = "domClustUrl";
    private static final String DOM_CLUST_KILL_URL = "domClustKillUrl";
    private static final String DOMCLUST_CONDITION_NAME = "domClustConditionName";
    private static final String CLUSTALW_OPT_TYPE = "clustalWOpt_TYPE";
    private static final String CLUSTALW_OPT_OUTPUT = "clustalWOpt_OUTPUT";
    private static final String CLUSTALW_OPT_ORDER = "clustalWOpt_ORDER";
    private static final String CLUSTALW_OPT_MATRIX = "clustalWOpt_MATRIX";
    private static final String CLUSTALW_OPT_RANGE = "clustalWOpt_RANGE";
    private static final String CLUSTALW_OPT_START = "clustalWOpt_START";
    private static final String CLUSTALW_OPT_LENGTH = "clustalWOpt_LENGTH";
    private static final String CLUSTALW_OPT_OPEN = "clustalWOpt_OPEN";
    private static final String CLUSTALW_OPT_EXT = "clustalWOpt_EXT";
    private static final String CLUSTALW_OPT_DIST = "clustalWOpt_DIST";
    private static final String CLUSTALW_OPT_DIV = "clustalWOpt_DIV";
    private static final String CLUSTALW_OPT_END = "clustalWOpt_END";
    private static final String CLUSTALW_OPT_NOP = "clustalWOpt_NOP";
    private static final String CLUSTALW_OPT_NOH = "clustalWOpt_NOH";
    private static final String CLUSTALW_OPT_TREE = "clustalWOpt_TREE";
    private static final String CLUSTALW_OPT_KTUPLE = "clustalWOpt_KTUPLE";
    private static final String CLUSTALW_OPT_WINDOW = "clustalWOpt_WINDOW";
    private static final String CLUSTALW_OPT_SCORE = "clustalWOpt_SCORE";
    private static final String CLUSTALW_OPT_TOP = "clustalWOpt_TOP";
    private static final String CLUSTALW_OPT_PAIR = "clustalWOpt_PAIR";
    private static final String CLUSTALW_OPT_PWM = "clustalWOpt_PWM";
    private static final String CLUSTALW_OPT_PWO = "clustalWOpt_PWO";
    private static final String CLUSTALW_OPT_PWE = "clustalWOpt_PWE";
    private static final String CLUSTALW_OPT_KIMURA = "clustalWOpt_KIMURA";
    private static final String CLUSTALW_OPT_TOSS = "clustalWOpt_TOSS";
    private static final String CLUSTALW_OPT_OTREE = "clustalWOpt_OTREE";
    private static final String CLUSTALW_OPT_BS = "clustalWOpt_BS";
    private static final String CLUSTALW_OPT_COUNT = "clustalWOpt_COUNT";
    private static final String CLUSTALW_OPT_SEED = "clustalWOpt_SEED";
    private static final String GENE_FRAME_X = "geneFrameX";
    private static final String GENE_FRAME_Y = "geneFrameY";
    private static final String GENE_FRAME_W = "geneFrameW";
    private static final String GENE_FRAME_H = "geneFrameH";
    private static final String CSV_DIR = "csvDir";
    private static final String GET_DATA_URL = "getDataUrl";
    private static final String EXPAND = "expand";
    private static final String ZOOM_IN2 = "zoomIn2";
    private static final String ZOOM_OUT2 = "zoomOut2";
    private static final String MIN_CLUSTER_H = "minClusterH";
    private static final String MIN_CLUSTER_W = "minClusterW";
    private static final String MOVE_PREV = "movePrev";
    private static final String MOVE_NEXT = "moveNext";
    private static final String CELL_PAINT = "cellPaint";
    private static final String GENE_COUNT2 = "geneCount2";
    private static final String CELL_COLOR = "cellColor";
    private static final String GENE_NAME_VIEW = "geneNameView";
    private static final String BORDER_LINE_VIEW = "borderLineView";
    private static final String TAXONOMY_VIEW = "taxonomyView";
    private static final String FUNCTION_VIEW = "functionView";
    private static final String LAST_DIVIDER_LOCATION1 = "lastDividerLocation1";
    private static final String LAST_DIVIDER_LOCATION2 = "lastDividerLocation2";
    private static final String BORDER_LINE = "borderLine";
    private static final String OUTGROUP = "outgroup";
    private static final String INGROUP = "ingroup";
    private static final String USE_INGROUP_OUTGROUP = "useIngroupOutgroup";
    private static final String INGROUP_OUTGROUP = "ingroupOutgroup";
    private static final String SELECT_LINE1 = "selecteLine1";
    private static final String SELECT_LINE2 = "selecteLine2";
    private static final String SEARCH_RESULT = "searchResult";
    private static final String INGROUP2 = "ingroup2";
    private static final String OUTGROUP2 = "outgroup2";
    private static final String UPDATE_SITE_URL = "updateSiteURL";
    private static final String SYS_INFO_URL = "sysInfoURL";
    private static final String ERROR_UPLOAD_URL = "errorUploadURL";
    private static final String UPDATE_CHECK_INTERVAL = "updateCheckInterval";
    private static final String SHOW_TREE_DIST_FROM_UPGMA = "showTreeDistFromUpgma";
    private static final String CORE_GENOME_URL = "coreGenomeUrl";
    private static final String CORE_GENOME_LOAD_DIR = "coreGenomeLoadDir";
    private static final String CORE_GENOME_SAVE_DIR = "coreGenomeSaveDir";
    private static final String CORE_GENOME_ORTHOLOG_RATE = "coreGenomeOrthologRate";
    private static final String CORE_GENOME_CONNECTION_RATE = "coreGenomeConnectionRate";
    private static final String CORE_GENOME_USE_SP_GROUP = "coreGenomeUseSpGroup";
    private static final String CORE_GENOME_MIN_SP_COV = "coreGenomeMinSpCov";
    private static final String CORE_GENOME_SP_COV_REG_CUT = "coreGenomeSpCovRegCut";
    private static final String CORE_GENOME_MIN_CLUSTSIZ = "coreGenomeMinClustSiz";
    private static final String CORE_GENOME_OTHER_OPTIONS = "coreGenomeOtherOptions";
    private static final String CORE_GENOME_WINDOW_SIZE = "coreGenomeWindowSize";
    private static final String NEIGHBOR_MAX_DIST_SAME_GROUP = "neigborMaxDistSameGroup";
    private static final String NEIGHBOR_SEARCH_CLUSTER_COUNT = "neigborSearchClusterCount";
    private static final String NEIGHBOR_COLOR_PATTERN_LIST = "neigborColorPattern";
    private static final String CLIENT_VERSION_URL = "clientVersionURL";
    private static final String SHOW_VERSION_UP = "showVersionUp";
    private static final String SEQ_DOWNLOAD_URL = "seqDownloadURL";
    private static final String SHOW_HIDDEN_MENU = "showHiddenMenu";
    private static final String PUBLIC_COLOR = "publicColor";
    private static final String ENABLE_DOMCLUST_PARAM = "enableDomclustParam";
    private static final OptionTbl m_optionTbl = new OptionTbl();

    private OptionTbl() {
        this.clear();
        try {
            this.readOption();
        }
        catch (IOException iOException) {
            MessageManager.showErrorMessage(null, "Fail to load option file.");
            System.exit(1);
        }
    }

    private void clear() {
        this.m_header = "# RECOG";
        this.m_oldHeader = "# MBGD Cluster Window";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readOptionValues() throws IOException {
        this.m_optionValues = new OptionValues();
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            String string;
            fileInputStream = new FileInputStream(Const.USER_OPTION_DAT_PATH);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            boolean bl = false;
            while ((string = bufferedReader.readLine()) != null) {
                if (bl) {
                    this.readOptions(string);
                }
                if (!string.equals(OPTION_VALUES)) continue;
                bl = true;
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    private boolean readOptions(String string) {
        String string2;
        if (StringTool.isNull(string)) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        String string3 = stringTokenizer.nextToken();
        String string4 = string2 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
        if (string3.equals(USER_IMPORT_DIR)) {
            this.m_optionValues.setUserImportDir(string2);
        } else if (string3.equals(USER_EXPORT_DIR)) {
            this.m_optionValues.setUserExportDir(string2);
        } else if (string3.equals(INTENSIVE)) {
            this.m_optionValues.setIntensive(Boolean.valueOf(string2));
        } else if (string3.equals(CLUSTER_TREE_URL)) {
            while (stringTokenizer.hasMoreTokens()) {
                string2 = string2 + "=";
                string2 = string2 + stringTokenizer.nextToken();
            }
            this.m_optionValues.setClusterTreeUrl(string2);
        } else if (string3.equals(GENE_INFO_URL)) {
            while (stringTokenizer.hasMoreTokens()) {
                string2 = string2 + "=";
                string2 = string2 + stringTokenizer.nextToken();
            }
            this.m_optionValues.setGeneInfoUrl(string2);
        } else if (string3.equals(GENE_ANNOTATION_URL)) {
            while (stringTokenizer.hasMoreTokens()) {
                string2 = string2 + "=";
                string2 = string2 + stringTokenizer.nextToken();
            }
            this.m_optionValues.setGeneAnnotationUrl(string2);
        } else if (string3.equals(CLUSTER_ANNOTATION_URL)) {
            while (stringTokenizer.hasMoreTokens()) {
                string2 = string2 + "=";
                string2 = string2 + stringTokenizer.nextToken();
            }
            this.m_optionValues.setClusterAnnotationUrl(string2);
        } else if (string3.equals(FUNC_CAT_URL)) {
            while (stringTokenizer.hasMoreTokens()) {
                string2 = string2 + "=";
                string2 = string2 + stringTokenizer.nextToken();
            }
            this.m_optionValues.setFuncCatUrl(string2);
        } else if (string3.equals(FUNCTION_CATEGORY_TYPE)) {
            this.m_optionValues.setFunctionCategoryType(string2);
        } else if (string3.equals(NA_URL)) {
            while (stringTokenizer.hasMoreTokens()) {
                string2 = string2 + "=";
                string2 = string2 + stringTokenizer.nextToken();
            }
            this.m_optionValues.setNaUrl(string2);
        } else if (string3.equals(AA_URL)) {
            while (stringTokenizer.hasMoreTokens()) {
                string2 = string2 + "=";
                string2 = string2 + stringTokenizer.nextToken();
            }
            this.m_optionValues.setAaUrl(string2);
        } else if (string3.equals(DOMAIN_URL)) {
            while (stringTokenizer.hasMoreTokens()) {
                string2 = string2 + "=";
                string2 = string2 + stringTokenizer.nextToken();
            }
            this.m_optionValues.setDomainUrl(string2);
        } else if (string3.equals(MAIN_WINDOW_X)) {
            this.m_optionValues.setMainWindowX(Integer.parseInt(string2));
        } else if (string3.equals(MAIN_WINDOW_Y)) {
            this.m_optionValues.setMainWindowY(Integer.parseInt(string2));
        } else if (string3.equals(MAIN_WINDOW_W)) {
            this.m_optionValues.setMainWindowW(Integer.parseInt(string2));
        } else if (string3.equals(MAIN_WINDOW_H)) {
            this.m_optionValues.setMainWindowH(Integer.parseInt(string2));
        } else if (string3.equals(DIVIDER_LOCATION1)) {
            this.m_optionValues.setDividerLocation1(Integer.parseInt(string2));
        } else if (string3.equals(DIVIDER_LOCATION2)) {
            this.m_optionValues.setDividerLocation2(Integer.parseInt(string2));
        } else if (string3.equals(DIVIDER_LOCATION3)) {
            this.m_optionValues.setDividerLocation3(Integer.parseInt(string2));
        } else if (string3.equals(DIVIDER_LOCATION4)) {
            this.m_optionValues.setDividerLocation4(Integer.parseInt(string2));
        } else if (string3.equals(DIVIDER_LOCATION5)) {
            this.m_optionValues.setDividerLocation5(Integer.parseInt(string2));
        } else if (string3.equals(CLUSTER_FROM)) {
            this.m_optionValues.setClusterFrom(string2);
        } else if (string3.equals(CLUSTER_TO)) {
            this.m_optionValues.setClusterTo(string2);
        } else if (string3.equals(CLUSTER_COUNT)) {
            this.m_optionValues.setClusterCount(Integer.parseInt(string2));
        } else if (string3.equals(ALIGNMENT_FRAME_X)) {
            this.m_optionValues.setAlignmentFrameX(Integer.parseInt(string2));
        } else if (string3.equals(ALIGNMENT_FRAME_Y)) {
            this.m_optionValues.setAlignmentFrameY(Integer.parseInt(string2));
        } else if (string3.equals(ALIGNMENT_FRAME_W)) {
            this.m_optionValues.setAlignmentFrameW(Integer.parseInt(string2));
        } else if (string3.equals(ALIGNMENT_FRAME_H)) {
            this.m_optionValues.setAlignmentFrameH(Integer.parseInt(string2));
        } else if (string3.equals(CLUSTAL_W)) {
            this.m_optionValues.setClustalW(string2);
        } else if (string3.equals(MULTI_FRAME_X)) {
            this.m_optionValues.setMultiFrameX(Integer.parseInt(string2));
        } else if (string3.equals(MULTI_FRAME_Y)) {
            this.m_optionValues.setMultiFrameY(Integer.parseInt(string2));
        } else if (string3.equals(MULTI_FRAME_W)) {
            this.m_optionValues.setMultiFrameW(Integer.parseInt(string2));
        } else if (string3.equals(MULTI_FRAME_H)) {
            this.m_optionValues.setMultiFrameH(Integer.parseInt(string2));
        } else if (string3.equals(TREE_TYPE)) {
            this.m_optionValues.setTreeType(Integer.parseInt(string2));
        } else if (string3.equals(TOPLEVEL)) {
            this.m_optionValues.setTopLevel(Boolean.valueOf(string2));
        } else if (string3.equals(SUPERKINGDOM)) {
            this.m_optionValues.setSuperKingdom(Boolean.valueOf(string2));
        } else if (string3.equals(NO_RANK)) {
            this.m_optionValues.setNoRank(Boolean.valueOf(string2));
        } else if (string3.equals(KINGDOM)) {
            this.m_optionValues.setKingdom(Boolean.valueOf(string2));
        } else if (string3.equals(SUPERPHYLUM)) {
            this.m_optionValues.setSuperPhylum(Boolean.valueOf(string2));
        } else if (string3.equals(PHYLUM)) {
            this.m_optionValues.setPhylum(Boolean.valueOf(string2));
        } else if (string3.equals(SUBPHYLUM)) {
            this.m_optionValues.setSubPhylum(Boolean.valueOf(string2));
        } else if (string3.equals(CLASS)) {
            this.m_optionValues.setClass(Boolean.valueOf(string2));
        } else if (string3.equals(SUBCLASS)) {
            this.m_optionValues.setSubClass(Boolean.valueOf(string2));
        } else if (string3.equals(ORDER)) {
            this.m_optionValues.setOrder(Boolean.valueOf(string2));
        } else if (string3.equals(SUBORDER)) {
            this.m_optionValues.setSubOrder(Boolean.valueOf(string2));
        } else if (string3.equals(FAMILY)) {
            this.m_optionValues.setFamily(Boolean.valueOf(string2));
        } else if (string3.equals(TRIBE)) {
            this.m_optionValues.setTribe(Boolean.valueOf(string2));
        } else if (string3.equals(GENUS)) {
            this.m_optionValues.setGenus(Boolean.valueOf(string2));
        } else if (string3.equals(SPECIESGROUP)) {
            this.m_optionValues.setSpeciesGroup(Boolean.valueOf(string2));
        } else if (string3.equals(SPECIES)) {
            this.m_optionValues.setSpecies(Boolean.valueOf(string2));
        } else if (string3.equals(RANKITEMS)) {
            this.m_optionValues.setRankItems(string2);
        } else if (string3.equals(GENOME_MAP_FRAME_X)) {
            this.m_optionValues.setGenomeMapX(Integer.parseInt(string2));
        } else if (string3.equals(GENOME_MAP_FRAME_Y)) {
            this.m_optionValues.setGenomeMapY(Integer.parseInt(string2));
        } else if (string3.equals(GENOME_MAP_FRAME_W)) {
            this.m_optionValues.setGenomeMapW(Integer.parseInt(string2));
        } else if (string3.equals(GENOME_MAP_FRAME_H)) {
            this.m_optionValues.setGenomeMapH(Integer.parseInt(string2));
        } else if (string3.equals(DOM_CLUST_URL)) {
            this.m_optionValues.setDomClustUrl(string2);
        } else if (string3.equals(DOM_CLUST_KILL_URL)) {
            this.m_optionValues.setDomClustKillUrl(string2);
        } else if (string3.equals(CLUSTALW_OPT_TYPE)) {
            this.m_optionValues.setClustalWOpt_TYPE(string2);
        } else if (string3.equals(CLUSTALW_OPT_OUTPUT)) {
            this.m_optionValues.setClustalWOpt_OUTPUT(string2);
        } else if (string3.equals(CLUSTALW_OPT_ORDER)) {
            this.m_optionValues.setClustalWOpt_ORDER(string2);
        } else if (string3.equals(CLUSTALW_OPT_MATRIX)) {
            this.m_optionValues.setClustalWOpt_MATRIX(string2);
        } else if (string3.equals(CLUSTALW_OPT_RANGE)) {
            this.m_optionValues.setClustalWOpt_RANGE(string2);
        } else if (string3.equals(CLUSTALW_OPT_START)) {
            this.m_optionValues.setClustalWOpt_START(Integer.parseInt(string2));
        } else if (string3.equals(CLUSTALW_OPT_LENGTH)) {
            this.m_optionValues.setClustalWOpt_LENGTH(Integer.parseInt(string2));
        } else if (string3.equals(CLUSTALW_OPT_OPEN)) {
            this.m_optionValues.setClustalWOpt_OPEN(Double.parseDouble(string2));
        } else if (string3.equals(CLUSTALW_OPT_EXT)) {
            this.m_optionValues.setClustalWOpt_EXT(Double.parseDouble(string2));
        } else if (string3.equals(CLUSTALW_OPT_DIST)) {
            this.m_optionValues.setClustalWOpt_DIST(Integer.parseInt(string2));
        } else if (string3.equals(CLUSTALW_OPT_DIV)) {
            this.m_optionValues.setClustalWOpt_DIV(Integer.parseInt(string2));
        } else if (string3.equals(CLUSTALW_OPT_END)) {
            this.m_optionValues.setClustalWOpt_END(string2);
        } else if (string3.equals(CLUSTALW_OPT_NOP)) {
            this.m_optionValues.setClustalWOpt_NOP(string2);
        } else if (string3.equals(CLUSTALW_OPT_NOH)) {
            this.m_optionValues.setClustalWOpt_NOH(string2);
        } else if (string3.equals(CLUSTALW_OPT_TREE)) {
            this.m_optionValues.setClustalWOpt_TREE(string2);
        } else if (string3.equals(CLUSTALW_OPT_KTUPLE)) {
            this.m_optionValues.setClustalWOpt_KTUPLE(Integer.parseInt(string2));
        } else if (string3.equals(CLUSTALW_OPT_WINDOW)) {
            this.m_optionValues.setClustalWOpt_WINDOW(Integer.parseInt(string2));
        } else if (string3.equals(CLUSTALW_OPT_SCORE)) {
            this.m_optionValues.setClustalWOpt_SCORE(string2);
        } else if (string3.equals(CLUSTALW_OPT_TOP)) {
            this.m_optionValues.setClustalWOpt_TOP(Integer.parseInt(string2));
        } else if (string3.equals(CLUSTALW_OPT_PAIR)) {
            this.m_optionValues.setClustalWOpt_PAIR(Integer.parseInt(string2));
        } else if (string3.equals(CLUSTALW_OPT_PWM)) {
            this.m_optionValues.setClustalWOpt_PWM(string2);
        } else if (string3.equals(CLUSTALW_OPT_PWO)) {
            this.m_optionValues.setClustalWOpt_PWO(Double.parseDouble(string2));
        } else if (string3.equals(CLUSTALW_OPT_PWE)) {
            this.m_optionValues.setClustalWOpt_PWE(Double.parseDouble(string2));
        } else if (string3.equals(CLUSTALW_OPT_KIMURA)) {
            this.m_optionValues.setClustalWOpt_KIMURA(string2);
        } else if (string3.equals(CLUSTALW_OPT_TOSS)) {
            this.m_optionValues.setClustalWOpt_TOSS(string2);
        } else if (string3.equals(CLUSTALW_OPT_OTREE)) {
            this.m_optionValues.setClustalWOpt_OTREE(string2);
        } else if (string3.equals(CLUSTALW_OPT_BS)) {
            this.m_optionValues.setClustalWOpt_BS(string2);
        } else if (string3.equals(CLUSTALW_OPT_COUNT)) {
            this.m_optionValues.setClustalWOpt_COUNT(Integer.parseInt(string2));
        } else if (string3.equals(CLUSTALW_OPT_SEED)) {
            this.m_optionValues.setClustalWOpt_SEED(Integer.parseInt(string2));
        } else if (string3.equals(GENE_FRAME_X)) {
            this.m_optionValues.setGeneFrameX(Integer.parseInt(string2));
        } else if (string3.equals(GENE_FRAME_Y)) {
            this.m_optionValues.setGeneFrameY(Integer.parseInt(string2));
        } else if (string3.equals(GENE_FRAME_W)) {
            this.m_optionValues.setGeneFrameW(Integer.parseInt(string2));
        } else if (string3.equals(GENE_FRAME_H)) {
            this.m_optionValues.setGeneFrameH(Integer.parseInt(string2));
        } else if (string3.equals(CSV_DIR)) {
            this.m_optionValues.setCsvDir(string2);
        } else if (string3.equals(GET_DATA_URL)) {
            this.m_optionValues.setGetDataUrl(string2);
        } else if (string3.equals(EXPAND)) {
            this.m_optionValues.setExpand(Boolean.valueOf(string2));
        } else if (string3.equals(ZOOM_IN2)) {
            this.m_optionValues.setZoomIn2(string2);
        } else if (string3.equals(ZOOM_OUT2)) {
            this.m_optionValues.setZoomOut2(string2);
        } else if (string3.equals(MIN_CLUSTER_H)) {
            this.m_optionValues.setMinClusterH(Integer.parseInt(string2));
        } else if (string3.equals(MIN_CLUSTER_W)) {
            this.m_optionValues.setMinClusterW(Integer.parseInt(string2));
        } else if (string3.equals(MOVE_PREV)) {
            this.m_optionValues.setMovePrev(string2);
        } else if (string3.equals(MOVE_NEXT)) {
            this.m_optionValues.setMoveNext(string2);
        } else if (string3.equals(CELL_PAINT)) {
            this.m_optionValues.setGeneCountColorFlag(Boolean.valueOf(string2));
        } else if (string3.equals(GENE_COUNT2)) {
            this.m_optionValues.setGeneCountColorMinCount(Integer.parseInt(string2));
        } else if (string3.equals(CELL_COLOR)) {
            this.m_optionValues.setGeneCountColor(string2);
        } else if (string3.equals(GENE_NAME_VIEW)) {
            this.m_optionValues.setGeneNameView(Boolean.valueOf(string2));
        } else if (string3.equals(BORDER_LINE_VIEW)) {
            this.m_optionValues.setBorderLineView(Boolean.valueOf(string2));
        } else if (string3.equals(TAXONOMY_VIEW)) {
            this.m_optionValues.setTaxonomyView(Boolean.valueOf(string2));
        } else if (string3.equals(FUNCTION_VIEW)) {
            this.m_optionValues.setFunctionView(Boolean.valueOf(string2));
        } else if (string3.equals(LAST_DIVIDER_LOCATION1)) {
            this.m_optionValues.setLastDividerLocation1(Integer.parseInt(string2));
        } else if (string3.equals(LAST_DIVIDER_LOCATION2)) {
            this.m_optionValues.setLastDividerLocation2(Integer.parseInt(string2));
        } else if (string3.equals(BORDER_LINE)) {
            this.m_optionValues.setBorderLineColorString(string2);
        } else if (string3.equals(OUTGROUP)) {
            this.m_optionValues.setOutgroupColorString(string2);
        } else if (string3.equals(INGROUP)) {
            this.m_optionValues.setIngroupColorString(string2);
        } else if (string3.equals(INGROUP_OUTGROUP)) {
            this.m_optionValues.setOutgroupIngroupColorString(string2);
        } else if (string3.equals(USE_INGROUP_OUTGROUP)) {
            this.m_optionValues.setOutgroupAsIngroupFlag(new Boolean(string2));
        } else if (string3.equals(SELECT_LINE1)) {
            this.m_optionValues.setSelectLine1ColorString(string2);
        } else if (string3.equals(SELECT_LINE2)) {
            this.m_optionValues.setSelectLine2ColorString(string2);
        } else if (string3.equals(SEARCH_RESULT)) {
            this.m_optionValues.setSearchResultColorString(string2);
        } else if (string3.equals(INGROUP2)) {
            this.m_optionValues.setIngroupFontColor(string2);
        } else if (string3.equals(OUTGROUP2)) {
            this.m_optionValues.setOutgroupFontColor(string2);
        } else if (string3.equals(UPDATE_SITE_URL)) {
            this.m_optionValues.setUpdateSiteURL(string2);
        } else if (string3.equals(SYS_INFO_URL)) {
            this.m_optionValues.setSysInfoURL(string2);
        } else if (string3.equals(ERROR_UPLOAD_URL)) {
            this.m_optionValues.setErrorUploadURL(string2);
        } else if (string3.equals(UPDATE_CHECK_INTERVAL)) {
            this.m_optionValues.setUpdateCheckInterval(Long.parseLong(string2));
        } else if (string3.equals(SHOW_TREE_DIST_FROM_UPGMA)) {
            this.m_optionValues.setShowTreeDistFromUpgma(Boolean.valueOf(string2));
        } else if (string3.equals(CORE_GENOME_URL)) {
            this.m_optionValues.setCoreGenomeUrl(string2);
        } else if (string3.equals(CORE_GENOME_ORTHOLOG_RATE)) {
            CoreGenomeAlignmentCondition coreGenomeAlignmentCondition = this.m_optionValues.getCoreGenomeAlignmentCondition();
            coreGenomeAlignmentCondition.setOrthologRate(Double.parseDouble(string2));
        } else if (string3.equals(CORE_GENOME_CONNECTION_RATE)) {
            CoreGenomeAlignmentCondition coreGenomeAlignmentCondition = this.m_optionValues.getCoreGenomeAlignmentCondition();
            coreGenomeAlignmentCondition.setConnectionRate(Double.parseDouble(string2));
        } else if (string3.equals(CORE_GENOME_USE_SP_GROUP)) {
            CoreGenomeAlignmentCondition coreGenomeAlignmentCondition = this.m_optionValues.getCoreGenomeAlignmentCondition();
            coreGenomeAlignmentCondition.setUseSpGroup(new Boolean(string2));
        } else if (string3.equals(CORE_GENOME_MIN_SP_COV)) {
            CoreGenomeAlignmentCondition coreGenomeAlignmentCondition = this.m_optionValues.getCoreGenomeAlignmentCondition();
            coreGenomeAlignmentCondition.setMinSpCov(Double.parseDouble(string2));
        } else if (string3.equals(CORE_GENOME_SP_COV_REG_CUT)) {
            CoreGenomeAlignmentCondition coreGenomeAlignmentCondition = this.m_optionValues.getCoreGenomeAlignmentCondition();
            coreGenomeAlignmentCondition.setSpCovRegCut(Double.parseDouble(string2));
        } else if (string3.equals(CORE_GENOME_MIN_CLUSTSIZ)) {
            CoreGenomeAlignmentCondition coreGenomeAlignmentCondition = this.m_optionValues.getCoreGenomeAlignmentCondition();
            coreGenomeAlignmentCondition.setMinClustSiz(Integer.parseInt(string2));
        } else if (string3.equals(CORE_GENOME_OTHER_OPTIONS)) {
            CoreGenomeAlignmentCondition coreGenomeAlignmentCondition = this.m_optionValues.getCoreGenomeAlignmentCondition();
            coreGenomeAlignmentCondition.setOtherOptions(string2);
        } else if (string3.equals(CORE_GENOME_WINDOW_SIZE)) {
            CoreGenomeAlignmentCondition coreGenomeAlignmentCondition = this.m_optionValues.getCoreGenomeAlignmentCondition();
            coreGenomeAlignmentCondition.setWindowSize(Integer.parseInt(string2));
        } else if (string3.equals(DOMCLUST_CONDITION_NAME)) {
            this.m_optionValues.setDomClustConditionName(string2);
        } else if (string3.equals(NEIGHBOR_MAX_DIST_SAME_GROUP)) {
            NeighboringClustCondition neighboringClustCondition = this.m_optionValues.getNeighboringClustCondition();
            neighboringClustCondition.setMaxDistSameGroup(Integer.parseInt(string2));
        } else if (string3.equals(NEIGHBOR_SEARCH_CLUSTER_COUNT)) {
            NeighboringClustCondition neighboringClustCondition = this.m_optionValues.getNeighboringClustCondition();
            neighboringClustCondition.setSearchClusterCount(Integer.parseInt(string2));
        } else if (string3.equals(NEIGHBOR_COLOR_PATTERN_LIST)) {
            this.m_optionValues.setNeighborColorPatternStr(string2);
        } else if (string3.equals(CLIENT_VERSION_URL)) {
            this.m_optionValues.setClientVersionUrl(string2);
        } else if (string3.equals(SHOW_VERSION_UP)) {
            this.m_optionValues.setShowVersionUp(new Boolean(string2));
        } else if (string3.equals(SEQ_DOWNLOAD_URL)) {
            this.m_optionValues.setSeqDownloadURL(string2);
        } else if (string3.equals(SHOW_HIDDEN_MENU)) {
            this.m_optionValues.setShowHiddenMenu(new Boolean(string2));
        } else if (string3.equals(PUBLIC_COLOR)) {
            this.m_optionValues.setPublicColor(string2);
        } else if (string3.equals(ENABLE_DOMCLUST_PARAM)) {
            Vector vector = StringTool.splitString(string2);
            HashSet<Integer> hashSet = new HashSet<Integer>();
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                hashSet.add(new Integer((String)iterator.next()));
            }
            this.m_optionValues.setEnableDomclustParam(hashSet);
        }
        return true;
    }

    public static OptionTbl getInstance() {
        return m_optionTbl;
    }

    public OptionValues getOptionValues() {
        return this.m_optionValues;
    }

    public void readOption() throws IOException {
        this.checkOption();
        this.readOptionValues();
    }

    public void writeOption() throws IOException {
        FileOutputStream fileOutputStream = null;
        PrintWriter printWriter = null;
        try {
            fileOutputStream = new FileOutputStream(Const.USER_OPTION_DAT_PATH);
            printWriter = new PrintWriter(fileOutputStream);
            this.writeOption(printWriter);
            printWriter.flush();
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    private void writeOption(PrintWriter printWriter) {
        printWriter.println(this.m_header);
        printWriter.println("");
        printWriter.println(OPTION_VALUES);
        printWriter.println("userImportDir=" + this.m_optionValues.getUserImportDir());
        printWriter.println("userExportDir=" + this.m_optionValues.getUserExportDir());
        printWriter.println("intensive=" + this.m_optionValues.isIntensive());
        printWriter.println("clusterTreeUrl=" + this.m_optionValues.getClusterTreeUrl());
        printWriter.println("geneInfoUrl=" + this.m_optionValues.getGeneInfoUrl());
        printWriter.println("geneAnnotationUrl=" + this.m_optionValues.getGeneAnnotationUrl());
        printWriter.println("clusterAnnotationUrl=" + this.m_optionValues.getClusterAnnotationUrl());
        printWriter.println("funcCatUrl=" + this.m_optionValues.getFuncCatUrl());
        printWriter.println("functionCategory=" + this.m_optionValues.getFunctionCategoryType());
        printWriter.println("naUrl=" + this.m_optionValues.getNaUrl());
        printWriter.println("aaUrl=" + this.m_optionValues.getAaUrl());
        printWriter.println("domainUrl=" + this.m_optionValues.getDomainUrl());
        printWriter.println("mainWindowX=" + this.m_optionValues.getMainWindowX());
        printWriter.println("mainWindowY=" + this.m_optionValues.getMainWindowY());
        printWriter.println("mainWindowW=" + this.m_optionValues.getMainWindowW());
        printWriter.println("mainWindowH=" + this.m_optionValues.getMainWindowH());
        printWriter.println("dividerLocation1=" + this.m_optionValues.getDividerLocation1());
        printWriter.println("dividerLocation2=" + this.m_optionValues.getDividerLocation2());
        printWriter.println("dividerLocation3=" + this.m_optionValues.getDividerLocation3());
        printWriter.println("dividerLocation4=" + this.m_optionValues.getDividerLocation4());
        printWriter.println("dividerLocation5=" + this.m_optionValues.getDividerLocation5());
        printWriter.println("clusterFrom=" + this.m_optionValues.getClusterFrom());
        printWriter.println("clusterTo=" + this.m_optionValues.getClusterTo());
        printWriter.println("clusterCount=" + this.m_optionValues.getClusterCount());
        printWriter.println("alignmentFrameX=" + this.m_optionValues.getAlignmentFrameX());
        printWriter.println("alignmentFrameY=" + this.m_optionValues.getAlignmentFrameY());
        printWriter.println("alignmentFrameW=" + this.m_optionValues.getAlignmentFrameW());
        printWriter.println("alignmentFrameH=" + this.m_optionValues.getAlignmentFrameH());
        printWriter.println("clustalW=" + this.m_optionValues.getClustalW());
        printWriter.println("multiFrameX=" + this.m_optionValues.getMultiFrameX());
        printWriter.println("multiFrameY=" + this.m_optionValues.getMultiFrameY());
        printWriter.println("multiFrameW=" + this.m_optionValues.getMultiFrameW());
        printWriter.println("multiFrameH=" + this.m_optionValues.getMultiFrameH());
        printWriter.println("treeType=" + this.m_optionValues.getTreeType());
        printWriter.println("toplevel=" + this.m_optionValues.isTopLevel());
        printWriter.println("superkingdom=" + this.m_optionValues.isSuperKingdom());
        printWriter.println("no rank=" + this.m_optionValues.isNoRank());
        printWriter.println("kingdom=" + this.m_optionValues.isKingdom());
        printWriter.println("superphylum=" + this.m_optionValues.isSuperPhylum());
        printWriter.println("phylum=" + this.m_optionValues.isPhylum());
        printWriter.println("subphylum=" + this.m_optionValues.isSubPhylum());
        printWriter.println("class=" + this.m_optionValues.isClass());
        printWriter.println("subclass=" + this.m_optionValues.isSubClass());
        printWriter.println("order=" + this.m_optionValues.isOrder());
        printWriter.println("suborder=" + this.m_optionValues.isSubOrder());
        printWriter.println("family=" + this.m_optionValues.isFamily());
        printWriter.println("tribe=" + this.m_optionValues.isTribe());
        printWriter.println("genus=" + this.m_optionValues.isGenus());
        printWriter.println("speciesgroup=" + this.m_optionValues.isSpeciesGroup());
        printWriter.println("species=" + this.m_optionValues.isSpecies());
        printWriter.println("rankItems=" + this.m_optionValues.getRankItems());
        printWriter.println("genomeMapFrameX=" + this.m_optionValues.getGenomeMapX());
        printWriter.println("genomeMapFrameY=" + this.m_optionValues.getGenomeMapY());
        printWriter.println("genomeMapFrameW=" + this.m_optionValues.getGenomeMapW());
        printWriter.println("genomeMapFrameH=" + this.m_optionValues.getGenomeMapH());
        printWriter.println("domClustUrl=" + this.m_optionValues.getDomClustUrl());
        printWriter.println("domClustKillUrl=" + this.m_optionValues.getDomClustKillUrl());
        printWriter.println("clustalWOpt_TYPE=" + this.m_optionValues.getClustalWOpt_TYPE());
        printWriter.println("clustalWOpt_OUTPUT=" + this.m_optionValues.getClustalWOpt_OUTPUT());
        printWriter.println("clustalWOpt_ORDER=" + this.m_optionValues.getClustalWOpt_ORDER());
        printWriter.println("clustalWOpt_MATRIX=" + this.m_optionValues.getClustalWOpt_MATRIX());
        printWriter.println("clustalWOpt_RANGE=" + this.m_optionValues.getClustalWOpt_RANGE());
        printWriter.println("clustalWOpt_START=" + this.m_optionValues.getClustalWOpt_START());
        printWriter.println("clustalWOpt_LENGTH=" + this.m_optionValues.getClustalWOpt_LENGTH());
        printWriter.println("clustalWOpt_OPEN=" + this.m_optionValues.getClustalWOpt_OPEN());
        printWriter.println("clustalWOpt_EXT=" + this.m_optionValues.getClustalWOpt_EXT());
        printWriter.println("clustalWOpt_DIST=" + this.m_optionValues.getClustalWOpt_DIST());
        printWriter.println("clustalWOpt_DIV=" + this.m_optionValues.getClustalWOpt_DIV());
        printWriter.println("clustalWOpt_END=" + this.m_optionValues.getClustalWOpt_END());
        printWriter.println("clustalWOpt_NOP=" + this.m_optionValues.getClustalWOpt_NOP());
        printWriter.println("clustalWOpt_NOH=" + this.m_optionValues.getClustalWOpt_NOH());
        printWriter.println("clustalWOpt_TREE=" + this.m_optionValues.getClustalWOpt_TREE());
        printWriter.println("clustalWOpt_KTUPLE=" + this.m_optionValues.getClustalWOpt_KTUPLE());
        printWriter.println("clustalWOpt_WINDOW=" + this.m_optionValues.getClustalWOpt_WINDOW());
        printWriter.println("clustalWOpt_SCORE=" + this.m_optionValues.getClustalWOpt_SCORE());
        printWriter.println("clustalWOpt_TOP=" + this.m_optionValues.getClustalWOpt_TOP());
        printWriter.println("clustalWOpt_PAIR=" + this.m_optionValues.getClustalWOpt_PAIR());
        printWriter.println("clustalWOpt_PWM=" + this.m_optionValues.getClustalWOpt_PWM());
        printWriter.println("clustalWOpt_PWO=" + this.m_optionValues.getClustalWOpt_PWO());
        printWriter.println("clustalWOpt_PWE=" + this.m_optionValues.getClustalWOpt_PWE());
        printWriter.println("clustalWOpt_KIMURA=" + this.m_optionValues.getClustalWOpt_KIMURA());
        printWriter.println("clustalWOpt_TOSS=" + this.m_optionValues.getClustalWOpt_TOSS());
        printWriter.println("clustalWOpt_OTREE=" + this.m_optionValues.getClustalWOpt_OTREE());
        printWriter.println("clustalWOpt_BS=" + this.m_optionValues.getClustalWOpt_BS());
        printWriter.println("clustalWOpt_COUNT=" + this.m_optionValues.getClustalWOpt_COUNT());
        printWriter.println("clustalWOpt_SEED=" + this.m_optionValues.getClustalWOpt_SEED());
        printWriter.println("geneFrameX=" + this.m_optionValues.getGeneFrameX());
        printWriter.println("geneFrameY=" + this.m_optionValues.getGeneFrameY());
        printWriter.println("geneFrameW=" + this.m_optionValues.getGeneFrameW());
        printWriter.println("geneFrameH=" + this.m_optionValues.getGeneFrameH());
        printWriter.println("csvDir=" + this.m_optionValues.getCsvDir());
        printWriter.println("getDataUrl=" + this.m_optionValues.getGetDataUrl());
        printWriter.println("expand=" + this.m_optionValues.isExpand());
        printWriter.println("zoomIn2=" + this.m_optionValues.getZoomIn2());
        printWriter.println("zoomOut2=" + this.m_optionValues.getZoomOut2());
        printWriter.println("minClusterH=" + this.m_optionValues.getMinClusterH());
        printWriter.println("minClusterW=" + this.m_optionValues.getMinClusterW());
        printWriter.println("movePrev=" + this.m_optionValues.getMovePrev());
        printWriter.println("moveNext=" + this.m_optionValues.getMoveNext());
        printWriter.println("cellPaint=" + this.m_optionValues.isGeneCountColorFlag());
        printWriter.println("geneCount2=" + this.m_optionValues.getGeneCountColorMinCount());
        printWriter.println("cellColor=" + this.m_optionValues.getGeneCountColor());
        printWriter.println("geneNameView=" + this.m_optionValues.isGeneNameView());
        printWriter.println("borderLineView=" + this.m_optionValues.isBorderLineView());
        printWriter.println("taxonomyView=" + this.m_optionValues.isTaxonomyView());
        printWriter.println("functionView=" + this.m_optionValues.isFunctionView());
        printWriter.println("lastDividerLocation1=" + this.m_optionValues.getLastDividerLocation1());
        printWriter.println("lastDividerLocation2=" + this.m_optionValues.getLastDividerLocation2());
        printWriter.println("borderLine=" + this.m_optionValues.getBorderLineColorString());
        printWriter.println("outgroup=" + this.m_optionValues.getOutgroupColorString());
        printWriter.println("ingroup=" + this.m_optionValues.getIngroupColorString());
        printWriter.println("useIngroupOutgroup=" + this.m_optionValues.isOutgroupAsIngroupFlag());
        printWriter.println("ingroupOutgroup=" + this.m_optionValues.getOutgroupIngroupColorString());
        printWriter.println("selecteLine1=" + this.m_optionValues.getSelectLine1ColorString());
        printWriter.println("selecteLine2=" + this.m_optionValues.getSelectLine2ColorString());
        printWriter.println("searchResult=" + this.m_optionValues.getSearchResultColorString());
        printWriter.println("ingroup2=" + this.m_optionValues.getIngroupFontColor());
        printWriter.println("outgroup2=" + this.m_optionValues.getOutgroupFontColor());
        printWriter.println("showTreeDistFromUpgma=" + this.m_optionValues.isShowTreeDistFromUpgma());
        printWriter.println("updateSiteURL=" + this.m_optionValues.getUpdateSiteURL());
        printWriter.println("sysInfoURL=" + this.m_optionValues.getSysInfoURL());
        printWriter.println("errorUploadURL=" + this.m_optionValues.getErrorUploadURL());
        printWriter.println("updateCheckInterval=" + this.m_optionValues.getUpdateCheckInterval());
        printWriter.println("coreGenomeUrl=" + this.m_optionValues.getCoreGenomeUrl());
        printWriter.println("coreGenomeOrthologRate=" + this.m_optionValues.getCoreGenomeAlignmentCondition().getOrthologRate());
        printWriter.println("coreGenomeConnectionRate=" + this.m_optionValues.getCoreGenomeAlignmentCondition().getConnectionRate());
        printWriter.println("coreGenomeUseSpGroup=" + this.m_optionValues.getCoreGenomeAlignmentCondition().isUseSpGroup());
        printWriter.println("coreGenomeMinSpCov=" + this.m_optionValues.getCoreGenomeAlignmentCondition().getMinSpCov());
        printWriter.println("coreGenomeSpCovRegCut=" + this.m_optionValues.getCoreGenomeAlignmentCondition().getSpCovRegCut());
        printWriter.println("coreGenomeOtherOptions=" + this.m_optionValues.getCoreGenomeAlignmentCondition().getOtherOptions());
        printWriter.println("coreGenomeWindowSize=" + this.m_optionValues.getCoreGenomeAlignmentCondition().getWindowSize());
        printWriter.println("domClustConditionName=" + this.m_optionValues.getDomClustConditionName());
        printWriter.println("neigborMaxDistSameGroup=" + this.m_optionValues.getNeighboringClustCondition().getMaxDistSameGroup());
        printWriter.println("neigborSearchClusterCount=" + this.m_optionValues.getNeighboringClustCondition().getSearchClusterCount());
        printWriter.println("neigborColorPattern=" + this.m_optionValues.getNeighborColorPatternStr());
        printWriter.println("clientVersionURL=" + this.m_optionValues.getClientVersionUrl());
        printWriter.println("showVersionUp=" + this.m_optionValues.isShowVersionUp());
        printWriter.println("seqDownloadURL=" + this.m_optionValues.getSeqDownloadURL());
        printWriter.println("showHiddenMenu=" + this.m_optionValues.isShowHiddenMenu());
        printWriter.println("publicColor=" + this.m_optionValues.getPublicColor());
        printWriter.println("enableDomclustParam=" + this.m_optionValues.getEnableDomclustParamString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkOption() throws IOException {
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            fileInputStream = new FileInputStream(Const.USER_OPTION_DAT_PATH);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            String string = bufferedReader.readLine();
            if (string == null || !string.equals(this.m_header) && !string.equals(this.m_oldHeader)) {
                throw new IOException("It is not an option file of RECOG.");
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }
}

