/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.organism;

import cgdp.recog.data.GenomeTbl;
import cgdp.recog.data.TaxonomyTbl;
import cgdp.recog.organism.MultiOrganism;
import cgdp.recog.organism.Organism;
import cgdp.recog.organism.OrganismComparator;
import cgdp.recog.organism.OrganismUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComboBox;

public class OrganismComboBox
extends JComboBox {
    private List organismList = new ArrayList();

    public OrganismComboBox() {
    }

    public OrganismComboBox(List list) {
        this.updateItemsByOrganismCode(list);
    }

    private void updateItemsByOrganismCode(List list) {
        this.organismList = this.getTargetOrganismList(list);
        this.updateItemsByOrganism(this.organismList);
    }

    private void updateItemsByOrganism(List list) {
        this.organismList = list;
        TaxonomyTbl taxonomyTbl = new TaxonomyTbl();
        taxonomyTbl.read();
        Collections.sort(list, new OrganismComparator(taxonomyTbl.getGenomeOrganismCodeIndexMap()));
        for (int i = 0; i < list.size(); ++i) {
            Organism organism = (Organism)list.get(i);
            this.addItem(this.getDisplayName(organism));
        }
    }

    public void updateValueByOrganismCode(List list) {
        String string = this.getSelectedOrganismCode();
        this.removeAllItems();
        this.updateItemsByOrganismCode(list);
        this.setSelectedOrganismCode(string);
    }

    public void updateValueByOrganism(List list) {
        String string = this.getSelectedOrganismCode();
        this.removeAllItems();
        this.updateItemsByOrganism(list);
        this.setSelectedOrganismCode(string);
    }

    private List getTargetOrganismList(List list) {
        GenomeTbl genomeTbl = new GenomeTbl();
        return genomeTbl.createOrganismList(list);
    }

    public void addOrganism(Organism organism) {
        this.organismList.add(organism);
        this.addItem(this.getDisplayName(organism));
    }

    public Organism getSelectedOrganism() {
        int n = this.getSelectedIndex();
        if (n == -1) {
            return null;
        }
        return (Organism)this.organismList.get(n);
    }

    public String getSelectedOrganismCode() {
        Organism organism = this.getSelectedOrganism();
        if (organism == null) {
            return null;
        }
        return organism.getOrganismCode();
    }

    public Set getSelectedOrganismCodeSet() {
        HashSet<String> hashSet = new HashSet<String>();
        Organism organism = this.getSelectedOrganism();
        if (organism instanceof MultiOrganism) {
            hashSet.addAll(((MultiOrganism)organism).getOrganismCodeList());
        } else {
            hashSet.add(organism.getOrganismCode());
        }
        return hashSet;
    }

    public void setSelectedOrganismCode(String string) {
        int n = OrganismUtil.indexOfOrganism(this.organismList, string);
        if (n != -1) {
            this.setSelectedIndex(n);
        }
    }

    private String getDisplayName(Organism organism) {
        String string = organism.getDisplayOrganismName();
        if (string.length() > 80) {
            string = string.substring(0, 81);
        }
        return string;
    }
}

