/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.organism;

import cgdp.recog.organism.DisplayOrganism;
import cgdp.recog.organism.Organism;
import cgdp.recog.organism.OrganismUtil;
import cgdp.recog.project.Project;
import cgdp.recog.system.property.ApplicationProperty;
import cgdp.recog.system.property.ApplicationPropertyAccessable;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class OrganismCondition
implements ApplicationPropertyAccessable {
    private static final String DELIMITER_ORGANISM = ";";
    private static final String DELIMITER_ELEMENT = ":";
    private List organismList = new ArrayList();
    private List viewOrganismList;
    private List ingroupOrganismList = new ArrayList();
    private List outgroupOrganismList = new ArrayList();
    private boolean syncOrganismSelect = true;

    private void setOrganismList(List list) {
        this.organismList = list;
    }

    public void updateOrganismList(List list) {
        this.setOrganismList(list);
        this.updateViewOrganismList(list);
    }

    public List getOrganismList() {
        return this.organismList;
    }

    private void setViewOrganismList(List list) {
        this.viewOrganismList = list;
    }

    public List getViewOrganismList() {
        return this.viewOrganismList;
    }

    public List getOrganismCodeList() {
        return OrganismUtil.getOrganismCodeList(this.organismList);
    }

    public List getTargetViewOrganismCodeList() {
        if (!this.isExistTargetViewOrganismList()) {
            return null;
        }
        return OrganismUtil.getOrganismCodeList(this.viewOrganismList);
    }

    public List getTargetViewOrganismList() {
        return this.viewOrganismList;
    }

    public boolean isExistTargetViewOrganismList() {
        return this.viewOrganismList != null;
    }

    public boolean isShowOrganismCode(String string) {
        for (DisplayOrganism displayOrganism : this.getViewOrganismList()) {
            if (!displayOrganism.equalsOrganismCode(string) || !displayOrganism.isOrganismColumnActive()) continue;
            return true;
        }
        return false;
    }

    public Organism getOrganism(String string) {
        return OrganismUtil.getOrganism(this.getOrganismList(), string);
    }

    public List getOrganismList(Collection collection) {
        return OrganismUtil.getOrganismList(this.getOrganismList(), collection);
    }

    public boolean isSyncOrganismSelect() {
        return this.syncOrganismSelect;
    }

    public void setSyncOrganismSelect(boolean bl) {
        this.syncOrganismSelect = bl;
    }

    private void updateViewOrganismList(List list) {
        if (CollectionUtil.isNull(list)) {
            this.viewOrganismList = null;
        } else {
            ArrayList<DisplayOrganism> arrayList = new ArrayList<DisplayOrganism>();
            for (DisplayOrganism displayOrganism : list) {
                if (!displayOrganism.isOrganismColumnActive()) continue;
                arrayList.add(displayOrganism);
            }
            this.viewOrganismList = arrayList;
        }
    }

    public void changeOrderOrganismList(List list) {
        ArrayList<DisplayOrganism> arrayList = new ArrayList<DisplayOrganism>();
        for (String string : list) {
            DisplayOrganism displayOrganism = (DisplayOrganism)this.getOrganism(string);
            if (displayOrganism == null) continue;
            arrayList.add(displayOrganism);
        }
        this.organismList = arrayList;
        this.updateViewOrganismList();
    }

    public void updateViewOrganismList() {
        ArrayList<DisplayOrganism> arrayList = new ArrayList<DisplayOrganism>();
        for (DisplayOrganism displayOrganism : this.getOrganismList()) {
            if (!displayOrganism.isOrganismColumnActive()) continue;
            arrayList.add(displayOrganism);
        }
        this.viewOrganismList = arrayList;
    }

    public void clear() {
        this.organismList.clear();
        this.viewOrganismList = null;
        this.ingroupOrganismList.clear();
        this.outgroupOrganismList.clear();
    }

    public String getCategory() {
        return "PPM_ORGANISM_COLUMN";
    }

    public List getPropertyList(Project project, String string) {
        ArrayList<ApplicationProperty> arrayList = new ArrayList<ApplicationProperty>();
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "PPM_ORGANISM_COLUMNCondition", OrganismCondition.condition2Str(this.getOrganismList())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "PPM_ORGANISM_COLUMNSyncOrganismSelect", String.valueOf(this.isSyncOrganismSelect())));
        return arrayList;
    }

    public int getPropertyType() {
        return 2;
    }

    public void updateProperty(Map map, Project project, String string) {
        if (map.containsKey("PPM_ORGANISM_COLUMNCondition")) {
            String string2 = (String)map.get("PPM_ORGANISM_COLUMNCondition");
            this.updateOrganismList(string2);
        } else if (map.containsKey("PPM_ORGANISM_COLUMNSyncOrganismSelect")) {
            String string3 = (String)map.get("PPM_ORGANISM_COLUMNSyncOrganismSelect");
            boolean bl = true;
            if (StringTool.isNull(string3)) {
                bl = new Boolean(string3);
            }
            this.setSyncOrganismSelect(bl);
        }
    }

    private static String condition2Str(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (DisplayOrganism displayOrganism : list) {
            stringBuffer.append(displayOrganism.getOrganismCode());
            stringBuffer.append(DELIMITER_ELEMENT);
            stringBuffer.append(displayOrganism.isOrganismColumnActive());
            stringBuffer.append(DELIMITER_ELEMENT);
            stringBuffer.append(displayOrganism.isShowControl());
            if (n != list.size() - 1) {
                stringBuffer.append(DELIMITER_ORGANISM);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private void updateOrganismList(String string) {
        if (StringTool.isNull(string)) {
            return;
        }
        Vector vector = StringTool.splitString(string, DELIMITER_ORGANISM);
        ArrayList<DisplayOrganism> arrayList = new ArrayList<DisplayOrganism>();
        HashSet<String> hashSet = new HashSet<String>();
        for (Object object : vector) {
            boolean bl;
            Object object2 = StringTool.splitString((String)object, DELIMITER_ELEMENT);
            String string2 = (String)((Vector)object2).get(0);
            DisplayOrganism displayOrganism = (DisplayOrganism)this.getOrganism(string2);
            if (displayOrganism == null) continue;
            if (((Vector)object2).size() >= 3) {
                bl = new Boolean((String)((Vector)object2).get(1));
                boolean bl2 = new Boolean((String)((Vector)object2).get(2));
                if (displayOrganism != null) {
                    displayOrganism.setOrganismColumnActive(bl);
                    displayOrganism.setShowControl(bl2);
                    arrayList.add(displayOrganism);
                }
            } else if (((Vector)object2).size() == 2) {
                bl = new Boolean((String)((Vector)object2).get(1));
                if (displayOrganism != null) {
                    displayOrganism.setOrganismColumnActive(bl);
                    arrayList.add(displayOrganism);
                }
            } else if (((Vector)object2).size() == 1 && displayOrganism != null) {
                arrayList.add(displayOrganism);
            }
            hashSet.add(string2);
        }
        ArrayList arrayList2 = new ArrayList();
        for (Object object2 : this.getOrganismList()) {
            if (hashSet.contains(((Organism)object2).getOrganismCode())) continue;
            arrayList2.add(object2);
        }
        arrayList.addAll(arrayList2);
        this.organismList.removeAll(arrayList);
        this.organismList.addAll(0, arrayList);
        this.updateViewOrganismList(arrayList);
    }

    public List getShowControlOrganismList() {
        ArrayList<DisplayOrganism> arrayList = new ArrayList<DisplayOrganism>();
        for (DisplayOrganism displayOrganism : this.getOrganismList()) {
            if (!displayOrganism.isShowControl()) continue;
            arrayList.add(displayOrganism);
        }
        return arrayList;
    }

    public void addOrganismColumnSet(Collection collection) {
        for (String string : collection) {
            this.addOrganismColumn(string);
        }
    }

    private void addOrganismColumn(String string) {
        DisplayOrganism displayOrganism = (DisplayOrganism)this.getOrganism(string);
        if (displayOrganism != null) {
            displayOrganism.setShowControl(true);
            displayOrganism.setOrganismColumnActive(true);
        }
    }

    public void removeOrganismColumnC(Collection collection) {
        for (String string : collection) {
            this.removeOrganism(string);
        }
    }

    private void removeOrganism(String string) {
        DisplayOrganism displayOrganism = (DisplayOrganism)this.getOrganism(string);
        if (displayOrganism != null) {
            displayOrganism.setShowControl(false);
            displayOrganism.setOrganismColumnActive(false);
        }
    }

    public void replaceMergeOrganism(List list, Organism organism) {
        List list2 = this.getOrganismList(list);
        Organism organism2 = (Organism)list2.get(0);
        Organism organism3 = OrganismUtil.convertDisplayOrganism(organism);
        int n = this.getOrganismList().indexOf(organism2);
        this.organismList.add(n, organism3);
        this.organismList.removeAll(list2);
        n = this.ingroupOrganismList.indexOf(organism2);
        if (n != -1) {
            this.ingroupOrganismList.add(n, organism3);
            this.ingroupOrganismList.removeAll(list2);
        }
        if ((n = this.outgroupOrganismList.indexOf(organism2)) != -1) {
            this.outgroupOrganismList.add(n, organism3);
            this.outgroupOrganismList.removeAll(list2);
        }
        if ((n = this.getViewOrganismList().indexOf(organism2)) != -1) {
            this.viewOrganismList.add(n, organism3);
            this.viewOrganismList.removeAll(list2);
        }
    }

    public void replaceSplitOrganism(String string, List list) {
        Organism organism = this.getOrganism(string);
        List list2 = OrganismUtil.convertDisplayOrganismList(list);
        int n = this.getOrganismList().indexOf(organism);
        this.organismList.addAll(n, list2);
        this.organismList.remove(organism);
        n = this.ingroupOrganismList.indexOf(organism);
        if (n != -1) {
            this.ingroupOrganismList.addAll(n, list2);
            this.ingroupOrganismList.remove(organism);
        }
        if ((n = this.outgroupOrganismList.indexOf(organism)) != -1) {
            this.outgroupOrganismList.addAll(n, list2);
            this.outgroupOrganismList.remove(organism);
        }
        if ((n = this.getViewOrganismList().indexOf(organism)) != -1) {
            this.viewOrganismList.addAll(n, list2);
            this.viewOrganismList.remove(organism);
        }
    }

    public void setIngroupOrganismList(List list) {
        this.ingroupOrganismList = list;
    }

    public void setOutgroupOrganismList(List list) {
        this.outgroupOrganismList = list;
    }

    public List getIngroupOrganismCodeList() {
        return OrganismUtil.getOrganismCodeList(this.ingroupOrganismList);
    }

    public List getOutgroupOrganismCodeList() {
        return OrganismUtil.getOrganismCodeList(this.outgroupOrganismList);
    }

    public boolean isExistIngroup() {
        return !CollectionUtil.isNull(this.ingroupOrganismList);
    }

    public boolean isExistOutgroup() {
        return !CollectionUtil.isNull(this.outgroupOrganismList);
    }

    public int getIngroupSize() {
        return this.ingroupOrganismList.size();
    }

    public int getOutgroupSize() {
        return this.outgroupOrganismList.size();
    }
}

