/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.organism;

import cgdp.recog.organism.OrganismNameType;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class OrganismNamePanel
extends JPanel {
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    private JRadioButton nameNormalButton;
    private JRadioButton nameAbbrevButton;
    private JCheckBox addStrainCheckBox;
    private int alignment = 1;

    public OrganismNamePanel() {
        this.init();
    }

    public OrganismNamePanel(int n) {
        this.alignment = n;
        this.init();
    }

    private void init() {
        this.setBorder(BorderFactory.createTitledBorder("Organism Name"));
        this.nameNormalButton = new JRadioButton("Full");
        this.nameAbbrevButton = new JRadioButton("Abbreviation");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.nameNormalButton);
        buttonGroup.add(this.nameAbbrevButton);
        this.addStrainCheckBox = new JCheckBox("Show Strain");
        this.setLayout(new GridBagLayout());
        if (this.alignment == 1) {
            this.add((Component)this.nameNormalButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.nameAbbrevButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.addStrainCheckBox, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            this.add((Component)this.nameNormalButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 3, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.nameAbbrevButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 3, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.addStrainCheckBox, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 3, new Insets(0, 5, 0, 5), 0, 0));
        }
    }

    public void setOrganismNameType(int n) {
        if (OrganismNameType.isOrganismNameTypeNormal(n)) {
            this.nameNormalButton.setSelected(true);
        } else {
            this.nameAbbrevButton.setSelected(true);
        }
    }

    public int getOrganismNameType() {
        if (this.nameNormalButton.isSelected()) {
            return 1;
        }
        return 2;
    }

    public void setAddStrainToName(boolean bl) {
        this.addStrainCheckBox.setSelected(bl);
    }

    public boolean isAddStrainToName() {
        return this.addStrainCheckBox.isSelected();
    }
}

