/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.organism;

import cgdp.recog.coregenome.InOutgroupTableCellRenderer;
import cgdp.recog.organism.CandidateOrganismTableModel;
import cgdp.recog.organism.Organism;
import cgdp.recog.organism.TargetOrganismTableModel;
import cgdp.recog.util.AbstractListSelectTableModel;
import cgdp.recog.util.LabelTableCellRenderer;
import cgdp.recog.util.ListSelectPanel;
import cgdp.recog.util.RadioButtonCellEditor;
import cgdp.recog.util.RadioButtonCellRenderer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTable;

public class OrganismSelectPanel
extends JPanel {
    private ListSelectPanel organismPanel;
    private CandidateOrganismTableModel candidateOrganismTableModel;
    private TargetOrganismTableModel targetOrganismTableModel;

    public OrganismSelectPanel(boolean bl, boolean bl2) {
        this(new ArrayList(), new ArrayList(), null, bl, bl2, true);
    }

    public OrganismSelectPanel(boolean bl, boolean bl2, boolean bl3) {
        this(new ArrayList(), new ArrayList(), null, bl, bl2, bl3);
    }

    public OrganismSelectPanel(List list, List list2, Organism organism) {
        this(list, list2, organism, true, true, true);
    }

    public OrganismSelectPanel(List list, List list2, Organism organism, boolean bl) {
        this.init(list, list2, organism, bl, true, true);
    }

    private OrganismSelectPanel(List list, List list2, Organism organism, boolean bl, boolean bl2, boolean bl3) {
        this.init(list, list2, organism, bl, bl2, bl3);
    }

    private void init(List list, List list2, Organism organism, boolean bl, boolean bl2, boolean bl3) {
        if (bl3) {
            this.setBorder(BorderFactory.createTitledBorder("Organism"));
        }
        ArrayList arrayList = new ArrayList(list);
        arrayList.removeAll(list2);
        this.candidateOrganismTableModel = new CandidateOrganismTableModel(arrayList);
        this.targetOrganismTableModel = new TargetOrganismTableModel(new ArrayList(list2), organism);
        this.targetOrganismTableModel.setShowReferenceGenome(bl);
        this.organismPanel = new ListSelectPanel(this.candidateOrganismTableModel, this.targetOrganismTableModel, bl2){

            protected String getSelectToolTipText(MouseEvent mouseEvent) {
                return OrganismSelectPanel.getToolTipString(mouseEvent, OrganismSelectPanel.this.targetOrganismTableModel);
            }

            protected String getCandidateToolTipText(MouseEvent mouseEvent) {
                return OrganismSelectPanel.getToolTipString(mouseEvent, OrganismSelectPanel.this.candidateOrganismTableModel);
            }
        };
        this.organismPanel.setCandidateColumnWidth(0, 30);
        this.organismPanel.setSelectColumnWidth(0, 30);
        this.organismPanel.setCandidateSize(200, 100);
        this.organismPanel.setSelectSize(230, 100);
        this.organismPanel.setCandidateRenderer(0, new InOutgroupTableCellRenderer());
        this.organismPanel.setSelectRenderer(0, new InOutgroupTableCellRenderer());
        this.organismPanel.setCandidateRenderer(1, new LabelTableCellRenderer());
        this.organismPanel.setSelectRenderer(1, new LabelTableCellRenderer());
        if (bl) {
            this.organismPanel.setSelectColumnWidth(2, 30);
            this.organismPanel.setSelectRenderer(2, new RadioButtonCellRenderer());
            this.organismPanel.setSelectEditor(2, new RadioButtonCellEditor());
        }
        this.setLayout(new GridBagLayout());
        this.add((Component)this.organismPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
    }

    public Organism getReferenceOrganism() {
        return this.targetOrganismTableModel.getReferenceOrganism();
    }

    public void setReferenceOrganism(Organism organism) {
        this.targetOrganismTableModel.setReferenceOrganism(organism);
    }

    public List getCandidateOrganismList() {
        return this.candidateOrganismTableModel.getDataList();
    }

    public List getCandidateOrganismCodeList() {
        List list = this.getCandidateOrganismList();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Organism organism : list) {
            arrayList.add(organism.getOrganismCode());
        }
        return arrayList;
    }

    public List getTargetOrganismList() {
        return this.targetOrganismTableModel.getDataList();
    }

    public List getTargetOrganismCodeList() {
        List list = this.getTargetOrganismList();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Organism organism : list) {
            arrayList.add(organism.getOrganismCode());
        }
        return arrayList;
    }

    public boolean isExistViewOrganism() {
        return this.targetOrganismTableModel.getRowCount() != 0;
    }

    private static String getToolTipString(MouseEvent mouseEvent, AbstractListSelectTableModel abstractListSelectTableModel) {
        JTable jTable = (JTable)mouseEvent.getSource();
        int n = jTable.rowAtPoint(mouseEvent.getPoint());
        int n2 = jTable.columnAtPoint(mouseEvent.getPoint());
        if (n2 != 1) {
            return null;
        }
        List list = abstractListSelectTableModel.getDataList();
        Organism organism = (Organism)list.get(n);
        return "<html>" + organism.getName() + " " + organism.getStrain() + "</html>";
    }

    public void setEnableComponents(boolean bl) {
        this.organismPanel.setEnableComponents(bl);
    }

    public void updateValue(List list, List list2) {
        ArrayList arrayList = new ArrayList(list);
        arrayList.removeAll(list2);
        this.targetOrganismTableModel.setDataList(list2);
        this.candidateOrganismTableModel.setDataList(arrayList);
        this.organismPanel.setCandidateRenderer(0, new InOutgroupTableCellRenderer());
        this.organismPanel.setSelectRenderer(0, new InOutgroupTableCellRenderer());
    }
}

