/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.organism;

import cgdp.recog.organism.Organism;
import cgdp.recog.organism.OrganismUtil;
import cgdp.recog.search.GeneSearchCondition;
import cgdp.recog.search.GeneSearchPanel;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class OrganismSplitDialog
extends AbstractApplyDialog {
    private static OrganismSplitDialog ORGANISM_SPLIT_DIALOG;
    private static final String TITLE = "Split Organism";
    private List conditionPanelList = new ArrayList();
    private JPanel conditionPanel;
    private JButton addConditionButton;
    private JButton clearConditionButton;
    private Organism organism;

    private OrganismSplitDialog(Frame frame) {
        super(frame);
        this.createComponents();
    }

    public static void createInstance(Frame frame) {
        ORGANISM_SPLIT_DIALOG = new OrganismSplitDialog(frame);
    }

    public static OrganismSplitDialog getInstance() {
        return new OrganismSplitDialog((Frame)ORGANISM_SPLIT_DIALOG.getParent());
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.conditionPanel = new JPanel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.conditionPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(15, 15, 5, 15), 0, 0));
        this.getContentPane().add((Component)this.createControlButtonPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 15, 5, 15), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 15, 15, 15), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void updateGUI() {
        this.updateConditionPanel();
        this.pack();
    }

    private void updateConditionPanel() {
        this.conditionPanel.removeAll();
        this.conditionPanel.setLayout(new GridBagLayout());
        int n = 0;
        for (JPanel jPanel : this.conditionPanelList) {
            this.conditionPanel.add((Component)jPanel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 15, 5, 15), 0, 0));
            ++n;
        }
        this.conditionPanel.add((Component)this.createOtherPanel(), new GridBagConstraints(0, n + 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 15, 5, 15), 0, 0));
    }

    private void initConditionPanel() {
        this.conditionPanelList.clear();
        this.conditionPanelList.add(this.createConditionPanel(0));
    }

    public void updateValue(String string) {
        this.organism = OrganismUtil.getOrganism(string);
        this.clearConditionPanel();
    }

    private void addConditionPanel() {
        int n = this.conditionPanelList.size();
        this.conditionPanelList.add(this.createConditionPanel(n));
        this.updateGUI();
    }

    private void clearConditionPanel() {
        this.initConditionPanel();
        this.updateGUI();
    }

    private JPanel createConditionPanel(int n) {
        return new ConditionPanel(n);
    }

    private JPanel createOtherPanel() {
        JLabel jLabel = new JLabel(this.organism.getNameForTaxonomy() + "-" + (this.conditionPanelList.size() + 1));
        JLabel jLabel2 = new JLabel("Other");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 10), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createControlButtonPanel() {
        this.addConditionButton = new JButton("Add Condition");
        this.addConditionButton.addActionListener(this);
        this.clearConditionButton = new JButton("Clear Condition");
        this.clearConditionButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.addConditionButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.clearConditionButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    public List getSearchConditionList() {
        ArrayList<GeneSearchCondition> arrayList = new ArrayList<GeneSearchCondition>();
        for (ConditionPanel conditionPanel : this.conditionPanelList) {
            GeneSearchCondition geneSearchCondition = conditionPanel.getCondition();
            arrayList.add(geneSearchCondition);
        }
        return arrayList;
    }

    protected boolean check() {
        if (!this.isExistCondition()) {
            MessageManager.showErrorMessage((Component)this, "Input search condition.");
            return false;
        }
        return true;
    }

    private boolean isExistCondition() {
        List list = this.getSearchConditionList();
        for (GeneSearchCondition geneSearchCondition : list) {
            if (geneSearchCondition == null || !geneSearchCondition.isExistCondition()) continue;
            return true;
        }
        return false;
    }

    protected boolean apply() {
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.addConditionButton) {
            this.addConditionPanel();
        } else if (actionEvent.getSource() == this.clearConditionButton) {
            this.clearConditionPanel();
        }
    }

    private class SearchConditionDialog
    extends AbstractApplyDialog {
        private GeneSearchPanel geneSearchPanel;

        public SearchConditionDialog(Dialog dialog) {
            super(dialog);
            this.createComponents();
        }

        private void createComponents() {
            this.setTitle(OrganismSplitDialog.TITLE);
            this.setModal(true);
            this.geneSearchPanel = new GeneSearchPanel(this, null);
            this.getContentPane().setLayout(new GridBagLayout());
            this.getContentPane().add((Component)this.geneSearchPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(15, 15, 5, 15), 0, 0));
            this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 15, 15, 15), 0, 0));
            this.pack();
            this.setLocationRelativeTo(this.getParent());
        }

        public void updateValue(GeneSearchCondition geneSearchCondition) {
            this.geneSearchPanel.updateValue(OrganismSplitDialog.this.organism.getOrganismCode(), geneSearchCondition);
            this.geneSearchPanel.setDefaultLocalSearch(true);
        }

        public GeneSearchCondition getCondition() {
            return this.geneSearchPanel.getCondition();
        }

        protected boolean apply() {
            return true;
        }
    }

    private class ConditionPanel
    extends JPanel
    implements ActionListener {
        private int count;
        private JButton conditionButton;
        private GeneSearchCondition condition;

        public ConditionPanel(int n) {
            this.count = n;
            this.createComponents();
        }

        private void createComponents() {
            JLabel jLabel = new JLabel(OrganismSplitDialog.this.organism.getNameForTaxonomy() + "-" + (this.count + 1));
            this.conditionButton = new JButton("Condition...");
            this.conditionButton.addActionListener(this);
            this.setLayout(new GridBagLayout());
            this.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 10), 0, 0));
            this.add((Component)this.conditionButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }

        private void showGeneSearchConditionDialog() {
            SearchConditionDialog searchConditionDialog = new SearchConditionDialog(OrganismSplitDialog.this);
            searchConditionDialog.updateValue(this.condition);
            searchConditionDialog.setVisible(true);
            if (searchConditionDialog.isCanceled()) {
                return;
            }
            this.condition = searchConditionDialog.getCondition();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.conditionButton) {
                this.showGeneSearchConditionDialog();
            }
        }

        public GeneSearchCondition getCondition() {
            return this.condition;
        }
    }
}

