/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.organism;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.coregenome.GeneComparator;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.DataManager;
import cgdp.recog.data.Gene;
import cgdp.recog.data.GeneExporter;
import cgdp.recog.data.GeneTbl;
import cgdp.recog.organism.ModifiedOrganismManager;
import cgdp.recog.organism.Organism;
import cgdp.recog.organism.OrganismSplitCondition;
import cgdp.recog.organism.SplitOrganism;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.DummyProgressComponent;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.search.GeneLocalSearchExecuter;
import cgdp.recog.search.GeneSearchCondition;
import cgdp.recog.search.KeywordSearchUtil;
import cgdp.recog.system.property.ApplicationPropertyFacade;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.GeneUtil;
import cgdp.recog.util.MapUtil;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class OrganismSplitExecuter
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(OrganismSplitExecuter.class);
    private Component parent;
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;
    private OrganismSplitCondition condition;
    private boolean existSearchResult = false;

    public OrganismSplitExecuter(Component component, MediatorImpl mediatorImpl, ClusterTbl clusterTbl, OrganismSplitCondition organismSplitCondition) {
        this.parent = component;
        this.mediator = mediatorImpl;
        this.clusterTbl = clusterTbl;
        this.condition = organismSplitCondition;
    }

    public void execute(ProgressImpl progressImpl) {
        try {
            progressImpl.setTotal(this.condition.getSearchConditionList().size() + 4);
            List list = this.createSplitOrganismList();
            SplitOrganism splitOrganism = new SplitOrganism(this.condition.getOrganism(), list.size());
            splitOrganism.setOther(true);
            progressImpl.increment();
            HashSet<SplitOrganism> hashSet = new HashSet<SplitOrganism>();
            HashSet hashSet2 = new HashSet();
            HashMap hashMap = new HashMap();
            int n = 0;
            Object object = this.condition.getSearchConditionList().iterator();
            while (object.hasNext()) {
                if (progressImpl.isCanceled()) {
                    this.setCancel(true);
                    return;
                }
                progressImpl.increment();
                SplitOrganism splitOrganism2 = (SplitOrganism)list.get(n);
                GeneSearchCondition geneSearchCondition = (GeneSearchCondition)object.next();
                if (geneSearchCondition == null || !geneSearchCondition.isExistCondition()) {
                    hashSet.add(splitOrganism2);
                    System.err.println(splitOrganism2);
                    continue;
                }
                ArrayList<List> arrayList = new ArrayList<List>();
                arrayList.add(geneSearchCondition.getConditionItemList());
                GeneLocalSearchExecuter geneLocalSearchExecuter = new GeneLocalSearchExecuter(this.parent, this.mediator, this.clusterTbl, this.clusterTbl.getClusterList(), geneSearchCondition.getOrganismCodeSet(), arrayList);
                geneLocalSearchExecuter.execute(new DummyProgressComponent());
                if (geneLocalSearchExecuter.isError()) {
                    this.setError(true);
                    this.setErrorMessages(geneLocalSearchExecuter.getErrorMessages());
                    return;
                }
                List list2 = geneLocalSearchExecuter.getSearchResultList();
                if (CollectionUtil.isNull(list2)) {
                    hashSet.add(splitOrganism2);
                    System.err.println(splitOrganism2);
                    ++n;
                    continue;
                }
                HashSet hashSet3 = new HashSet(KeywordSearchUtil.getOrganismLocusTagWithoutDomainList(list2));
                hashSet3.removeAll(hashSet2);
                if (CollectionUtil.isNull(hashSet3)) {
                    hashSet.add(splitOrganism2);
                    ++n;
                    continue;
                }
                hashMap.put(splitOrganism2, hashSet3);
                hashSet2.addAll(hashSet3);
                ++n;
            }
            if (MapUtil.isNull(hashMap)) {
                return;
            }
            list.removeAll(hashSet);
            this.existSearchResult = true;
            this.condition.setSplitOrganismList(list);
            this.condition.setOrganismLocusTagSetMap(hashMap);
            object = this.createOrganismGeneListMap(list, splitOrganism);
            if (!CollectionUtil.isNull((List)object.get(splitOrganism))) {
                this.condition.setOtherOrganism(splitOrganism);
            } else {
                this.condition.setOtherOrganism(null);
            }
            if (progressImpl.isCanceled()) {
                this.setCancel(true);
                return;
            }
            progressImpl.increment();
            this.clusterTbl.splitOrganism(this.condition);
            progressImpl.increment();
            DataManager.createDomClustDataDir(this.clusterTbl.getClusterId());
            this.createChromosomeFile(list, splitOrganism);
            this.createGeneFile((Map)object);
            ApplicationPropertyFacade.saveProperty(this.clusterTbl.getClusterId(), ModifiedOrganismManager.getInstance());
            progressImpl.increment();
        }
        catch (Exception exception) {
            String string = "Fail to split organism. " + this.condition.getOrganismCode();
            logger.warn(string, exception);
            this.setError(true);
            this.setErrorMessage(string);
        }
    }

    private void createChromosomeFile(List list, SplitOrganism splitOrganism) throws Exception {
        Object object2;
        String string = DataManager.getChromosomeFilePath(this.condition.getOrganismCode());
        String string2 = FileUtil.readFile(string);
        for (Object object2 : list) {
            String string3 = string2.replaceAll("\t" + this.condition.getOrganismCode() + "\t", "\t" + ((Organism)object2).getOrganismCode() + "\t");
            String string4 = DataManager.getDomClustChromosomeFilePath(this.clusterTbl.getClusterId(), ((Organism)object2).getOrganismCode());
            FileUtil.outputFile(string3, string4);
        }
        String string5 = DataManager.getDomClustChromosomeFilePath(this.clusterTbl.getClusterId(), splitOrganism.getOrganismCode());
        object2 = string2.replaceAll("\t" + this.condition.getOrganismCode() + "\t", "\t" + splitOrganism.getOrganismCode() + "\t");
        FileUtil.outputFile((String)object2, string5);
    }

    private Map createOrganismGeneListMap(List list, SplitOrganism splitOrganism) throws Exception {
        Object object;
        Object object2;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        GeneTbl geneTbl = new GeneTbl(this.condition.getOrganism());
        geneTbl.read();
        ArrayList arrayList = new ArrayList(geneTbl.values());
        Map map = GeneUtil.createGeneMap(arrayList);
        HashSet hashSet = new HashSet();
        for (Object object3 : list) {
            Object object4 = this.condition.getOrganismLocusTagSet((Organism)object3);
            object2 = new ArrayList();
            object = object4.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                Gene gene = (Gene)map.get(string);
                if (gene == null) continue;
                gene.setOrganism(((Organism)object3).getOrganismCode());
                object2.add(gene);
            }
            Collections.sort(object2, new GeneComparator(2));
            hashMap.put(object3, object2);
            hashSet.addAll(object4);
        }
        ArrayList arrayList2 = new ArrayList();
        for (Object object4 : arrayList) {
            object2 = GeneUtil.createOrganismLocusTagKey(splitOrganism.getParentOrganism().getOrganismCode(), ((Gene)object4).getLocusTagWithDomainNo());
            if (hashSet.contains(object2) || CollectionUtil.isNull((Collection)(object = this.clusterTbl.getClusterList(((Gene)object4).getOrganism(), ((Gene)object4).getLocusTag())))) continue;
            ((Gene)object4).setOrganism(splitOrganism.getOrganismCode());
            arrayList2.add(object4);
        }
        Collections.sort(arrayList2, new GeneComparator(2));
        hashMap.put(splitOrganism, arrayList2);
        return hashMap;
    }

    private void createGeneFile(Map map) throws Exception {
        for (SplitOrganism splitOrganism : map.keySet()) {
            List list = (List)map.get(splitOrganism);
            if (CollectionUtil.isNull(list)) continue;
            String string = DataManager.getDomClustGeneFilePath(this.clusterTbl.getClusterId(), splitOrganism.getOrganismCode());
            GeneExporter geneExporter = new GeneExporter(string, list);
            geneExporter.execute();
        }
    }

    private List createSplitOrganismList() {
        Organism organism = this.condition.getOrganism();
        ArrayList<SplitOrganism> arrayList = new ArrayList<SplitOrganism>();
        int n = 0;
        for (int i = 0; i < this.condition.getSearchConditionList().size(); ++i) {
            SplitOrganism splitOrganism = new SplitOrganism(organism, n);
            arrayList.add(splitOrganism);
            ++n;
        }
        return arrayList;
    }

    public void done() {
        if (this.isCancel()) {
            return;
        }
        if (this.isError()) {
            MessageManager.showErrorMessage(this.parent, this.getErrorMessages());
            return;
        }
        if (!this.existSearchResult) {
            MessageManager.showMessage(this.parent, "Organism can't split by this condition.");
            return;
        }
        this.mediator.resetMainWindowNotClearView();
        this.mediator.updateTaxonomyTree();
        this.mediator.updateOrganismColumnTree();
        this.mediator.updatePatternTree();
        this.mediator.updateOrganismSetTree();
    }
}

