/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.pattern;

import cgdp.recog.pattern.Pattern;
import cgdp.recog.pattern.PatternFacade;
import cgdp.recog.project.Project;
import cgdp.recog.system.property.ApplicationProperty;
import cgdp.recog.system.property.ApplicationPropertyAccessable;
import cgdp.recog.util.ApplicationLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PatternGroup
implements ApplicationPropertyAccessable {
    private static final ApplicationLogger logger = new ApplicationLogger(PatternGroup.class);
    private String domClustId;
    private List organismCodeList = new ArrayList();
    private List patternList = new ArrayList();

    public void clear() {
        this.domClustId = null;
        this.organismCodeList.clear();
        this.patternList.clear();
    }

    public String getDomClustId() {
        return this.domClustId;
    }

    public void setDomClustId(String string) {
        this.domClustId = string;
    }

    public void setOrganismCodeList(List list) {
        this.organismCodeList = list;
    }

    private List getOrganismCodeList() {
        return this.organismCodeList;
    }

    public Set getOrganismCodeSet() {
        return new HashSet(this.getOrganismCodeList());
    }

    public void addPattern(Pattern pattern) {
        this.patternList.add(pattern);
    }

    List getPatternList() {
        return this.patternList;
    }

    private void setPatternList(List list) {
        this.patternList = list;
    }

    public void removePattern(Set set) {
        this.patternList.removeAll(set);
    }

    public void removePattern(Pattern pattern) {
        this.patternList.remove(pattern);
    }

    public void replacePattern(Pattern pattern, Pattern pattern2) {
        int n = this.indexOf(pattern);
        if (n != -1) {
            this.patternList.set(n, pattern2);
        }
    }

    private int indexOf(Pattern pattern) {
        int n = 0;
        for (Pattern pattern2 : this.patternList) {
            if (pattern2.equalsName(pattern)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public String getCategory() {
        return "Pattern";
    }

    public List getPropertyList(Project project, String string) {
        try {
            PatternFacade.savePatternList(this);
        }
        catch (IOException iOException) {
            logger.warn("Fail to save pattern file. Project = " + project.getProjectName(), iOException);
        }
        ArrayList<ApplicationProperty> arrayList = new ArrayList<ApplicationProperty>();
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "PatternCondition", "pattern"));
        return arrayList;
    }

    public int getPropertyType() {
        return 2;
    }

    public void updateProperty(Map map, Project project, String string) {
        try {
            List list = PatternFacade.getPatternList(this.getDomClustId(), this.getOrganismCodeSet());
            this.setPatternList(list);
        }
        catch (IOException iOException) {
            logger.warn("Fail to load pattern file. Project = " + project.getProjectName(), iOException);
        }
    }
}

