/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.pattern;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.calc.CoefCalcItem;
import cgdp.recog.controltree.ControlTitleNode;
import cgdp.recog.controltree.ControlTitleType;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.pattern.Pattern;
import cgdp.recog.pattern.PatternDeleteItem;
import cgdp.recog.pattern.PatternEditItem;
import cgdp.recog.pattern.PatternGroup;
import cgdp.recog.pattern.PatternTreeNode;
import cgdp.recog.tree.AbstractTreeController;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class PatternTreeController
extends AbstractTreeController {
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;

    public PatternTreeController(MediatorImpl mediatorImpl) {
        this.mediator = mediatorImpl;
    }

    public void createTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (this.clusterTbl == null) {
            return;
        }
        PatternGroup patternGroup = this.clusterTbl.getPatternGroup();
        for (Pattern pattern : patternGroup.getPatternList()) {
            PatternTreeNode patternTreeNode = new PatternTreeNode(pattern);
            defaultMutableTreeNode.add(patternTreeNode);
        }
    }

    public JPopupMenu createPopupMenu(JTree jTree, ActionListener actionListener) {
        if (this.clusterTbl == null) {
            return null;
        }
        TreePath[] treePathArray = jTree.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            return null;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (this.isShowPatternMenu(treePathArray)) {
            PatternTreeNode patternTreeNode = (PatternTreeNode)treePathArray[0].getLastPathComponent();
            Pattern pattern = patternTreeNode.getPattern();
            Set set = this.getPatternSet(treePathArray);
            jPopupMenu.add(new CoefCalcItem(actionListener, this.mediator, pattern));
            jPopupMenu.addSeparator();
            jPopupMenu.add(new PatternEditItem(actionListener, this.mediator, pattern));
            jPopupMenu.add(new PatternDeleteItem(actionListener, this.mediator, set));
        }
        return jPopupMenu;
    }

    private Set getPatternSet(TreePath[] treePathArray) {
        HashSet<Pattern> hashSet = new HashSet<Pattern>();
        for (int i = 0; i < treePathArray.length; ++i) {
            PatternTreeNode patternTreeNode = (PatternTreeNode)treePathArray[i].getLastPathComponent();
            hashSet.add(patternTreeNode.getPattern());
        }
        return hashSet;
    }

    private boolean isShowPatternMenu(TreePath[] treePathArray) {
        for (int i = 0; i < treePathArray.length; ++i) {
            if (treePathArray[i].getPathCount() != 3) {
                return false;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getPathComponent(1);
            if (!(defaultMutableTreeNode instanceof ControlTitleNode)) {
                return false;
            }
            ControlTitleNode controlTitleNode = (ControlTitleNode)defaultMutableTreeNode;
            if (ControlTitleType.isPattern(controlTitleNode.getControlTitleType())) continue;
            return false;
        }
        return true;
    }

    public void setClusterTbl(ClusterTbl clusterTbl) {
        this.clusterTbl = clusterTbl;
    }

    public void actionAfterDoubleClick(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode instanceof PatternTreeNode) {
            PatternTreeNode patternTreeNode = (PatternTreeNode)defaultMutableTreeNode;
            this.mediator.showCoefCalcDialog(patternTreeNode.getPattern());
        }
    }
}

