/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.ppm;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.ppm.PPMContext;
import cgdp.recog.ppm.PPMRenderer;
import java.util.List;
import javax.swing.BoundedRangeModel;

public abstract class AbstractPPMRenderer
implements PPMRenderer {
    private PPMContext ppmContext;

    public AbstractPPMRenderer(PPMContext pPMContext) {
        this.ppmContext = pPMContext;
    }

    protected int caclStartRow(List list) {
        int n = 0;
        if (list.size() > 0 && list.size() > this.getRows() && this.getMediator().isClusterVScrollBarVisible()) {
            n = (int)(this.ppmContext.getViewportY0() + 0.5);
            int n2 = (int)this.ppmContext.getCenterY();
            if (n2 > list.size()) {
                n2 = this.getRows() / 2 + n;
            }
            if (n + this.getRows() > list.size()) {
                n = list.size() - this.getRows();
            }
            if (n + this.getRows() - 1 < n2) {
                n = n2 - this.getRows() + 1;
            }
        }
        return n < 0 ? 0 : n;
    }

    protected int _caclStartRow(List list) {
        int n = 0;
        if (list.size() > 0 && list.size() > this.getRows() && this.getMediator().isClusterVScrollBarVisible()) {
            BoundedRangeModel boundedRangeModel = (BoundedRangeModel)this.getMediator().getClusterVScrollBarModel();
            n = boundedRangeModel.getValue() + this.getRows() > list.size() ? list.size() - this.getRows() : boundedRangeModel.getValue();
        }
        return n;
    }

    protected boolean isShowHorizontalScrollBar(List list) {
        return list.size() > 0 && list.size() > this.getRows();
    }

    public boolean isShowHorisontalScrollBar() {
        List list = this.getClusterTbl().getViewOrganismCodeList();
        return list.size() > 0 && list.size() > this.ppmContext.getColumns();
    }

    public void updateStartColumn() {
        this.ppmContext.setColumn(this.calcColumn());
    }

    public void updateScrollBar() {
        this.updateVirticalScrollBar();
        this.updateHorisontalScrollBar();
    }

    public void updateHorisontalScrollBar() {
        List list = this.getClusterTbl().getViewOrganismCodeList();
        this.getMediator().setClusterHScrollBar(this.isShowHorisontalScrollBar(), this.ppmContext.getColumn(), this.ppmContext.getColumns(), list.size());
    }

    private int calcColumn() {
        int n = 0;
        List list = this.getClusterTbl().getViewOrganismCodeList();
        if (list.size() > 0 && list.size() > this.ppmContext.getColumns() && this.getMediator().isClusterHScrollBarVisible()) {
            n = (int)(this.ppmContext.getViewportX0() + 0.5);
            int n2 = (int)this.ppmContext.getCenterX();
            if (n2 > list.size()) {
                n2 = this.ppmContext.getColumns() / 2 + this.ppmContext.getColumn();
            }
            if (n + this.ppmContext.getColumns() > list.size()) {
                n = list.size() - this.ppmContext.getColumns();
            }
            if (n + this.ppmContext.getColumns() - 1 < n2) {
                n = n2 - this.ppmContext.getColumns() + 1;
            }
        }
        return n < 0 ? 0 : n;
    }

    private int _calcColumn() {
        BoundedRangeModel boundedRangeModel;
        List list = this.getClusterTbl().getViewOrganismCodeList();
        int n = list.size() > 0 && list.size() > this.ppmContext.getColumns() && this.getMediator().isClusterHScrollBarVisible() ? ((boundedRangeModel = (BoundedRangeModel)this.getMediator().getClusterHScrollBarModel()).getValue() + this.ppmContext.getColumns() > list.size() ? list.size() - this.ppmContext.getColumns() : boundedRangeModel.getValue()) : 0;
        return n;
    }

    protected MediatorImpl getMediator() {
        return this.ppmContext.getMediator();
    }

    protected ClusterTbl getClusterTbl() {
        return this.ppmContext.getClusterTbl();
    }

    protected int getRows() {
        return this.ppmContext.getRows();
    }

    protected int getStartRow() {
        return this.ppmContext.getStartRow();
    }

    protected void setStartRow(int n) {
        this.ppmContext.setStartRow(n);
    }
}

