/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.project;

import cgdp.recog.filefilter.FileFilterFactory;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.MutableComboBoxModel;
import javax.swing.filechooser.FileFilter;

public class FilterComboBoxModel
extends AbstractListModel
implements MutableComboBoxModel {
    private List filterList = new ArrayList();
    private FileFilter selectedFilter;

    public FilterComboBoxModel() {
        this.createFileFilter();
    }

    private void createFileFilter() {
        this.filterList.add(FileFilterFactory.createDomClustFileFilter());
        this.filterList.add(FileFilterFactory.createCoreGenomeFileFilter());
        this.filterList.add(FileFilterFactory.createAllRecogFileFilter());
        this.selectedFilter = (FileFilter)this.filterList.get(0);
    }

    public Object getSelectedItem() {
        return this.selectedFilter;
    }

    public void setSelectedItem(Object object) {
        if (object instanceof FileFilter) {
            this.selectedFilter = (FileFilter)object;
        }
    }

    public Object getElementAt(int n) {
        FileFilter fileFilter = (FileFilter)this.filterList.get(n);
        return fileFilter;
    }

    public int getSize() {
        return this.filterList.size();
    }

    public void addElement(Object object) {
        this.filterList.add(object);
        this.fireIntervalAdded(this, this.filterList.size(), this.filterList.size());
    }

    public void insertElementAt(Object object, int n) {
        this.filterList.add(n, object);
        this.fireIntervalAdded(this, n, n);
    }

    public void removeElement(Object object) {
        int n = this.filterList.indexOf(object);
        if (n != -1) {
            this.filterList.remove(object);
            if (this.selectedFilter == object) {
                this.selectedFilter = null;
            }
            this.fireIntervalRemoved(this, n, n);
        }
    }

    public void removeElementAt(int n) {
        Object e = this.filterList.remove(n);
        if (e != null) {
            if (this.selectedFilter == e) {
                this.selectedFilter = null;
            }
            this.fireIntervalRemoved(this, n, n);
        }
    }
}

