/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.project;

import cgdp.recog.bean.Const;
import cgdp.recog.coregenome.CoreGenomeFileUtil;
import cgdp.recog.domclust.DomClustFileUtil;
import cgdp.recog.hcluster.HClustUtil;
import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.project.ProjectUtil;
import cgdp.recog.server.ServerTbl;
import cgdp.recog.set.cluster.ClusterSetFacade;
import cgdp.recog.system.property.ApplicationPropertyFacade;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.StringTool;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class Project {
    private static final ApplicationLogger logger = new ApplicationLogger(Project.class);
    private static final String NAME_DEFAUTL = "default";
    private static final String CLIENT_PROJECT_ID_PREFIX = "client_project_";
    private static final String SERVER_PROJECT_ID_PREFIX = "server_project_";
    private String projectId;
    private String projectName;
    private String description;
    private String serverUrl;
    private String directoryPath;
    private String downloadServerUrl = "";
    private String downloadServerProjectName = "";
    private boolean select;
    private List organismCodeList = new ArrayList();

    private Project() {
    }

    static Project createClientProject() {
        Project project = new Project();
        project.setProjectId(Project.createClientProjectId());
        project.setServerUrl(ServerTbl.getDefaultServerHost());
        return project;
    }

    static Project createServerProject() {
        Project project = new Project();
        project.setServerUrl(ServerTbl.getDefaultServerHost());
        return project;
    }

    private static String createClientProjectId() {
        return CLIENT_PROJECT_ID_PREFIX + System.currentTimeMillis();
    }

    public static String createServerProjectId(String string) {
        return SERVER_PROJECT_ID_PREFIX + string;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getProjectId4Server() {
        String string = "";
        if (this.isServer()) {
            string = this.getProjectId().substring(SERVER_PROJECT_ID_PREFIX.length());
            System.err.println(string);
            int n = string.lastIndexOf(95);
            string = string.substring(n + 1);
        }
        return string;
    }

    public void setProjectId(String string) {
        this.projectId = string;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String string) {
        this.projectName = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String string) {
        this.serverUrl = string;
    }

    public String getDirectoryPath() {
        if (StringTool.isNull(this.directoryPath)) {
            return "";
        }
        return Const.USER_PROJECT_PATH + File.separator + new File(this.directoryPath).getName() + File.separator;
    }

    public String getRootDirectoryPath() {
        if (StringTool.isNull(this.getDirectoryPath())) {
            return this.getDirectoryPath();
        }
        return new File(this.getDirectoryPath()).getParent();
    }

    public void setDirectoryPath(String string) {
        this.directoryPath = string;
    }

    public String getDownloadServerUrl() {
        return this.downloadServerUrl;
    }

    public void setDownloadServerUrl(String string) {
        this.downloadServerUrl = string;
    }

    public String getDownloadServerProjectName() {
        return this.downloadServerProjectName;
    }

    public void setDownloadServerProjectName(String string) {
        this.downloadServerProjectName = string;
    }

    public boolean isSelect() {
        return this.select;
    }

    public void setSelect(boolean bl) {
        this.select = bl;
    }

    public boolean isClient() {
        return !this.isServer();
    }

    public boolean isServer() {
        return this.getProjectId().startsWith(SERVER_PROJECT_ID_PREFIX);
    }

    public void setOrganismCodeList(List list) {
        this.organismCodeList = list;
    }

    public List getOrganismCodeList() {
        return this.organismCodeList;
    }

    public String getOrganismCodeString() {
        return StringTool.conbineStrList(this.getOrganismCodeList(), ",");
    }

    public static Project createDefaultProject() {
        Project project = Project.createClientProject();
        project.setProjectName(NAME_DEFAUTL);
        project.setDirectoryPath(ProjectUtil.getDefaultProjectDirpath());
        project.setServerUrl(ServerTbl.getDefaultServerHost());
        return project;
    }

    public boolean equalsName(String string) {
        if (string == null) {
            return false;
        }
        return this.getProjectName().equals(string);
    }

    public boolean equalsId(String string) {
        if (string == null) {
            return false;
        }
        return this.getProjectId().equals(string);
    }

    public boolean equalsServerId(String string) {
        if (string == null) {
            return false;
        }
        return this.getProjectId4Server().equals(string);
    }

    public boolean equalsProject(Project project) {
        if (project == null) {
            return false;
        }
        return this.getProjectId().equals(project.getProjectId());
    }

    public boolean equalsServerUrl(String string) {
        return ServerTbl.equalsServerUrl(this.getServerUrl(), string);
    }

    public boolean equalsDirectoryPath(Project project) {
        return this.getDirectoryPath().equals(project.getDirectoryPath());
    }

    public void renameDomClustFile(File file, File file2) throws Exception {
        if (file.exists() && !file.renameTo(file2)) {
            throw new Exception("Failed to rename file " + file.getName() + " to " + file2.getName());
        }
        ApplicationPropertyFacade.renameConfName(file, file2, this);
        ClusterSetFacade.getInstance().renameDomClustFileName(file, file2, this);
    }

    public void renameCoalnFile(File file, File file2) throws Exception {
        if (!file.renameTo(file2)) {
            throw new Exception("Failed to rename file " + file.getName() + " to " + file2.getName());
        }
    }

    public void deleteDomClustFile(File file) throws Exception {
        String string = null;
        String string2 = null;
        if (file.exists()) {
            string = DomClustFileUtil.getDomClustId(file.getAbsolutePath());
            string2 = DomClustFileUtil.getDomClustViewId(file.getAbsolutePath());
            if (!file.delete()) {
                throw new Exception("delete: failed to delete a file." + file.getAbsolutePath());
            }
        }
        ApplicationPropertyFacade.deleteByConfName(file, this);
        if (string == null) {
            return;
        }
        ApplicationPropertyFacade.deleteByClusterViewId(string, string2, this);
        HClustUtil.deleteFilesByViewId(this, string, string2);
        CoreGenomeFileUtil.deleteFilesByViewId(this, string, string2);
        ClusterSetFacade.getInstance().deleteByDomClustFileName(file, this);
        if (DomClustFileUtil.findDomClustFile(string, this) == null) {
            ApplicationPropertyFacade.deleteByDomClustId(string, this);
            HClustUtil.deleteFilesByClusterId(this, string);
            CoreGenomeFileUtil.deleteFilesByClustId(this, string);
            ClusterInfoFacade.getInstance().deleteClusterInfo(string, this);
            ClusterSetFacade.getInstance().deleteByDomClustId(string, this);
            File file2 = new File(this.getDirectoryPath() + string);
            if (file2.exists() && file2.canWrite()) {
                FileUtil.delete(file2);
                logger.info(file2.getAbsolutePath() + " was deleted.");
            }
        }
    }

    public void deleteCoalnFile(File file) throws Exception {
        if (!file.delete()) {
            throw new Exception("delete: failed to delete a file." + file.getAbsolutePath());
        }
    }
}

