/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.property;

import cgdp.recog.util.ReadOnlyTextArea;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class PropertyTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    protected int clickCountToStart = 1;
    private EditorDelegate delegate;
    private JComponent defaultEditorComponent;
    private EditorDelegate defaultDelegate;
    private ReadOnlyTextArea textArea;
    private JScrollPane textAreaScrollPane;
    private EditorDelegate textAreaDeligate;
    private Map editorComponentMap = new HashMap();
    private Map delegateMap = new HashMap();

    public PropertyTableCellEditor() {
        this.init();
    }

    public void init() {
        this.defaultEditorComponent = new JTextField();
        this.defaultDelegate = this.createTextFieldDelegate((JTextField)this.defaultEditorComponent);
        this.textArea = new ReadOnlyTextArea();
        this.textAreaScrollPane = new JScrollPane(this.textArea, 20, 30);
        this.textAreaDeligate = this.createTextAreaDelegate(this.textArea);
    }

    public void addComboBox(String string, JComboBox jComboBox) {
        this.editorComponentMap.put(string, jComboBox);
        this.delegateMap.put(string, this.createComboBoxDelegate(jComboBox));
    }

    public void addTextArea(String string) {
        this.editorComponentMap.put(string, this.textAreaScrollPane);
        this.delegateMap.put(string, this.textAreaDeligate);
    }

    private EditorDelegate createTextFieldDelegate(final JTextField jTextField) {
        this.clickCountToStart = 2;
        EditorDelegate editorDelegate = new EditorDelegate(){

            public void setValue(Object object) {
                jTextField.setText(object != null ? object.toString() : "");
            }

            public Object getCellEditorValue() {
                return jTextField.getText();
            }
        };
        jTextField.addActionListener(editorDelegate);
        return editorDelegate;
    }

    private EditorDelegate createTextAreaDelegate(final JTextArea jTextArea) {
        this.clickCountToStart = 2;
        EditorDelegate editorDelegate = new EditorDelegate(){

            public void setValue(Object object) {
                jTextArea.setText(object != null ? object.toString() : "");
            }

            public Object getCellEditorValue() {
                return jTextArea.getText();
            }
        };
        return editorDelegate;
    }

    private EditorDelegate createComboBoxDelegate(final JComboBox jComboBox) {
        jComboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        EditorDelegate editorDelegate = new EditorDelegate(){

            public void setValue(Object object) {
                jComboBox.setSelectedItem(object);
            }

            public Object getCellEditorValue() {
                return jComboBox.getSelectedItem();
            }

            public boolean shouldSelectCell(EventObject eventObject) {
                if (eventObject instanceof MouseEvent) {
                    MouseEvent mouseEvent = (MouseEvent)eventObject;
                    return mouseEvent.getID() != 506;
                }
                return true;
            }

            public boolean stopCellEditing() {
                if (jComboBox.isEditable()) {
                    jComboBox.actionPerformed(new ActionEvent(PropertyTableCellEditor.this, 0, ""));
                }
                return super.stopCellEditing();
            }
        };
        jComboBox.addActionListener(editorDelegate);
        return editorDelegate;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        String string = (String)jTable.getValueAt(n, 0);
        JComponent jComponent = (JComponent)this.editorComponentMap.get(string);
        this.delegate = (EditorDelegate)this.delegateMap.get(string);
        if (jComponent == null) {
            jComponent = this.defaultEditorComponent;
            this.delegate = this.defaultDelegate;
        } else if (jComponent == this.textAreaScrollPane) {
            this.textArea.setFont(jTable.getFont());
        }
        this.delegate.setValue(object);
        return jComponent;
    }

    public void cancelCellEditing() {
        this.delegate.cancelCellEditing();
    }

    public Object getCellEditorValue() {
        return this.delegate.getCellEditorValue();
    }

    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() >= this.clickCountToStart;
        }
        return true;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return this.delegate.shouldSelectCell(eventObject);
    }

    public boolean stopCellEditing() {
        return this.delegate.stopCellEditing();
    }

    protected class EditorDelegate
    implements ActionListener,
    ItemListener,
    Serializable {
        protected Object value;

        protected EditorDelegate() {
        }

        public Object getCellEditorValue() {
            return this.value;
        }

        public void setValue(Object object) {
            this.value = object;
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        public boolean startCellEditing(EventObject eventObject) {
            return true;
        }

        public boolean stopCellEditing() {
            PropertyTableCellEditor.this.fireEditingStopped();
            return true;
        }

        public void cancelCellEditing() {
            PropertyTableCellEditor.this.fireEditingCanceled();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.stopCellEditing();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            this.stopCellEditing();
        }
    }
}

