/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.propvect;

import cgdp.recog.propvect.CalcDistancePhyloPat;
import cgdp.recog.propvect.PhyloPat;

class CalcHyperGeometricProbPhyloPat
extends CalcDistancePhyloPat {
    static int[][] McutCache;
    static double[] lnFact;

    CalcHyperGeometricProbPhyloPat(int n, double d) {
        super(n);
        this.calcLnFact(this.length);
        this.calcCache(n, d);
    }

    double calc(PhyloPat phyloPat, PhyloPat phyloPat2) throws RuntimeException {
        int n;
        int n2 = phyloPat.count();
        if (McutCache[n2][n = phyloPat2.count()] > Math.min(n2, n)) {
            return Double.MAX_VALUE;
        }
        int n3 = phyloPat.countMatch(phyloPat2);
        if (McutCache[n2][n] > n3) {
            return Double.MAX_VALUE;
        }
        return this.calc_hgprob(this.length, n2, n, n3);
    }

    double calc_hgprob(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        double d = 0.0;
        boolean bl = false;
        int n7 = n6 = n2 <= n3 ? n2 : n3;
        if ((double)n4 < (double)n6 / 2.0) {
            n5 = n2 + n3 - n > 0 ? n2 + n3 - n : 0;
            n6 = n4;
            bl = true;
        } else {
            n5 = n4;
        }
        for (int i = n5; i <= n6; ++i) {
            d += this.hypergeometric(n, n2, n3, i);
        }
        if (bl) {
            d = 1.0 - d;
        }
        return d;
    }

    double hypergeometric(int n, int n2, int n3, int n4) {
        return this.comb(n2, n4) * this.comb(n - n2, n3 - n4) / this.comb(n, n3);
    }

    double comb(int n, int n2) {
        if (n < n2) {
            return -1.0;
        }
        return Math.exp(lnFact[n] - lnFact[n - n2] - lnFact[n2]);
    }

    void calcLnFact(int n) {
        lnFact = new double[n + 1];
        CalcHyperGeometricProbPhyloPat.lnFact[0] = 0.0;
        for (int i = 1; i <= n; ++i) {
            CalcHyperGeometricProbPhyloPat.lnFact[i] = lnFact[i - 1] + Math.log(i);
        }
    }

    void calcCache(int n, double d) {
        McutCache = new int[n + 1][n + 1];
        for (int i = 0; i <= n; ++i) {
            block1: for (int j = 0; j <= n; ++j) {
                CalcHyperGeometricProbPhyloPat.McutCache[i][j] = Integer.MAX_VALUE;
                for (int k = 0; k <= Math.min(i, j); ++k) {
                    double d2 = this.calc_hgprob(n, i, j, k);
                    if (!(d2 <= d)) continue;
                    CalcHyperGeometricProbPhyloPat.McutCache[i][j] = k;
                    continue block1;
                }
            }
        }
    }
}

